package jp.ossc.petstore.function.impl;

import java.util.List;

import jp.ossc.petstore.function.ICategoryFanction;
import jp.ossc.petstore.function.impl.BaseFunction;
import jp.ossc.petstore.dao.ICategoryDAO;
import jp.ossc.petstore.dto.functiondto.CategoryFunctionDTO;
import jp.ossc.petstore.OpenstandiaConst;

/**
 * JeSt@NVNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class CategoryFunction extends BaseFunction implements ICategoryFanction {

	/**
	 * JeSc`n
	 */
	private ICategoryDAO categoryDAO;
	
	/**
	 * JeSc`nݒ
	 * @param categoryDAO JeSc`n
	 */
	public void setCategoryDAO(ICategoryDAO categoryDAO) {
		this.categoryDAO = categoryDAO;
	}

	
	/* ( Javadoc)
	 * @see jp.ossc.petstore.function.ICategoryFanction#getCategoryList(jp.ossc.petstore.dto.functiondto.CategoryFunctionDTO)
	 */
	public void getCategoryList(CategoryFunctionDTO dto) {
		
		List list = categoryDAO.getCategoryList();
		
		if (list.isEmpty()) {
			dto.setStatus(OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND);
		}
		
		dto.setCategoryList(list);
	}

	
	/* ( Javadoc)
	 * @see jp.ossc.petstore.function.ICategoryFanction#getMinCategoryId(jp.ossc.petstore.dto.functiondto.CategoryFunctionDTO)
	 */
	public void getMinCategoryId(CategoryFunctionDTO dto) {

		String categoryId = categoryDAO.getMinCategoryId();
		
		if (categoryId == null) {
			dto.setStatus(OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND);
		}
		
		dto.setCategoryId(categoryId);
	}

}
