package jp.ossc.petstore.function.impl;

import jp.ossc.petstore.dao.ICustomerDAO;
import jp.ossc.petstore.function.ICustomerFunction;
import jp.ossc.petstore.function.impl.BaseFunction;
import jp.ossc.petstore.model.Customer;
import jp.ossc.petstore.dto.functiondto.CustomerFunctionDTO;
import jp.ossc.petstore.OpenstandiaConst;

/**
 * ڋqt@NVNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class CustomerFunction extends BaseFunction implements ICustomerFunction {

    /**
     * ڋq擾c`n
     */
    private ICustomerDAO customerDAO;

    /**
     * ڋq擾c`nݒ
     * @param customerDAO ڋq擾c`n
     */
    public void setCustomerDAO(ICustomerDAO customerDAO) {
        this.customerDAO = customerDAO;
    }


	/* ( Javadoc)
	 * @see jp.ossc.petstore.function.ICustomerFunction#executeUserAuthentication(jp.ossc.petstore.dto.functiondto.CustomerFunctionDTO)
	 */
	public void executeUserAuthentication(CustomerFunctionDTO dto) {
		
		Customer customer = customerDAO.getCustomer(dto.getUserId(), dto.getPassword());
		
		if (customer == null) {
			// Xe[^Xݒ
			dto.setStatus(OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND);
		}
		
		dto.setCustomer(customer);
		
	}
    
    
	/* ( Javadoc)
	 * @see jp.ossc.petstore.function.ICustomerFunction#getCustomer(jp.ossc.petstore.dto.functiondto.CustomerFunctionDTO)
	 */
	public void getCustomer(CustomerFunctionDTO dto) {
		
		String userId = dto.getUserId();
		Customer customer = customerDAO.getCustomer(userId);
		
		if (customer == null) {
			// Xe[^Xݒ
			dto.setStatus(OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND);
		}
		
		dto.setCustomer(customer);
	}

}
