package jp.ossc.petstore.function.impl;

import java.util.List;

import jp.ossc.petstore.common.CartItem;
import jp.ossc.petstore.function.IOrderFunction;
import jp.ossc.petstore.function.impl.BaseFunction;
import jp.ossc.petstore.dao.IOrderDAO;
import jp.ossc.petstore.dao.IOrderDetailDAO;
import jp.ossc.petstore.dto.functiondto.OrderFunctionDTO;
import jp.ossc.petstore.model.Order;

/**
 * t@NVNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class OrderFunction extends BaseFunction implements IOrderFunction {

	/**
	 * c`n
	 */
	private IOrderDAO orderDAO;

	/**
	 * ׏c`n
	 */
	private IOrderDetailDAO orderDetailDAO;


	/**
	 * c`nݒ
	 * @param orderDAO c`n
	 */
	public void setOrderDAO(IOrderDAO orderDAO) {
		this.orderDAO = orderDAO;
	}

	/**
	 * ׏c`nݒ
	 * @param orderDetailDAO ׏c`n
	 */
	public void setOrderDetailDAO(IOrderDetailDAO orderDetailDAO) {
		this.orderDetailDAO = orderDetailDAO;
	}

	/* ( Javadoc)
	 * @see jp.ossc.petstore.function.IOrderFunction#insertOrder(jp.ossc.petstore.dto.functiondto.OrderFunctionDTO)
	 */
	public void insertOrder(OrderFunctionDTO dto) {
		
		// o^
		Order order = orderDAO.insertOrder(dto.getCustomer());

		// ׏o^
		List<CartItem> list = dto.getCart().getItemList();
		for (CartItem item : list) {
			orderDetailDAO.insertOrderDetail(order, item.getProduct(), item.getQuantity());
		}

		// hcݒ
		dto.setOrderId(String.valueOf(order.getId()));
	}

}
