package jp.ossc.petstore.peer.impl;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;

import jp.ossc.petstore.dto.BaseDTO;
import jp.ossc.petstore.dto.peerdto.LoginPeerDTO;
import jp.ossc.petstore.dto.functiondto.CustomerFunctionDTO;
import jp.ossc.petstore.function.ICustomerFunction;
import jp.ossc.petstore.peer.IPeer;
import jp.ossc.petstore.peer.impl.BasePeer;
import jp.ossc.petstore.OpenstandiaConst;

/**
 * OCpeerNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class LoginPeer extends BasePeer implements IPeer {

    /**
     * OCt@NV
     */
    private ICustomerFunction customerFunction;
    
    /**
     * OCt@NVݒ
     * @param function OCt@NV
     */
    public void setCustomerFunction(ICustomerFunction function) {
        this.customerFunction = function;
    }

    /**
     * OCƖsB<br>
     * ̓p[^u[UhcvupX[hvƂɌڋq擾B<br>
     * ڋq񂪎擾łȂꍇ̓G[bZ[Wݒ肷B
     * @param dto DTOIuWFNg
     */
	public void execute(BaseDTO dto) {
		
		// DTOLXg
		LoginPeerDTO loginPeerDTO = (LoginPeerDTO)dto;
		
		// ActionForm擾
		DynaActionForm dynaActionForm = (DynaActionForm)loginPeerDTO.getActionForm();
		
		// CustomerFunctionDTO̐
		CustomerFunctionDTO customerFunctionDTO = new CustomerFunctionDTO();
		customerFunctionDTO.setUserId((String)dynaActionForm.get("user_id"));
		customerFunctionDTO.setPassword((String)dynaActionForm.get("password"));
		
		// [UF؎s
		customerFunction.executeUserAuthentication(customerFunctionDTO);
		
		// Xe[^X`FbN
		if (customerFunctionDTO.getStatus() == OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND) {
			
			// Xe[^Xݒ
			loginPeerDTO.setStatus(customerFunctionDTO.getStatus());
			
			// G[bZ[Wݒ
			ActionMessage msg = new ActionMessage("errors.login");
			ActionMessages msgs = new ActionMessages();
			msgs.add("Login", msg);
			loginPeerDTO.setActionMessages(msgs);
		}
		
		// ڋqݒ
		loginPeerDTO.setCustomer(customerFunctionDTO.getCustomer());
		
	}

}
