package jp.ossc.petstore.peer.impl;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;

import jp.ossc.petstore.OpenstandiaConst;
import jp.ossc.petstore.function.IProductFunction;
import jp.ossc.petstore.peer.IPeer;
import jp.ossc.petstore.peer.impl.BasePeer;
import jp.ossc.petstore.dto.BaseDTO;
import jp.ossc.petstore.dto.functiondto.ProductFunctionDTO;
import jp.ossc.petstore.dto.peerdto.ShowProductDetailPeerDTO;

/**
 * iו\peerNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class ShowProductDetailPeer extends BasePeer implements IPeer {

	/**
	 * it@NV
	 */
	private IProductFunction productFunction;
	
	/**
	 * it@NVݒ
	 * @param productFunction it@NV
	 */
	public void setProductFunction(IProductFunction productFunction) {
		this.productFunction = productFunction;
	}


	/**
	 * iו\Ɩs<br>
     * ̓p[^uihcvƂɏi擾B<br>
     * i񂪎擾łȂꍇ̓G[bZ[Wݒ肷B
	 * @param dto DTOIuWFNg
	 */
	public void execute(BaseDTO dto) {
		
		// DTOLXg
		ShowProductDetailPeerDTO showProductDetailPeerDTO = (ShowProductDetailPeerDTO)dto;

		// ActionForm擾
		DynaActionForm dynaActionForm = (DynaActionForm)showProductDetailPeerDTO.getActionForm();

		// ihc擾
		String productId = (String)dynaActionForm.get("product_id");
		
		// ProductFunctionDTO
		ProductFunctionDTO productFunctionDTO = new ProductFunctionDTO();
		productFunctionDTO.setProductId(productId);
		
		// i擾
		productFunction.getProduct(productFunctionDTO);

		// Xe[^X`FbN
		if (productFunctionDTO.getStatus() == OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND) {
			
			// Xe[^Xݒ
			showProductDetailPeerDTO.setStatus(productFunctionDTO.getStatus());
			
			// G[bZ[Wݒ
			ActionMessage msg = new ActionMessage("errors.product.product_not_exist", productId);
			ActionMessages msgs = new ActionMessages();
			msgs.add("ShowProductDetail", msg);
			showProductDetailPeerDTO.setActionMessages(msgs);
		}

		// iݒ
		showProductDetailPeerDTO.setProduct(productFunctionDTO.getProduct());
	}

}
