package jp.ossc.petstore.peer.impl;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;

import jp.ossc.petstore.OpenstandiaConst;
import jp.ossc.petstore.peer.IPeer;
import jp.ossc.petstore.peer.impl.BasePeer;
import jp.ossc.petstore.dto.BaseDTO;
import jp.ossc.petstore.function.IProductFunction;
import jp.ossc.petstore.dto.peerdto.ShowProductPeerDTO;
import jp.ossc.petstore.dto.functiondto.ProductFunctionDTO;

/**
 * iꗗ\peerNX
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class ShowProductPeer extends BasePeer implements IPeer {

	/**
	 * it@NV
	 */
	private IProductFunction productFunction;
	
	/**
	 * it@NVݒ
	 * @param productFunction it@NV
	 */
	public void setProductFunction(IProductFunction productFunction) {
		this.productFunction = productFunction;
	}

	/**
	 * iꗗ\Ɩs<br>
     * ̓p[^uJeShcvƂɏi񃊃Xg擾B<br>
     * i񃊃Xg擾łȂꍇ̓G[bZ[Wݒ肷B
	 * @param dto DTOIuWFNg
	 */
	public void execute(BaseDTO dto) {
		
		// DTOLXg
		ShowProductPeerDTO showProductPeerDTO = (ShowProductPeerDTO)dto;
		
		// ActionForm擾
		DynaActionForm dynaActionForm = (DynaActionForm)showProductPeerDTO.getActionForm();
		
		// JeShc擾
		String categoryId = (String)dynaActionForm.get("category_id");
		
		// ProductFunctionDTO
		ProductFunctionDTO productFunctionDTO = new ProductFunctionDTO();
		productFunctionDTO.setCategoryId(categoryId);
		
		// iꗗ擾
		productFunction.getProductList(productFunctionDTO);
		
		// Xe[^X`FbN
		if (productFunctionDTO.getStatus() == OpenstandiaConst.ENV_STATUS_DATA_NOT_FOUND) {
			
			// Xe[^Xݒ
			showProductPeerDTO.setStatus(productFunctionDTO.getStatus());
			
			// G[bZ[Wݒ
			ActionMessage msg = new ActionMessage("errors.category.product_not_exist", categoryId);
			ActionMessages msgs = new ActionMessages();
			msgs.add("ShowProduct", msg);
			showProductPeerDTO.setActionMessages(msgs);

		}
		
		// iꗗݒ
		showProductPeerDTO.setProductList(productFunctionDTO.getProductList());
	}

}
