package jp.ossc.petstore.util.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.Globals;

import jp.ossc.petstore.OpenstandiaConst;

/**
 * OC`FbNtB^
 * @author ossc
 * @version $Revision: 1.2 $
 */
public class CheckLoginFilter implements Filter {

	/**
	 * p[^ږFG[̃tH[hy[W
	 */
	private static final String INIT_PARAM_NAME_FORWARD_PAGE = "forwardPage";
	
	/**
	 * p[^ږF`FbNΏۊÕANV
	 */
	private static final String INIT_PARAM_NAME_SKIP_ACTION = "skipAction";
	
	/**
	 * G[bZ[W
	 */
	private static final String ERR_MSG_INIT_PARAM_NOT_EXIST = "init-param is not exist :";

	/**
	 * OC`FbNG[bZ[WL[
	 */
	private static final String ERR_MSG_KEY_NOT_LOGIN = "errors.not_authenticated";

	/**
	 * 󕶎
	 */
	private static final String EMPTY_STR = "";
	
	/**
	 * XbV
	 */
	private static final String SLASH = "/";
	
	/**
	 * p[^؂蕶
	 */
	private static final String INIT_PARAM_DELIM = ",";
	
	/**
	 * G[̃tH[hy[W
	 */
    private String forwardPage = null;

    /**
     * `FbNΏۊÕANV
     */
    private String[] skipActions = null;
    
    
    /**
     * J
     */
    public void destroy() {
        this.forwardPage = null;
    }

    /**
     * 
     * @exception RuntimeException p[^uforwardPagevݒ肳ĂȂꍇ
     */
    public void init(FilterConfig filterConfig) throws ServletException {

    	// G[̃tH[hy[W̎擾
        String forwardPage = filterConfig.getInitParameter(INIT_PARAM_NAME_FORWARD_PAGE);
        if (forwardPage == null || forwardPage.trim().equals(EMPTY_STR)) {
        	throw new RuntimeException(ERR_MSG_INIT_PARAM_NOT_EXIST + INIT_PARAM_NAME_FORWARD_PAGE);
        } else {
            this.forwardPage = forwardPage.trim();
        }
        
        // `FbNΏۊÕANV̎擾
        String skipAction = filterConfig.getInitParameter(INIT_PARAM_NAME_SKIP_ACTION);
        if (skipAction != null && !skipAction.trim().equals(EMPTY_STR)) {
        	this.skipActions = parseParams(skipAction);
        }
    }


    /**
     * tB^<br>
     * `FbNΏۊÕANV̏ꍇ͏IB<br>
     * ZbV݂ȂꍇA܂̓ZbVɌڋq񂪓o^ĂȂꍇ
     * w肳ꂽy[WɃtH[hB<br>
     */
    public void doFilter(
    		ServletRequest request,
    		ServletResponse response,
    		FilterChain chain)
    throws IOException, ServletException {

    	// HttpServletRequestɃLXg
    	HttpServletRequest httpServletRequest = (HttpServletRequest)request;
    	
    	// ServletPath擾
    	String servletPath = httpServletRequest.getServletPath();
    	
    	// `FbNΏۊÕANV̏ꍇ͏I
    	if (isSkipAction(servletPath)) {
    		chain.doFilter(request, response);
    		return;
    	}
    	
    	// ZbV擾
    	HttpSession session = httpServletRequest.getSession(false);
    	
    	// ڋq񂪃ZbVɓo^Ăꍇ͂nj
    	if (session != null
    		&& session.getAttribute(OpenstandiaConst.ENV_SES_ATRBT_CUSTOMER) != null) {
            chain.doFilter(request, response);
    		
    	} else {
			// G[bZ[Wݒ
			ActionMessage msg = new ActionMessage(ERR_MSG_KEY_NOT_LOGIN);
			ActionMessages msgs = new ActionMessages();
			msgs.add("Login", msg);
			httpServletRequest.setAttribute(Globals.MESSAGE_KEY, msgs);

			// w肳ꂽy[WɃtH[h
    		httpServletRequest.getRequestDispatcher(forwardPage).forward(request, response);
    	}
    }

    
	/**
	 * J}؂ŗ^ꂽp[^AJ}ŋ؂ĔzɂĕԂB<br>
	 * 󔒕trimB<br>
	 * @param str J}؂ŘAꂽp[^
	 * @return ꂽp[^i[ꂽz
	 */
	protected String[] parseParams(String str) {
		
		List<String> params = new ArrayList<String>();
		StringTokenizer stringTokenizer = new StringTokenizer(str, INIT_PARAM_DELIM);
		String token = null;

		while (stringTokenizer.hasMoreTokens()) {
			token = stringTokenizer.nextToken().trim();
			if (token.length() == 0) {
				continue;
			}
			params.add(token);
		}

		return (String[])params.toArray(new String[0]);
	}

	
	/**
	 * ΏۊOANV
	 * @param T[ubgpX
	 * @return true:ΏۊOANV̏ꍇAfalse:ΏۃANV̏ꍇ
	 */
	protected boolean isSkipAction(String servletPath) {

		boolean result = false;

		if (skipActions == null) {
			return result;
		}

		String action = servletPath.substring(servletPath.lastIndexOf(SLASH));
		
		for (String skipAction : skipActions) {
			if (action.equals(skipAction)) {
				result = true;
				break;
			}
		}
		
		return result;
	}

}
