SET NAMES CP932;

DROP TABLE IF EXISTS `order_details`;
DROP TABLE IF EXISTS `orders`;
DROP TABLE IF EXISTS `customers`;
DROP TABLE IF EXISTS `products`;
DROP TABLE IF EXISTS `categories`;


CREATE TABLE `categories` (
  `id` int(8) NOT NULL,
  `name` varchar(128) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=CP932;

INSERT INTO `categories` VALUES (1,'^'),(2,'^'),(3,'^'),(9,'̑');


CREATE TABLE `products` (
  `id` int(8) NOT NULL,
  `name` varchar(128) default NULL,
  `category_id` int(8) default NULL,
  `price` int(32) default NULL,
  `image` varchar(128) default NULL,
  `explanation` varchar(512) default NULL,
  PRIMARY KEY  (`id`),
  KEY `category_id` (`category_id`),
  CONSTRAINT `products_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=CP932;

INSERT INTO `products` VALUES
 (1001,'[NV[eA',1,15000,'s_dog01.jpg','̖O̒ʂCMX̃[NV[n̔ɐBƂɂoꂽтƏ^̃TCY̓΂ƂقǐlCłB')
,(1002,'V[Y[',1,17700,'s_dog02.jpg','_ЂȂǂ̂鍝̌`ƂĂ钆̍cɑX󂯌pĂĵ錢łB')
,(1003,'v[h',1,20000,'s_dog03.jpg','ɒZ߂̓AⒷ߂ɒfꂽAƂ܂߂̊AlXȌ`ɓOɃg~Oꂽp͖͓IłB')
,(1004,'_bNXth',1,12000,'s_dog04.jpg','Z̑㖼ɂȂ邭炢̃j[Nȑ̌^łB')
,(1005,'ps',1,40000,'s_dog05.jpg','̗̂̂킢qłBƂ񂿂łAĂĖO܂B')
,(1006,'}^eA',1,17700,'s_dog06.jpg','ƂȂ킢eAłB̐i͎Ă̂y݁B')
,(1007,'~j`AViEU[',1,18000,'s_dog07.jpg','qQ̐VBł͂ȂƂƂӂӂт̏ViEU[B')

,(2001,'R[M[',2,5000,'m_dog01.jpg','CMX̖qrƂĎ鎨̃sƂZ̈̂̌^łB傫񂿂ȐiňčbNo.1łB')
,(2002,'Ō',2,30000,'m_dog02.jpg','SA҂̎ČłBDł񂿂ȐiłB')
,(2003,'uhbO',2,25000,'m_dog03.jpg','|ȊƓ̂邪Ƃ̂Ŕ͂܂B{NT[ƃZbgłł傤B')
,(2004,'{NT[',2,25000,'m_dog04.jpg','|ȊƓ̂邪Ƃ̂Ŕ͂܂BuhbOƃZbgłł傤B')
,(2005,'r[O',2,75000,'m_dog05.jpg','Õm̂悤ȕiƈЌAƂ̑̌^AOp̏߂̗AwɔwtTtTA߂̂ɂ{̑\ɑłB')
,(2006,'WbNbZeA',2,75000,'m_dog06.jpg','DSŌeAłB܂ԂȂ̂ŒZтłAlɂȂ璷тɂȂ܂B')
,(2007,'G',2,15000,'m_dog07.jpg','NŌG팢łBUDŉ^_oQłBAƂĂHӒnĂ̂ŁAEHɒӂĂB')

,(3001,'VFp[h',3,15000,'l_dog01.jpg','ƂĂ悭A鎖ȂÂȔfƍsł錢łB|o܂ȂԂł')
,(3002,'VxAnXL[',3,17700,'l_dog02.jpg','Â\A{[gAԌAƂĎ炳Ă܂BIɂ͖i鎖̏ȂƂȂłB')
,(3003,'_}VA',3,20000,'l_dog03.jpg','͂肵_SgĂ܂Bӂ͗Ăĉ₩łAɑ΂锽ɕqłB[SXrÃ_VAn̓yƂĂB')
,(3004,'h[x}',3,12000,'l_dog04.jpg','hCc̃h[x}oK[hhbORpƂĕ]A햼ɂȂ܂Bאg̋@qӂؓ̃X}[gȑ̌^ŐlC܂B')
,(3005,'vh[go[',3,25000,'l_dog05.jpg','aŐi悭AlɒAz悭ЌIŉƑvłBӓAAƂĂ􂵂Ă܂B')
,(3006,'zbghbO',3,200,'l_dog06.jpg','ƂĂMłBv킸ԂȂ邭炢AɃAJłȂĂ܂B')

,(9001,'CV',9,1000000,'other01.jpg','m̉ɑ̖ɂ̂ݏoƂCVB̋@𓦂ƓxƎɓȂAybgB')
,(9002,'qgf',9,3000,'other02.jpg','C̐Ƃ邱̃qgfBVɂΎ[܂ƂV̐삪q߂܂B')
,(9003,'',9,10000,'other03.jpg','₷ybgLONo.1BiƂ₩Ŗ邱Ƃ܂B')
;


CREATE TABLE `customers` (
  `id` int(16) NOT NULL AUTO_INCREMENT,
  `nickname` varchar(8) NOT NULL,
  `first_name` varchar(32) NOT NULL,
  `last_name` varchar(32) NOT NULL,
  `address1` varchar(64) NOT NULL,
  `address2` varchar(64) NOT NULL,
  `address3` varchar(64) NOT NULL,
  `address4` varchar(64) NOT NULL,
  `phone` varchar(12) NOT NULL,
  `mail` varchar(64) NOT NULL,
  `password` varchar(16) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=CP932;

INSERT INTO customers VALUES (1,'䂤','Dq','IN','啪','{Os','o','XX|P|P','00-0000-0001','yukorin@openstandia.ossc.org','1');
INSERT INTO customers VALUES (2,'','','','s','','{','XX|P|Q','00-0000-0002','aki-star@openstandia.ossc.org','2');
INSERT INTO customers VALUES (3,'','','Y','_ސ쌧','ls`k','g','XX|P|R','00-0000-0003','ayaya@openstandia.ossc.org','3');
INSERT INTO customers VALUES (4,'Ȃ','Ă݂','{','m','És','z','XX|P|S','00-0000-0004','nachi@openstandia.ossc.org','4');
INSERT INTO customers VALUES (5,'','G','R','_ސ쌧','lst','u','XX|P|T','00-0000-0005','moe@openstandia.ossc.org','5');

CREATE TABLE `orders` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `customer_id` int(16) default NULL,
  `purchase_date` timestamp,
  PRIMARY KEY  (`id`),
  KEY `customer_id` (`customer_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=CP932;


CREATE TABLE `order_details` (
  `id` int(16) NOT NULL AUTO_INCREMENT,
  `order_id` int(8) default NULL,
  `product_id` int(8) default NULL,
  `numbers` int(4) default NULL,
  PRIMARY KEY  (`id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `order_details_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`),
  CONSTRAINT `order_details_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=CP932;

