#!

@files	= <*.cpp>;
for(@files){
	$obj = $_;
	$obj =~ s/\.cpp$//;
	$obj{$_}="${obj}.t";
	push(@all,<<"EOS");

${obj}.t: ${obj}32.com ${obj}.com
	touch ${obj}.t

${obj}32.o: ${obj}.cpp ${obj}.o
	\$(CC) \$(CF32) \$(CFBASE) \$(CFINCLUDE) -o ${obj}32.o ${obj}.cpp

${obj}32.com: ${obj}32.o \$(STD32) \$(CRT32)
	\$(LD) \$(LF32) \$(LFBASE) -o ${obj}32.ld ${obj}32.o \$(CRT32) \$(LIB32)
	\$(OBJCOPY) -O elf32-i386 ${obj}32.ld ${obj}32.elf
	\$(ELF2COM) ${obj}32.elf ${obj}32.exe
	\$(BIM2BIN) -osacmp -tek1 BS:0 in:${obj}32.exe out:${obj}32.tek
	\$(BINDCOM) tek ../tools/sfx32.bin ${obj}32.tek ${obj}32.com

${obj}.com: ${obj}.o \$(STD32) \$(CRT32)
	\$(LD) \$(LF64) \$(LFBASE) -o ${obj}.elf ${obj}.o \$(CRT64) \$(LIB64)
	\$(ELF2COM) ${obj}.elf ${obj}.exe
	\$(BIM2BIN) -osacmp -tek1 BS:0 in:${obj}.exe out:${obj}.tek
	\$(BINDCOM) tek ../tools/sfx64.bin ${obj}.tek ${obj}.com

EOS
	open(FILE,"gcc -MM -I ../include $obj.cpp |");
	@lines = <FILE>;
	close(FILE);
	push(@all,@lines);
}

open(FILE,">Makefile");
binmode(FILE);
print FILE <<EOT;
include ../user/Makefile.inc

LIB64	= ../lib/pekoe64.a
CRT64	= ../lib/crt64.o
LIB32	= ../lib/pekoe32.a
CRT32	= ../lib/crt32.o
CFINCLUDE	= -I../include

.cpp.o:
	\$(CC) \$(CF64) \$(CFBASE) \$(CFINCLUDE) \$*.cpp

EOT
print FILE "all: " . join(" ",sort(values %obj)) . "\n\n";
print FILE "clean:\n\t-rm -f *.o *.elf *.com *.tek *.exe *.ld *.t \n\n";
print FILE @all;
close(FILE);
