
#include <windows.h>
#include <stdio.h>

struct COM64_basic_header {
	BYTE	compat[3];
	BYTE	signature[5];
	BYTE	flags,version,segments,osabi;
	DWORD	alloc_min;
};

struct	COM64_ver1_header {
	BYTE	compat,sfx_signature[3];
	DWORD	base,entry,imagesize;
};

struct COM64_segment_header {
	BYTE	flags,reserved[3];
	DWORD	limit,base,size;
};


static	LPCSTR	access_flags[]={"---","--x","-w-","-wx","r--","r-x","rw-","rwx"};

static void Copy(HANDLE hi,HANDLE ho,DWORD	size){
	const	int sz_buff=0x1000;
	static	BYTE buff[sz_buff];
	DWORD	p;
	int		s;
	for(s=size;s>0;s-=sz_buff){
		ReadFile(hi,buff,sz_buff<s?sz_buff:s,&p,NULL);
		WriteFile(ho,buff,p,&p,NULL);
	}
}

LPCSTR	getOSABI(int osabi){
	switch(osabi){
	case 0x00:
		return "unspecified os";
	case 0x01:
		return "DOS generic";
	case 0x02:
		return "OS Loader";
	case 0x50:
		return "OrangePekoe";
	case 0xFF:
		return "private abi";
	default:
		if(osabi>=0xC0)
			return "vender defined abi";
		else
			return "unknown os";
	}
}

int DumpCom(LPCSTR infile){

	HANDLE fi=CreateFile(infile,GENERIC_READ,0,NULL,OPEN_EXISTING,0,NULL);
	if(fi==INVALID_HANDLE_VALUE){
		printf("can't open: %s\n",infile);
		return 1;
	}

	COM64_basic_header		comheader;
	COM64_ver1_header		v1header;
	DWORD	p;
	int i;

	ReadFile(fi,&comheader,sizeof(COM64_basic_header),&p,0);
	ReadFile(fi,&v1header,sizeof(COM64_ver1_header),&p,0);

	if(
		memcmp(comheader.signature,"COM64",5)
		&&
		memcmp(comheader.signature,"COM32",5)
		){
		printf("bad executable\n");
		return 1;
	}
	printf("file format: COM64 version %d %s\n"
		,comheader.version
		,comheader.version?(comheader.segments?"COMedELF":"Simple Image"):"Core Image"
		);
	printf("architecture: %s, %s\n"
		,(comheader.flags&0x08)?"x86-64":((comheader.flags&0x04)?"i386":"unknown cpu")
		,getOSABI(comheader.osabi)
		);
	printf("flags: %02x\n%s%s%s%s%s%s"
		,comheader.flags
		,(comheader.flags&0x01)?"    image has CP/M stub\n":""
		,(comheader.flags&0x02)?"    image has DOS stub\n":""
		,(comheader.flags&0x04)?"    32bit executable\n":""
		,(comheader.flags&0x08)?"    64bit executable\n":""
		,(comheader.flags&0x40)?"    self-relocatable stub\n":""
		,(comheader.flags&0x80)?"    special format\n":""
		);
	printf("entry point: %08x \n"
		,(comheader.version==0)?0x1010:v1header.entry
		);

	if(!memcmp(v1header.sfx_signature,"SFX",3)){
		char sfx_magic[4];
		DWORD	srcsz,objsz;
		SetFilePointer(fi,(comheader.version+1)<<4,0,0);
		ReadFile(fi,sfx_magic,4,&p,0);
		ReadFile(fi,&srcsz,4,&p,0);
		objsz=GetFileSize(fi,0);
		printf("SFX type: %.4s source: %d compressed: %d ratio: %d%% \n",sfx_magic,srcsz,objsz,100*objsz/srcsz);
	}

	if(comheader.version){
		printf("\nSegments:\n");
		if(comheader.segments){
			COM64_segment_header	segheader;
			for(i=0;i<comheader.segments;i++){
				SetFilePointer(fi,(comheader.version+i+1)<<4,0,0);
				ReadFile(fi,&segheader,sizeof(COM64_segment_header),&p,0);
				if(segheader.flags&0x07){
					printf("    base %08x memsz %08x strmsz %08x flags %s\n"
						,segheader.base
						,segheader.limit
						,segheader.size
						,access_flags[segheader.flags]
						);
				}else{
					printf("    %s data: type %08x id %08x size %08x flags %08x\n"
						,(segheader.flags&0x08)?"extensible":"raw"
						,segheader.limit
						,segheader.base
						,segheader.size
						,*(DWORD*)&segheader
						);
				}
			}
		}else{
			printf("    base %08x memsz %08x strmsz %08x\n"
				,v1header.base
				,comheader.alloc_min
				,v1header.imagesize
				);
		}
	}

	return 0;
}


int main(int argc, char* argv[])
{
	if(argc<2){
		printf("usage: %s comfile\n",argv[0]);
		return 0;
	}
	return DumpCom(argv[1]);
}
