
#include <stdio.h>
#include <rpcss.h>
#include <sys/gbc.h>

byte cursor [16][16] = {
	{0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x10,0x0F,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x10,0x07,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x10,0x07,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x10,0x07,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x0F,0x10,0x00,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x0F,0x10,0x10,0x0F,0x0F,0x0F,0x0F,0x10,0x10,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x10,0x07,0x0f,0x10,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00,0x00},
	{0x00,0x00,0x10,0x10,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x10,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x10,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00},
	{0x00,0x00,0x10,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x10,0x10,0x00},
	{0x00,0x00,0x00,0x10,0x07,0x07,0x07,0x07,0x07,0x07,0x10,0x10,0x10,0x10,0x10,0x00},
	{0x00,0x00,0x00,0x00,0x10,0x10,0x07,0x07,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
};

int main(int argc,char** argv){
	int count;
	GSSTATUS	gs;
	MOUSE_PACKET packet;

	sys_gs_get_status(&gs);
	int x=gs.width/2,y=gs.height/2;

	gbc_destroy_cursor_block();
	printf("*** mouse test applet (hit any key to exit) ***\n");
	for(;!kbhit();sys_wait()){
		count=sys_fs_read(devid_rpcss,port_mouse,0,&packet,1);
		if(count>0){
			x+=packet.x;if(x<0) x=0;if(x>gs.width) x=gs.width;
			y+=packet.y;if(y<0) y=0;if(y>gs.height) y=gs.height;
			gbc_restore_cursor_block();
			gbc_save_cursor_block(x,y);
			gbc_blt_trans(8,x,y,16,16,cursor);
		}else if(count<0){
			printf("error: couldn't connect to mouse port.\n");
			return -1;
		}
	}
	gbc_restore_cursor_block();
	return 0;
}
