//
//	Interface for Character Device
//
#ifndef	__DEVICES_I_CHARACTER_DEVICE_H__
#define	__DEVICES_I_CHARACTER_DEVICE_H__

#include <OrangePekoe/Devices/IHidDevice.h>

namespace	OrangePekoe {

	namespace Devices {
		interface	IHidInputDevice;
		extern	IHidInputDevice& getKeyboardInstance(void);
	}
	namespace Events{
		interface	IHidEventHandler;
	}

	namespace Devices {
		interface	IHidInputDevice:public OrangePekoe::Devices::IHidDevice {
		protected:
			OrangePekoe::Events::IHidEventHandler*	delegate;
			IHidInputDevice():delegate(0) {}
		public:
			virtual	~IHidInputDevice(){}
			inline	void	set_EventHandler(OrangePekoe::Events::IHidEventHandler* p){ delegate=p; }
		};
	}
	namespace Events{
		interface	IHidEventHandler:public OrangePekoe::Events::IEventHandler {
		public:
			virtual	void OnButtonDown	(OrangePekoe::Devices::IHidInputDevice& src,int scancode,int shiftkey)=0;
			virtual	void OnButtonUp		(OrangePekoe::Devices::IHidInputDevice& src,int scancode,int shiftkey)=0;
		};
	}
}
#endif
