//
//	Interface for Pointer Device
//
#ifndef	__DEVICES_I_POINTER_DEVICE_H__
#define	__DEVICES_I_POINTER_DEVICE_H__

#include <OrangePekoe/Devices/IHidDevice.h>

namespace	OrangePekoe {

	namespace	Devices {
		interface	IPointerDevice;
		extern	IPointerDevice& getMouseInstance(void);
	}
	namespace	Events {
		interface	IPointerEventHandler;
	}

	namespace	Devices {
		interface	IPointerDevice:public OrangePekoe::Devices::IHidDevice {
		protected:
			OrangePekoe::Events::IPointerEventHandler*	delegate;
			byte*	cursor;
			int		left,top,width,height;
			int		x,y;
			uint32	button;
			int		dispflag;
			IPointerDevice():cursor(0),left(0),top(0),width(0),height(0),x(0),y(0),button(0),dispflag(0){}
		public:
			virtual	~IPointerDevice(){}
			virtual	void	hide()=0;
			virtual	void	show()=0;
			inline	void	set_EventHandler(OrangePekoe::Events::IPointerEventHandler* p){ delegate=p; }
			inline	int		get_X(){ return x; }
			inline	int		get_Y(){ return y; }
			inline	uint32	get_Button(){ return button; }
			inline	byte*	set_Cursor(byte* p){ return cursor=p; }
			inline	byte*	get_Cursor(){ return cursor; }
			inline	void	set_Bound(int x1,int y1){ left=0,top=0,width=x1,height=y1; }
			inline	void	set_Bound(int x1,int y1,int x2,int y2){ left=x1,top=y1,width=x2,height=y2; }
			inline	int		conditionalHide(int x1,int y1,int x2,int y2){
				int oldflag=dispflag;
				if(x>x1-16&&x<x2&&y>y1-16&&y<y2) hide();
				return oldflag;
			}
		};
	}
	namespace	Events {
		interface	IPointerEventHandler:public OrangePekoe::Events::IEventHandler {
		public:
			virtual	void OnMove(OrangePekoe::Devices::IPointerDevice& src,int x,int y)=0;
			virtual	void OnButtonDown(OrangePekoe::Devices::IPointerDevice& src,uint32 button,uint32 change)=0;
			virtual	void OnButtonUp(OrangePekoe::Devices::IPointerDevice& src,uint32 button,uint32 change)=0;
		};
	}
}

#endif
