//
//	OrangePekoe Objective Foundation Class
//
#ifndef	__SYSTEM_OBJECT_H__
#define	__SYSTEM_OBJECT_H__

#include <pekoe.h>

namespace System {

	class	Object;
	class	String;

	class	Object {
	protected:
		inline	Object(){}
	public:
		inline	virtual	~Object(){}
		inline	virtual	String	toString();
		inline	virtual	int		get_Hash(){ return (int)(intptr)this; }
		inline	virtual	bool	Equals(Object& o){ return &o==this; }
		inline	static	bool	Equals(Object& o,Object& p){ return o.Equals(p); }
	};

	class	String:public Object {
	protected:
		char*	content;
		int		length;
	public:
		inline	String():content(0),length(0) {}
		inline	String(const char* s):content(0),length(0) { set(s); }
		inline	~String(){ delete content; }
		String&	set(const char* s);
		String&	add(const String& o);
		inline	void	empty(){ set(NULL); }
		inline	String	toString() { return *this; }
		inline	int		get_Length() const { return length; }
		inline	char	operator[](int i) const { return content[i]; }
		inline	const	String&	operator=(const char* s){ set(s); return *this; }
	};

	inline	String Object::toString(){ return "[object]"; }

}

#endif
