
#include <pekoe.h>
#include <stdio.h>
#include <sys/rpcss.h>
#include <sys/gbc.h>
#include <OrangePekoe/Devices/IPointerDevice.h>

using namespace	OrangePekoe::Events;

namespace	OrangePekoe {
	namespace	Devices {

		byte my_cursor [16][16] = {
			{0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
			{0x10,0x0F,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
			{0x10,0x07,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
			{0x00,0x10,0x07,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
			{0x00,0x10,0x07,0x0F,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
			{0x00,0x00,0x10,0x07,0x0F,0x10,0x00,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00},
			{0x00,0x00,0x10,0x07,0x0F,0x10,0x10,0x0F,0x0F,0x0F,0x0F,0x10,0x10,0x00,0x00,0x00},
			{0x00,0x00,0x00,0x10,0x07,0x0f,0x10,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00,0x00},
			{0x00,0x00,0x10,0x10,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00},
			{0x00,0x00,0x10,0x07,0x10,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00},
			{0x00,0x00,0x10,0x07,0x10,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x00,0x00},
			{0x00,0x00,0x10,0x07,0x07,0x07,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x10,0x10,0x10,0x00},
			{0x00,0x00,0x00,0x10,0x07,0x07,0x07,0x07,0x07,0x07,0x10,0x10,0x10,0x10,0x10,0x00},
			{0x00,0x00,0x00,0x00,0x10,0x10,0x07,0x07,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00},
			{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00},
			{0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
		};

		class MouseDevice: public IPointerDevice {
			KMODE_SPINLOCK mouse_thread_alive;
			volatile int contflag;
			void ThreadProc();
			int drawflag;
		public:
			MouseDevice(){
		//		mts_puts("mouse ctor");
				GSSTATUS	gs;
				sys_gs_get_status(&gs);
				width=gs.width-1,height=gs.height-1,x=width/2,y=height/2;

				cursor=&my_cursor[0][0];

				contflag=1;
				sys_release_spinlock(&mouse_thread_alive);
				crtCreateThread(4080,mouse_thread_stub,this);
			}
			virtual ~MouseDevice();
			virtual	void hide();
			virtual	void show();
			friend	void mouse_thread_stub(void* dev);
		};


		void mouse_thread_stub(void* dev){
			MouseDevice* p=(MouseDevice*)dev;
			p->ThreadProc();
		}

		void MouseDevice::ThreadProc(){
			int count;
			MOUSE_PACKET packet;

			sys_acquire_spinlock(&mouse_thread_alive);
			for(;contflag;sys_wait()){
				do{
					count=sys_fs_read(devid_rpcss,port_mouse,0,&packet,1);
					if(count>0){
						x+=packet.x; if(x<left)	x=left;	if(x>=width)		x=width;
						y+=packet.y; if(y<top)	y=top;	if(y>=height)	y=height;
						button=packet.button;
						if(packet.x||packet.y){
							drawflag=1;
							if(delegate) delegate->OnMove(*this,x,y);
						}
						if(packet.button_change&packet.button_press)
							if(delegate) delegate->OnButtonDown(*this,button,packet.button_change&packet.button_press);
						if(packet.button_change&~packet.button_press)
							if(delegate) delegate->OnButtonUp(*this,button,packet.button_change&~packet.button_press);
					}
					if(dispflag&&drawflag){
						drawflag=0;
						gbc_restore_cursor_block();
						gbc_save_cursor_block(x,y);
						gbc_blt_trans(8,x,y,16,16,cursor);
					}
				}while(count);
			}
			sys_release_spinlock(&mouse_thread_alive);
		}

		MouseDevice::~MouseDevice(){
			contflag=0;
			sys_acquire_spinlock(&mouse_thread_alive);
			gbc_restore_cursor_block();
		//	mts_puts("mouse dtor");
		}

		void MouseDevice::hide(){
			dispflag=0;
			gbc_restore_cursor_block();
		}

		void MouseDevice::show(){
			dispflag=1;
			drawflag=1;
		}

		MouseDevice	myMouse;

		IPointerDevice& getMouseInstance(){
			return (IPointerDevice&)myMouse;
		}
	}
}
