
#include <pekoe.h>
#include <string.h>
#include <System/IO/Console.h>
#include <OrangePekoe/Devices/IHidInputDevice.h>

using namespace	System;
using namespace	System::IO;
using namespace	OrangePekoe::Devices;
using namespace	OrangePekoe::Events;

volatile	int contflag=1;

class myHidEventHandler: public IHidEventHandler {
public:
	void OnButtonDown	(IHidInputDevice& src,int scancode,int shiftkey){
		char	buff[16];
		ltoa(scancode&0xFF,buff,16);
		Console::println(buff);
	}
	void OnButtonUp		(IHidInputDevice& src,int scancode,int shiftkey){
		switch(scancode&0xFF){
		case 0:
			contflag=0;
		break;
		}
	}
};
myHidEventHandler myEvent;

int main(void){

	IHidInputDevice& keybd	= getKeyboardInstance();

	keybd.set_EventHandler(&myEvent);

	Console::println("*** keyboard test applet (hit esc key to exit) ***");
	for(;contflag;sys_wait()){}

	return 0;
}
