//
//	64bit kernel
//
//  program:
//		Sakky
//
//	platform:
//		AMD64
//
//	license:
//		BSD License
//

#define	puts	__kputs
#define	putchar	__kputchar
#define	printf	__kprintf

#include <pekoe.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>


struct __memstat {
	DWORD	acpiRecMemBase,acpiRecMemSize,acpiNVSMemBase,acpiNVSMemSize;
	DWORD	szMidMem,szHiMem;
	QWORD	szExtMem;
	WORD	szLowMem;
	WORD	_text_vram;
	WORD	_apm_ver;
	BYTE	_col,_row;
};

__memstat memstat;

int putchar(int c){
	switch(c){
	case '\n':
		memstat._col=0;
		memstat._row++;
		break;
	default:
		char* vram=(char*)(intptr)(memstat._text_vram<<4);
		vram[memstat._col*2+memstat._row*160]=c;
		memstat._col++;
	}
	return c;
}

static	char	printf_buffer[4096];
int	printf(const char* form,...){
	int r;
	va_list args;
	va_start(args,form);
	r=vsprintf(printf_buffer,form,args);
	for(int i=0;i<r;i++){
		putchar(printf_buffer[i]);
	}
	va_end(args);
	return r;
}


extern "C"
void start_kernel(const __memstat* m){
	memcpy(&memstat,m,sizeof(memstat));

	puts("OrangePekoe [Free version]\n(C)2004 The Open Source Software for OrangePekoe\n");
	printf("Memory: %dKB\n\n",(memstat.szMidMem+memstat.szHiMem+0x3FF)>>10);
	puts("Hello, 64bit world!\nok");

	for(;;){}
}
