/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PostLh5Encoder
implements PostLzssEncoder {
    private BitOutputStream out;
    private int DictionarySize;
    private int MaxMatch;
    private int Threshold;
    private int DictionarySizeByteLen;
    private int position;
    private int flagBit;
    private int flagPos;
    private int currentBlock;
    private byte[][] block;
    private int[] blockSize;
    private int[][] blockCodeFreq;
    private int[][] blockOffLenFreq;
    private int[][] pattern;
    private int[][] group;

    private PostLh5Encoder() {
    }

    public PostLh5Encoder(OutputStream out) {
        this(out, "-lh5-");
    }

    public PostLh5Encoder(OutputStream out, String method) {
        this(out, method, 16384);
    }

    public PostLh5Encoder(OutputStream out, String method, int BufferSize) {
        this(out, method, 1, BufferSize, 0);
    }

    /*
     * Unable to fully structure code
     */
    public PostLh5Encoder(OutputStream out, String method, int BlockNum, int BlockSize, int DivideNum) {
        super();
        if (!"-lh4-".equals(method) && !"-lh5-".equals(method) && !"-lh6-".equals(method) && !"-lh7-".equals(method)) ** GOTO lbl32
        this.DictionarySize = CompressMethod.toDictionarySize(method);
        this.MaxMatch = CompressMethod.toMaxMatch(method);
        this.Threshold = CompressMethod.toThreshold(method);
        this.DictionarySizeByteLen = (Bits.len(this.DictionarySize - 1) + 7) / 8;
        MinCapacity = (this.DictionarySizeByteLen + 1) * 8 + 1;
        if (out != null && BlockNum > 0 && DivideNum >= 0 && DivideNum < BlockNum && MinCapacity <= BlockSize) {
            this.out = out instanceof BitOutputStream != false ? (BitOutputStream)out : new BitOutputStream(out);
            this.currentBlock = 0;
            this.block = new byte[BlockNum][];
            this.blockSize = new int[BlockNum];
            this.blockCodeFreq = new int[BlockNum][];
            this.blockOffLenFreq = new int[BlockNum][];
            codeFreqSize = 256 + this.MaxMatch - this.Threshold + 1;
            offLenFreqSize = Bits.len(this.DictionarySize);
            i = 0;
            while (i < BlockNum) {
                this.block[i] = new byte[BlockSize];
                this.blockCodeFreq[i] = new int[codeFreqSize];
                this.blockOffLenFreq[i] = new int[offLenFreqSize];
                ++i;
            }
        } else {
            if (out == null) {
                throw new NullPointerException("out");
            }
            if (BlockNum <= 0) {
                throw new IllegalArgumentException("BlockNum too small. BlockNum must be 1 or more.");
            }
            if (DivideNum < 0 || BlockNum <= DivideNum) {
                throw new IllegalArgumentException("DivideNum out of bounds( 0 to BlockNum - 1(" + (BlockNum - 1) + ") ).");
            }
            throw new IllegalArgumentException("BlockSize too small. BlockSize must be larger than " + MinCapacity);
lbl32:
            // 1 sources

            if (method == null) {
                throw new NullPointerException("method");
            }
            throw new IllegalArgumentException("Unknown compress method. " + method);
        }
        this.group = PostLh5Encoder.createGroup(BlockNum, DivideNum);
        this.pattern = PostLh5Encoder.createPattern(BlockNum, DivideNum);
        this.position = 0;
        this.flagBit = 0;
        this.flagPos = 0;
    }

    public void writeCode(int code) throws IOException {
        int need = (256 <= code ? this.DictionarySizeByteLen + 1 : 1) + (this.flagBit == 0 ? 1 : 0);
        if (this.block[this.currentBlock].length - this.position < need || 65535 <= this.blockSize[this.currentBlock]) {
            ++this.currentBlock;
            if (this.block.length <= this.currentBlock) {
                this.writeOut();
            } else {
                this.position = 0;
            }
            this.flagBit = 128;
            this.flagPos = this.position++;
            this.block[this.currentBlock][this.flagPos] = 0;
        } else if (this.flagBit == 0) {
            this.flagBit = 128;
            this.flagPos = this.position++;
            this.block[this.currentBlock][this.flagPos] = 0;
        }
        this.block[this.currentBlock][this.position++] = (byte)code;
        if (256 <= code) {
            byte[] byArray = this.block[this.currentBlock];
            int n = this.flagPos;
            byArray[n] = (byte)(byArray[n] | this.flagBit);
        }
        this.flagBit >>= 1;
        int[] nArray = this.blockCodeFreq[this.currentBlock];
        int n = code;
        nArray[n] = nArray[n] + 1;
        int n2 = this.currentBlock;
        this.blockSize[n2] = this.blockSize[n2] + 1;
    }

    public void writeOffset(int offset) {
        int shift = this.DictionarySizeByteLen - 1 << 3;
        while (shift >= 0) {
            this.block[this.currentBlock][this.position++] = (byte)(offset >> shift);
            shift -= 8;
        }
        int[] nArray = this.blockOffLenFreq[this.currentBlock];
        int n = Bits.len(offset);
        nArray[n] = nArray[n] + 1;
    }

    public void flush() throws IOException {
        this.writeOut();
        this.out.flush();
    }

    public void close() throws IOException {
        this.writeOut();
        this.out.close();
        this.out = null;
        this.block = null;
        this.blockCodeFreq = null;
        this.blockOffLenFreq = null;
        this.group = null;
        this.pattern = null;
    }

    public int getDictionarySize() {
        return this.DictionarySize;
    }

    public int getMaxMatch() {
        return this.MaxMatch;
    }

    public int getThreshold() {
        return this.Threshold;
    }

    private void writeOut() throws IOException {
        if (1 < this.block.length) {
            this.writeOutBestPattern();
        } else {
            this.writeOutGroup(new int[1]);
            this.currentBlock = 0;
        }
        this.position = 0;
        this.flagBit = 0;
    }

    private void writeOutBestPattern() throws IOException {
        int[] bestPattern = null;
        int[] groupHuffLen = new int[this.group.length];
        int i = 0;
        while (i < this.group.length) {
            if (this.group != null) {
                int blockSize = 0;
                int j = 0;
                while (j < this.group[i].length) {
                    blockSize += this.blockSize[this.group[i][j]];
                    ++j;
                }
                groupHuffLen[i] = blockSize > 0 && blockSize < 65536 ? PostLh5Encoder.calcHuffmanCodeLength(this.DictionarySize, PostLh5Encoder.margeArrays(this.group[i], this.blockCodeFreq), PostLh5Encoder.margeArrays(this.group[i], this.blockOffLenFreq)) : (blockSize == 0 ? 0 : -1);
            } else {
                groupHuffLen[i] = -1;
            }
            ++i;
        }
        int smallest = Integer.MAX_VALUE;
        int i2 = 0;
        while (i2 < this.pattern.length) {
            int length = 0;
            int j = 0;
            while (j < this.pattern[i2].length) {
                if (groupHuffLen[this.pattern[i2][j]] >= 0) {
                    length += groupHuffLen[this.pattern[i2][j]];
                } else {
                    length = Integer.MAX_VALUE;
                    break;
                }
                ++j;
            }
            if (length < smallest) {
                bestPattern = this.pattern[i2];
                smallest = length;
            }
            ++i2;
        }
        if (bestPattern != null) {
            i2 = 0;
            while (i2 < bestPattern.length) {
                this.writeOutGroup(this.group[bestPattern[i2]]);
                ++i2;
            }
        } else {
            i2 = 0;
            while (i2 < this.block.length) {
                this.writeOutGroup(new int[]{i2++});
            }
        }
        this.currentBlock = 0;
    }

    private void writeOutGroup(int[] group) throws IOException {
        int[] codeFreq = PostLh5Encoder.margeArrays(group, this.blockCodeFreq);
        int[] offLenFreq = PostLh5Encoder.margeArrays(group, this.blockOffLenFreq);
        int blockSize = 0;
        int i = 0;
        while (i < group.length) {
            blockSize += this.blockSize[group[i]];
            ++i;
        }
        if (blockSize > 0) {
            this.out.writeBits(16, blockSize);
            int[] codeLen = StaticHuffman.FreqListToLenList(codeFreq);
            int[] codeCode = StaticHuffman.LenListToCodeList(codeLen);
            int[] offLenLen = StaticHuffman.FreqListToLenList(offLenFreq);
            int[] offLenCode = StaticHuffman.LenListToCodeList(offLenLen);
            if (2 <= PostLh5Encoder.countNoZeroElement(codeFreq)) {
                int[] codeLenFreq = PostLh5Encoder.createCodeLenFreq(codeLen);
                int[] codeLenLen = StaticHuffman.FreqListToLenList(codeLenFreq);
                int[] codeLenCode = StaticHuffman.LenListToCodeList(codeLenLen);
                if (2 <= PostLh5Encoder.countNoZeroElement(codeLenFreq)) {
                    this.writeCodeLenLen(codeLenLen);
                } else {
                    this.out.writeBits(5, 0);
                    this.out.writeBits(5, PostLh5Encoder.getNoZeroElementIndex(codeLenFreq));
                }
                this.writeCodeLen(codeLen, codeLenLen, codeLenCode);
            } else {
                this.out.writeBits(10, 0);
                this.out.writeBits(18, PostLh5Encoder.getNoZeroElementIndex(codeFreq));
            }
            if (2 <= PostLh5Encoder.countNoZeroElement(offLenFreq)) {
                this.writeOffLenLen(offLenLen);
            } else {
                int len = Bits.len(Bits.len(this.DictionarySize));
                this.out.writeBits(len, 0);
                this.out.writeBits(len, PostLh5Encoder.getNoZeroElementIndex(offLenFreq));
            }
            int i2 = 0;
            while (i2 < group.length) {
                this.position = 0;
                this.flagBit = 0;
                byte[] buffer = this.block[group[i2]];
                int j = 0;
                while (j < this.blockSize[group[i2]]) {
                    int code;
                    if (this.flagBit == 0) {
                        this.flagBit = 128;
                        ++this.position;
                        this.flagPos = this.flagPos;
                    }
                    if ((buffer[this.flagPos] & this.flagBit) == 0) {
                        code = buffer[this.position++] & 0xFF;
                        this.out.writeBits(codeLen[code], codeCode[code]);
                    } else {
                        code = buffer[this.position++] & 0xFF | 0x100;
                        int offset = 0;
                        int k = 0;
                        while (k < this.DictionarySizeByteLen) {
                            offset = offset << 8 | buffer[this.position++] & 0xFF;
                            ++k;
                        }
                        int offlen = Bits.len(offset);
                        this.out.writeBits(codeLen[code], codeCode[code]);
                        this.out.writeBits(offLenLen[offlen], offLenCode[offlen]);
                        if (1 < offlen) {
                            this.out.writeBits(offlen - 1, offset);
                        }
                    }
                    this.flagBit >>= 1;
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < group.length) {
                this.blockSize[group[i2]] = 0;
                codeFreq = this.blockCodeFreq[group[i2]];
                int j = 0;
                while (j < codeFreq.length) {
                    codeFreq[j] = 0;
                    ++j;
                }
                offLenFreq = this.blockOffLenFreq[group[i2]];
                j = 0;
                while (j < offLenFreq.length) {
                    offLenFreq[j] = 0;
                    ++j;
                }
                ++i2;
            }
        }
    }

    private void writeCodeLenLen(int[] codeLenLen) throws IOException {
        int end = codeLenLen.length;
        while (end > 0 && codeLenLen[end - 1] == 0) {
            --end;
        }
        this.out.writeBits(5, end);
        int index = 0;
        while (index < end) {
            int len;
            if ((len = codeLenLen[index++]) <= 6) {
                this.out.writeBits(3, len);
            } else {
                this.out.writeBits(len - 3, (1 << len - 3) - 2);
            }
            if (index != 3) continue;
            while (codeLenLen[index] == 0 && index < 6) {
                ++index;
            }
            this.out.writeBits(2, index - 3 & 3);
        }
    }

    private void writeCodeLen(int[] codeLen, int[] codeLenLen, int[] codeLenCode) throws IOException {
        int end = codeLen.length;
        while (end > 0 && codeLen[end - 1] == 0) {
            --end;
        }
        this.out.writeBits(9, end);
        int index = 0;
        while (index < end) {
            int len;
            if ((len = codeLen[index++]) > 0) {
                this.out.writeBits(codeLenLen[len + 2], codeLenCode[len + 2]);
                continue;
            }
            int count = 1;
            while (codeLen[index] == 0 && index < end) {
                ++count;
                ++index;
            }
            if (count <= 2) {
                int i = 0;
                while (i < count) {
                    this.out.writeBits(codeLenLen[0], codeLenCode[0]);
                    ++i;
                }
                continue;
            }
            if (count <= 18) {
                this.out.writeBits(codeLenLen[1], codeLenCode[1]);
                this.out.writeBits(4, count - 3);
                continue;
            }
            if (count == 19) {
                this.out.writeBits(codeLenLen[0], codeLenCode[0]);
                this.out.writeBits(codeLenLen[1], codeLenCode[1]);
                this.out.writeBits(4, 15);
                continue;
            }
            this.out.writeBits(codeLenLen[2], codeLenCode[2]);
            this.out.writeBits(9, count - 20);
        }
    }

    private void writeOffLenLen(int[] offLenLen) throws IOException {
        int end = offLenLen.length;
        while (end > 0 && offLenLen[end - 1] == 0) {
            --end;
        }
        int len = Bits.len(Bits.len(this.DictionarySize));
        this.out.writeBits(len, end);
        int index = 0;
        while (index < end) {
            if ((len = offLenLen[index++]) <= 6) {
                this.out.writeBits(3, len);
                continue;
            }
            this.out.writeBits(len - 3, (1 << len - 3) - 2);
        }
    }

    private static int countNoZeroElement(int[] array) {
        int count = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private static int getNoZeroElementIndex(int[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] != 0) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private static int[] margeArrays(int[] indexes, int[][] arrays) {
        if (1 < indexes.length) {
            int[] array = new int[arrays[0].length];
            int i = 0;
            while (i < indexes.length) {
                int[] src = arrays[indexes[i]];
                int j = 0;
                while (j < src.length) {
                    int n = j;
                    array[n] = array[n] + src[j];
                    ++j;
                }
                ++i;
            }
            return array;
        }
        return arrays[indexes[0]];
    }

    private static int[] createCodeLenFreq(int[] codeLen) {
        int[] codeLenFreq = new int[19];
        int end = codeLen.length;
        while (end > 0 && codeLen[end - 1] == 0) {
            --end;
        }
        int index = 0;
        while (index < end) {
            int len;
            if ((len = codeLen[index++]) > 0) {
                int n = len + 2;
                codeLenFreq[n] = codeLenFreq[n] + 1;
                continue;
            }
            int count = 1;
            while (codeLen[index] == 0 && index < end) {
                ++count;
                ++index;
            }
            if (count <= 2) {
                codeLenFreq[0] = codeLenFreq[0] + count;
                continue;
            }
            if (count <= 18) {
                codeLenFreq[1] = codeLenFreq[1] + 1;
                continue;
            }
            if (count == 19) {
                codeLenFreq[0] = codeLenFreq[0] + 1;
                codeLenFreq[1] = codeLenFreq[1] + 1;
                continue;
            }
            codeLenFreq[2] = codeLenFreq[2] + 1;
        }
        return codeLenFreq;
    }

    private static int calcHuffmanCodeLength(int DictionarySize, int[] codeFreq, int[] offLenFreq) {
        int[] offLenLen;
        int[] codeLen;
        int length = 0;
        try {
            codeLen = StaticHuffman.FreqListToLenList(codeFreq);
            int[] codeCode = StaticHuffman.LenListToCodeList(codeLen);
            offLenLen = StaticHuffman.FreqListToLenList(offLenFreq);
        }
        catch (BadHuffmanTableException exception) {
            throw new Error("caught the BadHuffmanTableException which should be never thrown.");
        }
        length += 16;
        if (2 <= PostLh5Encoder.countNoZeroElement(codeFreq)) {
            int[] codeLenFreq = PostLh5Encoder.createCodeLenFreq(codeLen);
            int[] codeLenLen = StaticHuffman.FreqListToLenList(codeLenFreq);
            if (2 <= PostLh5Encoder.countNoZeroElement(codeLenFreq)) {
                length += PostLh5Encoder.calcCodeLenLen(codeLenLen);
            } else {
                length += 5;
                length += 5;
            }
            length += PostLh5Encoder.calcCodeLen(codeLen, codeLenLen);
        } else {
            length += 10;
            length += 18;
        }
        if (2 <= PostLh5Encoder.countNoZeroElement(offLenFreq)) {
            length += PostLh5Encoder.calcOffLenLen(DictionarySize, offLenLen);
        } else {
            int len = Bits.len(Bits.len(DictionarySize));
            length += len;
            length += len;
        }
        int i = 0;
        while (i < codeFreq.length) {
            length += codeFreq[i] * codeLen[i];
            ++i;
        }
        i = 0;
        while (i < offLenFreq.length) {
            length += offLenFreq[i] * (offLenLen[i] + i - 1);
            ++i;
        }
        return length;
    }

    private static int calcCodeLenLen(int[] codeLenLen) {
        int length = 0;
        int end = codeLenLen.length;
        while (end > 0 && codeLenLen[end - 1] == 0) {
            --end;
        }
        length += 5;
        int index = 0;
        while (index < end) {
            int len;
            length = (len = codeLenLen[index++]) <= 6 ? (length += len) : (length += len - 3);
            if (index != 3) continue;
            while (codeLenLen[index] == 0 && index < 6) {
                ++index;
            }
            length += 2;
        }
        return length;
    }

    private static int calcCodeLen(int[] codeLen, int[] codeLenLen) {
        int length = 0;
        int end = codeLen.length;
        while (end > 0 && codeLen[end - 1] == 0) {
            --end;
        }
        length += 9;
        int index = 0;
        while (index < end) {
            int len;
            if ((len = codeLen[index++]) > 0) {
                length += codeLenLen[len + 2];
                continue;
            }
            int count = 1;
            while (codeLen[index] == 0 && index < end) {
                ++count;
                ++index;
            }
            if (count <= 2) {
                int i = 0;
                while (i < count) {
                    length += codeLenLen[0];
                    ++i;
                }
                continue;
            }
            if (count <= 18) {
                length += codeLenLen[1];
                length += 4;
                continue;
            }
            if (count == 19) {
                length += codeLenLen[0];
                length += codeLenLen[1];
                length += 4;
                continue;
            }
            length += codeLenLen[2];
            length += 9;
        }
        return length;
    }

    private static int calcOffLenLen(int DictionarySize, int[] offLenLen) {
        int length = 0;
        int end = offLenLen.length;
        while (end > 0 && offLenLen[end - 1] == 0) {
            --end;
        }
        length += Bits.len(Bits.len(DictionarySize));
        int index = 0;
        while (index < end) {
            int len;
            if ((len = offLenLen[index++]) <= 6) {
                length += 3;
                continue;
            }
            length += len - 3;
        }
        return length;
    }

    private static int[][] createGroup(int BlockNum, int DivideNum) {
        int[][] group = new int[(BlockNum + 1) * BlockNum / 2][];
        if (DivideNum == 0) {
            group[0] = new int[BlockNum];
            int i = 0;
            while (i < BlockNum) {
                group[0][i] = i;
                ++i;
            }
        } else if (2 < BlockNum && DivideNum == 1) {
            int index = 0;
            int size = BlockNum;
            while (size > 0) {
                group[index] = new int[size];
                int i = 0;
                while (i < size) {
                    group[index][i] = i;
                    ++i;
                }
                if (size < BlockNum) {
                    group[index += BlockNum - size] = new int[size];
                    i = 0;
                    while (i < size) {
                        group[index][i] = i + BlockNum - size;
                        ++i;
                    }
                }
                ++index;
                --size;
            }
        } else {
            int index = 0;
            int size = BlockNum;
            while (size > 0) {
                int start = 0;
                while (size + start <= BlockNum) {
                    group[index] = new int[size];
                    int i = 0;
                    while (i < size) {
                        group[index][i] = start + i;
                        ++i;
                    }
                    ++index;
                    ++start;
                }
                --size;
            }
        }
        return group;
    }

    private static int[][] createPattern(int BlockNum, int DivideNum) {
        int index = 0;
        int patternNum = PostLh5Encoder.calcPatternNum(BlockNum, DivideNum);
        int[][] pattern = new int[patternNum][];
        int div = 0;
        while (div < Math.min(BlockNum, DivideNum + 1)) {
            boolean more;
            int[] divPos = new int[div];
            int i = 0;
            while (i < divPos.length) {
                divPos[i] = i;
                ++i;
            }
            do {
                pattern[index] = new int[div + 1];
                int start = 0;
                int i2 = 0;
                while (i2 < divPos.length) {
                    int len = divPos[i2] - start + 1;
                    int num = BlockNum - len;
                    pattern[index][i2] = (num + 1) * num / 2 + start;
                    start += len;
                    ++i2;
                }
                int num = BlockNum - (BlockNum - start);
                pattern[index][divPos.length] = (num + 1) * num / 2 + start;
                ++index;
                more = false;
                int move = divPos.length - 1;
                int range = BlockNum - 2;
                while (move >= 0 && !more) {
                    if (divPos[move] < range) {
                        int n = move;
                        divPos[n] = divPos[n] + 1;
                        if (move < divPos.length - 1) {
                            int i3 = move;
                            while (i3 < divPos.length - 1) {
                                divPos[i3 + 1] = divPos[i3] + 1;
                                ++i3;
                            }
                        }
                        more = true;
                    }
                    range = divPos[move] - 1;
                    --move;
                }
            } while (more);
            ++div;
        }
        return pattern;
    }

    private static int calcPatternNum(int BlockNum, int DivideNum) {
        int patternNum = 0;
        int div = 0;
        while (div <= DivideNum) {
            int count = div <= BlockNum / 2 ? div : BlockNum - 1 - div;
            int numerator = 1;
            int i = 1;
            while (i <= count) {
                numerator *= BlockNum - i;
                ++i;
            }
            int denominator = 1;
            int i2 = 1;
            while (i2 <= count) {
                denominator *= i2;
                ++i2;
            }
            patternNum += numerator / denominator;
            ++div;
        }
        return patternNum;
    }
}

