package distanceManager;

import distance.*;
import parameters.parameters;
 
public class mat{ 
    public dis[][] distance;  // set of distances
    double Dmean,D01,D0;

 // Dmean is pai, D01 is d(0,1), and D0 is mean of d(0,i);
    double Vh,Va; // harmonic and arithmetic mean
    double gamma_param;
	
    public mat(){ 
        distance = new dis[1][1];
        Dmean=0;D01=0;
        Vh=0;Va=0;
        gamma_param = Double.POSITIVE_INFINITY;
    }

    public mat(double gamma_par){ 
        distance = new dis[1][1];
        Dmean=0;D01=0;
        Vh=0;Va=0;
        gamma_param = gamma_par;
    }
 

    public double[][] k_mat(){ // matrix of number of substitutions per sites 
        int size = distance.length;
        double[][] k = new double[size][size];
        for (int i=0;i<size;i++) k[i][i] = 0.0;
        for (int i=0;i<size-1;i++){
            for (int j=i+1;j<size;j++){
                k[i][j] = k[j][i] = distance[i][j].k();
            }
        }
        return k;
    }

    public double[][] K_mat(){ // matrix of number of substitutions
        int size = distance.length;
        double[][] k = new double[size][size];
        for (int i=0;i<size;i++) k[i][i] = 0.0;
        for (int i=0;i<size-1;i++){
            for (int j=i+1;j<size;j++){
                k[i][j] = k[j][i] = distance[i][j].k()*distance[i][j].len();
            }
        }
        return k;
    }

 
    public void init_mat(int size){ 
        distance = new dis[size][size];
        if(Double.isInfinite(gamma_param)){
            for (int i=0;i<size-1;i++){
                for (int j=i;j<size;j++){
                    distance[i][j] = distance[j][i] =  new Poi_dis();// poisson distance
                    //the same object
                }
            }
        }else{
            for (int i=0;i<size-1;i++){
                for (int j=i;j<size;j++){
                    distance[i][j] = distance[j][i] =  new Poi_gam_dis(gamma_param);
                    //the same object
                }
            }
        }
    }
 
    public void set_seq(String[] seq){ 
        int size=seq.length;
        if(size!=size()) init_mat(size);
        int len = seq[0].length(); //aligned
//        for (int i=0;i<size;i++) distance[i][i].set_p(0);
        for (int i=0;i<size-1;i++){
            for (int j=i;j<size;j++){
                distance[i][j].set_seq(seq[i], seq[j]);
            }
        }
        set_param();
    }
 
    public void set_param(){ 
        int size=size();
        D01 = distance[0][1].k();
        double total=0;
        double Vsum=0;
        double Visum=0;
        int count=0;
        double tate = 0.0;
        for(int i=1;i<size;i++){
            if(distance[0][i].exist()){
                tate += distance[0][i].k();
                count++;
            }
        }
        D0 = tate/count;
        count=0;
        for (int i=0;i<size-1;i++){
            for (int j=i;j<size;j++){
                dis tmp = distance[i][j];
                if(tmp.Vk()>0){
                    total += tmp.k();
                    Vsum  += tmp.Vk();
                    Visum += tmp.Vkinv();
                    count++;
                }
            }
        }
        if(count>0){
            Dmean = total / count; //pairwise average
            Va = Vsum / count;    //arithmetic mean
            Vh = count / Visum;   //harmonic mean
        }else{
            Dmean = Va = Vh = 0;// no mutations
        }
    }
 
    public int size(){         return distance.length;    }
    public double pai(){         return Dmean;    }
    public double pai2(){        return D0;    }
    public double out(){         return D01;    }
    public double Vharm(){         return Vh;    }
    public double Varit(){         return Va;    }
    public String name(){        return "mat";    }
    
    public static mat distanceMatrix(parameters params, String[] seq){
    	mat result = null;
    	String distance = params.distance;
    	if(distance.equals("automatic")){
        	if( isDNA(seq[0]) ){
        		result = DNADistanceMatrix(params,seq);
        	}else{
        		result = ProteinDistanceMatrix(params,seq);
        	}
    	}else{
    		if (distance.equals("JC") ) result = new mat_JC(); // Jukes and Cantor
    		if (distance.equals("GP") ) result = new mat_GP(); // Goldstein and Pollock
    		if (distance.equals("K2") ) result = new mat_K2(); // Kimura 2 parameter 
    		if (distance.equals("PO") ) result = new mat_PO(); // Poisson
    		if (distance.equals("PG") ) result = new mat_PO_gamma_95(params.alpha); 
    	}
    	if(result==null) result = new mat_PO();/*default*/
    	result.set_seq(seq);
    	return result;
    }

    public static mat DNADistanceMatrix(parameters params, String[] seq){
    	mat result = null;
    	String distance = params.DNADistance;
		if (distance.equals("JC") ) result = new mat_JC(); // Jukes and Cantor
		if (distance.equals("GP") ) result = new mat_GP(); // Goldstein and Pollock
		if (distance.equals("K2") ) result = new mat_K2(); // Kimura 2 parameter 
		if (distance.equals("PO") ) result = new mat_PO(); 
    	result.set_seq(seq);
    	return result;
    }

    public static mat ProteinDistanceMatrix(parameters params, String[] seq){
    	mat result = null;
    	String distance = params.DNADistance;
		if (distance.equals("JC") ) result = new mat_JC(); // Jukes and Cantor
		if (distance.equals("GP") ) result = new mat_GP(); // Goldstein and Pollock
		if (distance.equals("K2") ) result = new mat_K2(); // Kimura 2 parameter 
		if (distance.equals("PO") ) result = new mat_PO(); 
    	result.set_seq(seq);
    	return result;
    }

    static boolean isDNA(String sequence){
    	if(sequence==null) return false;
    	double count = 0;
    	int checklen=100; // check first 100 characters or full sequence (shorter one)
    	if(checklen>sequence.length()) checklen = sequence.length();
    	for(int i=0;i<checklen;i++){
    		char c = sequence.charAt(i);
    		if ( canBeNucleotide(c) ) count ++;
    	}
    	if ( count/checklen > 0.8) return true; // DNA
    	return false; // protein 
    }

    static boolean canBeNucleotide(char c){
    	switch(c){
    		case 'U': return  true;
    		case 'u': return  true;
    		case 'T': return  true;
    		case 't': return  true;
    		case 'C': return  true;
    		case 'c': return  true;
    		case 'A': return  true;
    		case 'a': return  true;
    		case 'G': return  true;
    		case 'g': return  true;
    		case 'N': return  true;
    		case 'n': return  true;
            default : return false;
    	}
    }
} 
  
 
  
