#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "snp_typeI.h"

int main(int argc, char* argv[])
{
    InputTypeI inputTypeI={"", "", "", 0, "", 0, 0, 0, 0};

    if(argc != 10){
        printf("[usage]main.exe [InputFile1] [InputFile2] [outputFile] [AreaFileType] [BlockAreaFile] [Score] [Repeat] [Generation] [dataType] \n");
        return 255;
    }
    strcpy(inputTypeI.inputFile1, argv[1]);
    strcpy(inputTypeI.inputFile2, argv[2]);
    strcpy(inputTypeI.outputFile1, argv[3]);
    inputTypeI.areaFileType = atoi(argv[4]);
    strcpy(inputTypeI.blockAreaFile, argv[5]);
    inputTypeI.score = atoi(argv[6]);
    inputTypeI.repeat = atol(argv[7]);
    inputTypeI.gen = atol(argv[8]);
    inputTypeI.dataType = atoi(argv[9]);

    /* XRAvZ@̎w */
    iWay = inputTypeI.score;

    /* ֐ */
    initMyRand();

    /* MultiLocuss */
    MainProgramMulti(&inputTypeI);

}


/* MultiLocuss */
void MainProgramMulti(InputTypeI *inputTypeI)
{
    int retval = 0;
    int flag = 0;
    long i = 0;
	long j = 0;
    long fileLine1 = 0; /* ̓t@C̃C */
    long fileLine2 = 0; /* ̓t@C̃C */
    long areaFileLine = 0; /* haplotypeubN̈wt@C̃C */
    long a = 0;         /* number of haplotype copies (=sequences) in case */
    long b = 0;         /* number of haplotype copies (=sequences) in control */
    long n = 0;
    long dataNum;       /* caseAcontrolf[^̑SNP */
    long index = 0;
    long jStart = 0;    /* haplotypeubN̍ŏSNP */
    long jEnd = 0;      /* haplotypeubN̍ŌSNP */
    long blockNum = 0;  /* haplotypeubN */
    long repeat = 0;
    long startPos = 0;
    long endPos = 0;

    double S = 0;

    int **T = NULL;             /* 􌻕\ */
    int *populationType = NULL;
    long *L = NULL;             /* ehaplotypeubNhaplotypep^[ */
    long *blockArea = NULL;     /* ehaplotypeubN̈i[ */
    long *linkSNPNum = NULL;    /* ehaplotypeubNSNP */
    long *linkSNPStart = NULL;  /* ehaplotypeubN̍ŏSNP */
    long *maxScoreIndex = NULL; /* ehaplotypeubÑXRAől̍ */
    char ***haplotype = NULL;    /* haplotypef[^ */
    double **freq = NULL;        /* px */
    double *typeIError = NULL;  /* type I error i[z */
    double *Sobs = NULL;        /* ehaplotypeubÑXRAől */

    FILE *fpCase = NULL;    /* ́icasejt@C|C^ */
    FILE *fpCntl = NULL;    /* ́icontroljt@C|C^ */
    FILE *fpOut = NULL;     /* o̓t@C|C^ */
    FILE *fpArea = NULL;    /* haplotypeubN̈wt@C|C^ */

    char *caseData = NULL;      /* Tvf[^icaseji[p */
    char *controlData = NULL;   /* Tvf[^icontrolji[p */

    SnpData *snpTmpData1 = NULL;
    SnpData *snpTmpData2 = NULL;
    SnpData *snpData1 = NULL;
    SnpData *snpData2 = NULL;

    repeat = inputTypeI->repeat;

    /* t@CI[v */
    retval = InputFileOpen(&fpCase, inputTypeI->inputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpCntl, inputTypeI->inputFile2);
    if (retval != 0){
        goto finalize;
    }
    retval = OutputFileOpen(&fpOut, inputTypeI->outputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpArea, inputTypeI->blockAreaFile);
    if (retval != 0){
        goto finalize;
    }

/****************************************************************/
/* f[^                                                   */
/****************************************************************/
 
    /* haplotypeubN̈wt@C̃C擾 */
    areaFileLine = DataReaderCountFileLine(fpArea);
    /* haplotypeubN̈i[pz̃m */
    blockArea = (long*)malloc1Dim(sizeof(long), areaFileLine);
    if (NULL == blockArea){ goto finalize; }
    /* t@C|C^擪ɖ߂ */
    fseek(fpArea, 0L, SEEK_SET);
    /* haplotypeubN̈zɎ߂ */
    DataReaderSetHaplotypeBlockArea(fpArea, blockArea);

    /* ̓t@C̃C擾 */
    fileLine1 = DataReaderCountFileLine(fpCase);
    fileLine2 = DataReaderCountFileLine(fpCntl);

    /* t@C|C^擪ɖ߂ */
    fseek(fpCase, 0L, SEEK_SET);
    fseek(fpCntl, 0L, SEEK_SET);

    /* f[^ꎞi[p\̂̃m */
    snpTmpData1 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine1);
    snpTmpData2 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine2);

    /* f[^t@Cǂݍݍ\̂Ɏ߂ */
    DataReaderSetAllData(fpCase, snpTmpData1, fileLine1, inputTypeI->dataType);
    DataReaderSetAllData(fpCntl, snpTmpData2, fileLine2, inputTypeI->dataType);

    /* ̓f[^̐`FbNĕ񉻗p̓̓f[^쐬 */
    /* MPI_Bcast̉񐔂炷߂ɃTvf[^͕ʔzicaseData, controlDatajŕێ */
    dataNum = DataReaderMakeParallelData(snpTmpData1, snpTmpData2, fileLine1, fileLine2, &snpData1, &snpData2, &caseData, &controlData);

    /* gpȂz̃J */
    /* \SnpDataõJ */
    DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
    DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
    snpTmpData1 = NULL;
    snpTmpData2 = NULL;

    /* ̓f[^̃Tv擾 */
    a = snpData1[0].dataNum;
    b = snpData2[0].dataNum;
    n = a + b;

    /* \SnpDataɃTvf[^Rs[ */
    DataReaderDataCopyToSnpData(snpData1, caseData, dataNum, a);
    DataReaderDataCopyToSnpData(snpData2, controlData, dataNum, b);

/****************************************************************/
/* m                                                   */
/****************************************************************/

    /* haplotypeubN */
    if (inputTypeI->areaFileType == 0){
        blockNum = areaFileLine - 1;
    }
    else {
        /* haplotypeubŇvZ */
        if (blockArea[0] > dataNum){
            blockNum = 1;
            blockArea[1] = dataNum; /* linkSNPNum̒lf[^ɂȂ */
        }
        else{
            blockNum = (dataNum - (blockArea[0] - blockArea[1]) ) / blockArea[1];
        }
    }
    /* ehaplotypeubN̈SNPi[pz̃m */
    linkSNPNum = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPNum){ goto finalize; }
    /* ehaplotypeubN̈̍ŏSNPʊi[pz̃m */
    linkSNPStart = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPStart){ goto finalize; }

    /* ehaplotypeubN̈ɊYSNPf[^ */
    if (inputTypeI->areaFileType == 0){
        for (i = 0; i < blockNum; i++){ /* Ä̏dꍇl */
            startPos = blockArea[i];
            endPos = blockArea[i+1];
            flag = 0;
            /* ̓f[^̓|WVŃ\[gĂƉ */
            for (j = 0; j < dataNum; j++){
                if (startPos <= snpData1[j].pos){
                    if (snpData1[j].pos < endPos){
                        /* ̈SNPJEg */
                        linkSNPNum[i]++;
                        /* ̈̍ŏSNPʂێ */
                        if (0 == flag ){
                            linkSNPStart[i] = j;
                            flag = 1;
                        }
                    }
                    /* ȍ~ÄɊYf[^͏oȂ̂Ŏ̃ubN𒲂ׂ */
                    else {
                        break;
                    }
                }
            }
        }
    }
    else {
        for (i = 0; i < blockNum; i++){
            linkSNPNum[i] = blockArea[0];
            linkSNPStart[i] = i * blockArea[1];
        }
    }

    /* 􌻕\T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }
    /* populationTypẽm */
    populationType = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == populationType) { goto finalize; }
    /* type I error i[z̃m */
    typeIError = (double*)malloc1Dim(sizeof(double), blockNum * repeat);
    if (NULL == typeIError) { goto finalize; }
    /* haplotypef[^̃m */
    haplotype = (char***)malloc1Dim(sizeof(char**), blockNum);
    if (NULL == haplotype) { goto finalize; }
    /* p^[px̃m */
    freq = (double**)malloc1Dim(sizeof(double*), blockNum);
    if (NULL == freq) { goto finalize; }
    /* p^[̃m */
    L = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == L) { goto finalize; }
    /* HaplotypeubÑXRAől̍ʂ̃m */
    maxScoreIndex = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == maxScoreIndex) { goto finalize; }
    /* HaplotypeubÑXRAől̃m */
    Sobs = (double*)malloc1Dim(sizeof(double), blockNum);
    if (NULL == Sobs) { goto finalize; }

/****************************************************************/
/* 菈                                                     */
/****************************************************************/

    /* haplotypeubNPʂŃ[v */
    jStart = 0;
    for (i = 0; i < blockNum; i++){
        jStart = linkSNPStart[i];
        jEnd = jStart + linkSNPNum[i];
        /* ehaplotypeubNŃ[v */
        for (j = jStart; j < jEnd; j++){
            /* ϑl􌻕\쐬 */
            DataReaderPopulationType(&snpData1[j], &snpData2[j], populationType);
            DataReaderMakeTableDi(&snpData1[j], &snpData2[j], populationType, T);
            /* XRAvZ@XRAvZ0ɂȂĂ܂ꍇ-1Ԃ */
            S = TableCalcScore(T);
            /* őXRA肷 */
            if (S > Sobs[i]){
                Sobs[i] = S;
                maxScoreIndex[i] = j;
            }
        }
        /* eHaplotype̕pxvZ */
        L[i] = DataReaderHaplotypeFrequency(snpData1, snpData2, jStart, jEnd, &haplotype[i], &freq[i]);

        /* nv^Cv֘A͂Type I error̊mvZs */
        if (Sobs[i] > 0.0) {
            TypeIExecute(freq[i], haplotype[i], L[i], Sobs[i], a, b, linkSNPNum[i], &typeIError[i*repeat], repeat, inputTypeI->gen);
        }
    }

/****************************************************************/
/* 茋ʏo                                                 */
/****************************************************************/

    index = 0;
    fprintf(fpOut, "CaseData    = %s\n", inputTypeI->inputFile1);
    fprintf(fpOut, "ControlData = %s\n", inputTypeI->inputFile2);
    fprintf(fpOut, "Repeat      = %ld\n", inputTypeI->repeat);
    fprintf(fpOut, "Genoration  = %ld\n", inputTypeI->gen);
    fprintf(fpOut, "BlockArea\tSNPNum\trsNumber\tPosition\tScore\tTypeIerror...\n");
    if (inputTypeI->areaFileType == 0){
        for (i = 0; i < blockNum; i++){
            if (Sobs[i] != 0){
                fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.10lf\t", 
                    blockArea[i],
                    blockArea[i+1],
                    linkSNPNum[i],
                    snpData1[ maxScoreIndex[i] ].rsNumber,
                    snpData1[ maxScoreIndex[i] ].pos,
                    Sobs[i]);
                /* type I erroro */
                for (index = 0; index < repeat; index++){
                    fprintf(fpOut, "%.10lf\t", typeIError[i*repeat+index]);
                }
                fprintf(fpOut, "\n");
            }
            else {
                fprintf(fpOut, "%ld-%ld\t%ld\tNoData\n", 
                    blockArea[i],
                    blockArea[i+1],
                    linkSNPNum[i]);
            }
        }
    }
    else {
        for (i = 0; i < blockNum; i++){
            if (Sobs[i] != 0){
                fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.10lf\t", 
                    snpData1[ linkSNPStart[i] ].pos,
                    snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                    linkSNPNum[i],
                    snpData1[ maxScoreIndex[i] ].rsNumber,
                    snpData1[ maxScoreIndex[i] ].pos,
                    Sobs[i]);
                /* type I erroro */
                for (index = 0; index < repeat; index++){
                    fprintf(fpOut, "%.10lf\t", typeIError[i*repeat+index]);
                }
                fprintf(fpOut, "\n");
            }
            else {
                fprintf(fpOut, "%ld-%ld\t%ld\tNoData\n", 
                    snpData1[ linkSNPStart[i] ].pos,
                    snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                    linkSNPNum[i]);
            }
        }
    }

/****************************************************************/
/* I                                                     */
/****************************************************************/

finalize:;
    /* t@CN[Y */
    FileClose(fpCase);
    FileClose(fpCntl);
    FileClose(fpOut);
    FileClose(fpArea);
    /* mۂJ */
    // haplotypeϐchar^̂Rz
    // e̗vf͔zL킩BlinkedSNPNumłB
    // p̊J̊֐쐬KvBƂ肠ʂfree
    for (i = blockNum-1; i >= 0; i--){
        for (index = L[i]-1; index >= 0; index--){
            free1Dim(haplotype[i][index]);
        }
        free1Dim(haplotype[i]);
    }
    free1Dim(haplotype);

    free1Dim(blockArea);
    free1Dim(linkSNPNum);
    free1Dim(linkSNPStart);
    free1Dim(typeIError);
    freeDouble2Dim(freq,blockNum);
    freeInt2Dim(T, ROW);
    free1Dim(populationType);
    free1Dim(L);
    free1Dim(maxScoreIndex);
    free1Dim(Sobs);
    DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
    DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
    free1Dim(caseData);
    free1Dim(controlData);
    free1Dim(snpData1);
    free1Dim(snpData2);

    return;
}

/* nv^Cv֘A͂Type I error̊mvZs */
int TypeIExecute(double *freq, char **haplotype, long L, double Sobs, long a, long b, long dataNum, double *typeIError, long repeat, long gen)
{
    int burnin = 100000; //10ɕύX
    int **X = NULL;
    int flag = 0;
    long j = 0;
    long m = 0;
    long n = 0;
    long pop = 0;
    long copyNumber = 0;

    double S = 0;
    double total = 0;
    double diff = 0;

    // Ŏw肷悤ɕύX
    //double gen = 100000;

    int **Tresample = NULL;             /* 􌻕\ */
    int *populationType = NULL;
    char **sequences = NULL;

    SnpData *resampledData1 = NULL;
    SnpData *resampledData2 = NULL;

    copyNumber = a + b;

    /* f[^i[p\̂̃m */
    resampledData1 = (SnpData*)malloc1Dim(sizeof(SnpData), dataNum);
    resampledData2 = (SnpData*)malloc1Dim(sizeof(SnpData), dataNum);
    DataReaderSnpDataMemoryAllocate(resampledData1, dataNum, a);
    DataReaderSnpDataMemoryAllocate(resampledData2, dataNum, b);
    /* sequences̃m */
    sequences = (char**)mallocChar2Dim(a + b, dataNum);
    if (NULL == sequences) { goto finalize; }
    /* 􌻕\Tresamplẽm */
    Tresample = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == Tresample){ goto finalize; }
    /* populationTypẽm */
    populationType = (int*)malloc1Dim(sizeof(int), a + b);
    if (NULL == populationType) { goto finalize; }

    //for (burnin = 0; burnin < 1 + gen * 0; burnin += 100000){ //burninŃ[vȂ悤ɕύX
        /* m */
        X = (int**)mallocInt2Dim(2, L);
        if (NULL == X) { goto finalize; }

        /* procedure 2 */
        //TypeIStartSet2(a, L, X[0]);
        //TypeIStartSet2(b, L, X[1]);
        TypeIStartSet(a, freq, L, X[0]);
        TypeIStartSet(b, freq, L, X[1]);

        /* start Markov */
        /* burn in */
        for (m = 0; m < burnin; m++){
            TypeIMarkov(X, freq, L);
        }

        for (n = 0; n < repeat; n++){
            diff = 0;
            for (m = 0; m < gen; m++){
                total++;
                TypeIMarkov(X, freq, L);

                /* nv^CvXŕ\Ă鐔̔z쐬 */
                TypeISampling(X[0], haplotype, dataNum, L, sequences);
                /* DNAzf[^SnpData̔zɕϊ */
                DataReaderSequenceToSnpData(sequences, resampledData1, dataNum, a);
                /* nv^CvXŕ\Ă鐔̔z쐬 */
                TypeISampling(X[1], haplotype, dataNum, L, sequences);
                /* DNAzf[^SnpData̔zɕϊ */
                DataReaderSequenceToSnpData(sequences, resampledData2, dataNum, b);

                flag = 0; //tO
                for (j = 0; j < dataNum; j++){
                    /* ϑl􌻕\쐬 */
                    DataReaderPopulationType(&resampledData1[j], &resampledData2[j], populationType);
                    DataReaderMakeTableDi(&resampledData1[j], &resampledData2[j], populationType, Tresample);
                    /* XRAvZ@XRAvZ0ɂȂĂ܂ꍇ-1Ԃ */
                    S = TableCalcScore(Tresample);
                    /* őXRA肷 */
                    if (S >= Sobs){
                        //diff++;
                        flag = 1; //S>=Sobs𔻒ftOĂ
                    }
                }
                /* ȏႢƂɈJEg */
                if (flag > 0){
                    diff++;
                }
            }
            typeIError[n] = diff/gen;
            /* mFpWo */
            //printf("%d\t%d\t%d\t%d\t%d\t%lf\n", n+1, a, b, copyNumber, burnin, diff/gen);
        }
    //}

finalize:;
    /* mۂJ */
    freeInt2Dim(X, 2);
    freeChar2Dim(sequences, a + b);
    free1Dim(resampledData1);
    free1Dim(resampledData2);



    return 0;
}

/* MCMCs */
void TypeIMarkov(int **X, double *h, long L)
{
    int j = 0;
    long u = 0;
    long v = 0;
    int XjuStar = 0;
    int XjvStar = 0;

    double c = 0;
    double tmp = 0;

    /* procedure 3 */
    j = TypeIZeroOne();

    /* procedure 4 */
    u = (int)(myRand() * L);

    if (0 == X[j][u]){ /* condition 5 */
        /* invariant */
    }
    else{ /* condition 6 */
        v = 0;
        do{
            v = (int)(myRand() * L);
        } while(u == v);
        
        /* new candidate */
        XjuStar = X[j][u] - 1;
        XjvStar = X[j][v] + 1;

        /* transition probability */
        c = h[v] * X[j][u] / (h[u] * (X[j][v] +1));

        if (c >= 1){ /* condition 8 */
            X[j][u] = XjuStar;
            X[j][v] = XjvStar;
        }
        else{
            tmp = myRand();
            if (tmp < c){
                X[j][u] = XjuStar;
                X[j][v] = XjvStar;
            }
        }

        /* procedure 10 */
    }
}

/* ŏhaplotypeSƂZbg */
int TypeIStartSet2(long sampleSize, long L, int *result)
{
    long i = 0;
    long sum = 0;

    /* z񏉊 */
    for(i = 0; i < L; i++){
        result[i] = 0;
    }

    result[0] = sampleSize;

    return 0;
}

/* pxɔႳŏ̃Zbg쐬 */
int TypeIStartSet(long sampleSize, double *frequency, long L, int *result)
{
    long i = 0;
    long sum = 0;

    /* z񏉊 */
    for(i = 0; i < L; i++){
        result[i] = 0;
    }

    i = 0;
    for (i = 0; i < sampleSize; i++){
        result[ TypeIDiscreteRandomValue(frequency, L) ]++;
    }

    return 0;
}

/* pxɔႵl_ɕԂ */
long TypeIDiscreteRandomValue(double *xlist, long len)
{
    long i = 0;
    long num = 0;
    double x = 0;
    double all = 0;
    double tmp = 0;

    for (i = 0; i < len; i++){
        all += xlist[i];
    }
    x = myRand() * all;

    for (i = 0; i < len; i++){
        tmp += xlist[i];
        if (x > tmp){
            num++;
        }
    }

    return num;
}

/* m1/201Ԃ */
int TypeIZeroOne()
{
    /* return 0 or 1 with probability 0.5 */
    int result = 0;

    result = (int)(myRand() * 2);

    return result;
}



/* nv^CvXŕ\Ă鐔̔z쐬 */
int TypeISampling(int *X, char **haplotype, long dataNum, long L, char **sequences)
{
    /* dataNumFSNP */
    /* LFnv^Cv̐iނ̐j */
    long tmp = 0;
    long h = 0;
    long h2 = 0;

    for (h = 0; h < L; h++){
        for (h2 = 0; h2 < X[h]; h2++){
            strncpy(sequences[tmp], haplotype[h], dataNum);
            tmp++;
        }
    }

    return 0;
}
