#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "snp_Config.h"
#include "snp_Permutation.h"
#include "snp_Factorial.h"
#include "snp_Q.h"
#include "snp_G.h"
#include "snp_Table.h"
#include "snp_Primitive.h"
#include "snp_MCMC.h"
#include "snp_Gsampler.h"
#include "snp_DataReader.h"
#include "snp_MemoryControl.h"
#include "snp_GetTime.h"

#include "mpi.h"

#define NUM_TM	100
double tm[NUM_TM];  /* Ԍvp */

/* t@Cf[^IŕێČvZ */
void MainProgramB(InputData *inputData, int nProc, int rank);

int main(int argc, char* argv[])
{
    int i = 0;
    int num = 0;
    int nProc = 0;		/* mۂvZbŤixj */
    int rank = 0;		/* Nԍ */
    InputData inputData={"", "", "", PRINT_LEVEL, SCORE, REPEAT, ANALYSIS, DATA_TYPE};

    double t1 = 0.0, t2 = 0.0;

    t1 = gettimeofdaySec(); /* Jn */

    /* Ԍvpϐ̏ */
    for (i = 0; i < NUM_TM; i++){
        tm[i] = 0.0;
    }

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &nProc);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    // MPI_Barrier(MPI_COMM_WORLD);	/* vZJn */
    tm[0] = MPI_Wtime();

    /****************************/
    /* ͂Ŏw肷ꍇ */
    /****************************/
    if(argc != 9){
        if (rank == 0) {
            printf("[usage]main.exe [InputFile1] [InputFile2] [OutputFile1] [OutputLevel1] [Score] [Repeat] [Analysis] [DataType]\n");
        }
        MPI_Finalize();
        return 255;
    }
    strcpy(inputData.inputFile1, argv[1]);
    strcpy(inputData.inputFile2, argv[2]);
    strcpy(inputData.outputFile1, argv[3]);
    inputData.outputLevel = atoi(argv[4]);
    inputData.score = atoi(argv[5]);
    inputData.repeat = atol(argv[6]);
    inputData.analysis = atoi(argv[7]);
    inputData.dataType = atoi(argv[8]);

    /* XRAvZ@̎w */
    iWay = inputData.score;

    /* t@Cf[^IŕێČvZ */
    MainProgramB(&inputData, nProc, rank);

    //MPI_Barrier(MPI_COMM_WORLD);	/* vZI */
    tm[5] = MPI_Wtime();

    /* MPII */
    MPI_Finalize();

    printf("%d,1,time,Init-Bcast,%lf,(sec)\n", rank, tm[1] - tm[0]);
    printf("%d,2,time,Bcast,%lf,(sec)\n", rank, tm[2] - tm[1]);
    printf("%d,3,time,Calculation,%lf,(sec)\n", rank, tm[3] - tm[2]);
    printf("%d,4,time,Gather,%lf,(sec)\n", rank, tm[4] - tm[3]);
    printf("%d,5,time,Gather-End,%lf,(sec)\n", rank, tm[5] - tm[4]);

    t2 = gettimeofdaySec(); /* I */

    printf("%d,6,time,All,%lf,(sec)\n", rank, t2 - t1);

    return 0;
}

/* t@Cf[^IŕێČvZ */
void MainProgramB(InputData *inputData, int nProc, int rank)
{
    int retval = 0;

    long i = 0;
    long k = 0;
    long fileLine1 = 0; /* ̓t@C̃C */
    long fileLine2 = 0;
    long dataNum = 0;   /* pbLO̓̓f[^ */
    long repeat = 0;    /* Permutation̎s */

    int **T = NULL;     /* 􌻕\ */
    double Sobs = 0;    /* Score̒l ϑn */
    int count = 0;

    double p = 0;
    double Pr = 0;

    int *numOutputs = NULL;		/* NƂ̏o̓f[^ */
    long numAllOutput = 0L;		/* So̓f[^ */
    int *outDataOffsets = NULL;	/* So̓f[^ɂ郉NƂ̏o̓f[^̈ʒu */
    int numPartOutput = 0;

    FILE *fpIn1 = NULL;
    FILE *fpIn2 = NULL;
    FILE *fpOut = NULL;

    SnpData *snpTmpData1 = NULL;
    SnpData *snpTmpData2 = NULL;
    SnpData *snpData1 = NULL;
    SnpData *snpData2 = NULL;

    OutputData *outputData = NULL;
    OutputData *outputAllData = NULL;

    Table Tbl;

/* MPI֌W */
#define MAX_BLOCK_NUM 10    /* MPIp\̂쐬Ƃ̌^̃ubN */
    /* MPIp̍\̂p[^ */
    long dataPartSize = 0L; /* 񉻎̃f[^ */
    long dataPartNum = 0L; /* 񉻎̃f[^ */
    int blockcount[MAX_BLOCK_NUM];
    MPI_Aint address[MAX_BLOCK_NUM];
    MPI_Datatype type[MAX_BLOCK_NUM];
    MPI_Datatype MPI_INPUT_STRUCT, MPI_OUTPUT_STRUCT;

    SnpData sti;
    OutputData sto;

    int inSize = 0, outSize = 0;

    /* MPIp̍\̂p[^̏ */
    for (i = 0; i < MAX_BLOCK_NUM; i++) {
        blockcount[i] = 0;
        address[i] = (MPI_Aint)NULL;
        type[i] = MPI_INT;
    }

    repeat = inputData->repeat;

    if (rank == 0) {
        /* t@CI[v */
        retval = InputFileOpen(&fpIn1, inputData->inputFile1);
        if (retval != 0){
            MPI_Abort(MPI_COMM_WORLD, retval);
            goto finalize;
        }
        retval = InputFileOpen(&fpIn2, inputData->inputFile2);
        if (retval != 0){
            MPI_Abort(MPI_COMM_WORLD, retval);
            goto finalize;
        }
        retval = OutputFileOpen(&fpOut, inputData->outputFile1);
        if (retval != 0){
            MPI_Abort(MPI_COMM_WORLD, retval);
            goto finalize;
        }
        /* ̓t@C̃C擾 */
        fileLine1 = DataReaderCountFileLine(fpIn1);
        fileLine2 = DataReaderCountFileLine(fpIn2);

        /* t@C|C^擪ɖ߂ */
        fseek(fpIn1, 0L, SEEK_SET);
        fseek(fpIn2, 0L, SEEK_SET);

        /* f[^ꎞi[p\̂̃m */
        snpTmpData1 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine1);
        snpTmpData2 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine2);

        /* f[^t@Cǂݍݍ\̂Ɏ߂ */
        DataReaderSetAllData(fpIn1, snpTmpData1, fileLine1, inputData->dataType);
        DataReaderSetAllData(fpIn2, snpTmpData2, fileLine2, inputData->dataType);

        /* ̓f[^̐`FbNĕ񉻗p̓̓f[^쐬 */
        dataNum = DataReaderMakeParallelData(snpTmpData1, snpTmpData2, fileLine1, fileLine2, &snpData1, &snpData2);

        /* vZbT  f[^̏ꍇAI */
        if (nProc > dataNum) {
            fprintf(stderr, "vZbTf[^ݒ肳Ă܂.\n");
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }

        /* gpȂz̃J */
        free1Dim(snpTmpData1);
        free1Dim(snpTmpData2);
        snpTmpData1 = NULL;
        snpTmpData2 = NULL;
    }

    /* Sf[^̑M */
    MPI_Bcast(&dataNum, 1, MPI_LONG, 0, MPI_COMM_WORLD);
    if (rank != 0) {
        /* N0ȊO̓̓f[^̃m */
        snpData1 = (SnpData*)malloc1Dim(sizeof(SnpData), dataNum);
        snpData2 = (SnpData*)malloc1Dim(sizeof(SnpData), dataNum);
    }
    
    /* vZbTƂ̃f[^vZ */
    dataPartNum = dataNum / nProc;
    if (rank < dataNum % nProc){
      dataPartNum++;
    }
    /* evZbTɂf[^̃ItZbgľvZ */
    if (rank < dataNum % nProc){
        k = dataPartNum * rank;
    }
    else{
        k = (dataPartNum + 1) * (dataNum % nProc) + dataPartNum * (rank - dataNum % nProc);
    }
    
    /* o͗pf[^i[\̔z̃m */
    outputData = (OutputData*)malloc1Dim(sizeof(OutputData), dataPartNum);

    /* 􌻕\T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }

    /* MPIp̍\̒` */
    /* ̓f[^pMPIp̍\̒` */
    blockcount[0] = RS_NUM_LEN;
    blockcount[1] = SNP_NUM;
    blockcount[2] = CHROM_LEN;
    blockcount[3] = 1;
    blockcount[4] = 3 + SNP_COUNT;
    MPI_Address(sti.rsNumber, &address[0]);
    MPI_Address(sti.SNPalleles, &address[1]);
    MPI_Address(sti.chrom, &address[2]);
    MPI_Address(&sti.pos, &address[3]);
    MPI_Address(&sti.allelesNum, &address[4]);
    for (i = 4; i >= 0; i--){
        address[i] -= address[0];
    }
    /* ^w */
    type[0] = MPI_CHAR;
    type[1] = MPI_CHAR;
    type[2] = MPI_CHAR;
    type[3] = MPI_LONG;
    type[4] = MPI_INT;
    MPI_Type_struct(5, blockcount, address, type, &MPI_INPUT_STRUCT);
    MPI_Type_commit(&MPI_INPUT_STRUCT);
    /* o̓f[^pMPIp̍\̒` */
    blockcount[0] = 5;
    blockcount[1] = 1;
    MPI_Address(&sto.Sobs, &address[0]);
    MPI_Address(&sto.count, &address[1]);
    for (i = 1; i >= 0; i--){
        address[i] -= address[0];
    }
    /* ^w */
    type[0] = MPI_DOUBLE;
    type[1] = MPI_INT;
    MPI_Type_struct(2, blockcount, address, type, &MPI_OUTPUT_STRUCT);
    MPI_Type_commit(&MPI_OUTPUT_STRUCT);

	/* \̂̃TCYmF */
	MPI_Type_size(MPI_INPUT_STRUCT, &inSize);
	MPI_Type_size(MPI_OUTPUT_STRUCT, &outSize);

    //MPI_Barrier(MPI_COMM_WORLD);	/* BcastO */
    tm[1] = MPI_Wtime();

    /* eNւ̓̓f[^̑M */
    MPI_Bcast(snpData1, dataNum, MPI_INPUT_STRUCT, 0, MPI_COMM_WORLD);
    MPI_Bcast(snpData2, dataNum, MPI_INPUT_STRUCT, 0, MPI_COMM_WORLD);

    //MPI_Barrier(MPI_COMM_WORLD);	/* Bcast */
    tm[2] = MPI_Wtime();

    /* log e[u쐬 */
    retval = FactorialSetFactorial((snpData1[0].dataNum + snpData2[0].dataNum) * 2);

    for (i = 0; i < dataPartNum; i++){

        /* Q̓̓f[^􌻕\쐬 */
        DataReaderMakeTable(&snpData1[k], &snpData2[k], T);

        switch(inputData->analysis){
            case 0:
                /* XRAvZ */
                outputData[i].Sobs = TableCalcScore(T);

                /* Permutations */
                outputData[i].count = PermutationExecute(T, outputData[i].Sobs, repeat);

                /* Permutationł̊mPr(T) */
                retval = TableMakeTableIntArray(&Tbl, T);
                outputData[i].Pr = 
                    FactorialGetLogCombination(Tbl.verticalSum[0], Tbl.table[0][0]) + 
                    FactorialGetLogCombination(Tbl.verticalSum[1], Tbl.table[0][1]) +
                    FactorialGetLogFactorial(Tbl.horizontalSum[0]) +
                    FactorialGetLogFactorial(Tbl.horizontalSum[1]) -
                    FactorialGetLogFactorial(Tbl.horizontalSum[0] + Tbl.horizontalSum[1]);

                /* m@ŌvZ */
                outputData[i].p = GCalcP(Tbl, outputData[i].Sobs);

                /* \tablẽJ */
                TableFinalTable(&Tbl);

                break;
            default:
                break;
        }
        k++;
    }

    /* ̓f[^Ɠij*/
    numPartOutput = dataPartNum;

    //MPI_Barrier(MPI_COMM_WORLD);	/* GatherO */
    tm[3] = MPI_Wtime();

    if (rank == 0) {
		numOutputs = (int *)malloc1Dim(sizeof(int), nProc);
		if (numOutputs == NULL) {
			MPI_Abort(MPI_COMM_WORLD, 1);	// add 20090108
			goto finalize;
		}
		outDataOffsets = (int *)malloc1Dim(sizeof(int), nProc);
		if (outDataOffsets == NULL) {
			MPI_Abort(MPI_COMM_WORLD, 1);	// add 20090108
			goto finalize;
		}
	}
	/* eNvZo͒ľ */
	MPI_Gather(&numPartOutput, 1, MPI_INT, numOutputs, 1,MPI_INT, 0, MPI_COMM_WORLD);
	if (rank == 0) {
		/* So͂̌ */
		numAllOutput = 0L;
		for (i = 0; i < nProc; i++) {
			numAllOutput += numOutputs[i];
		}
		/* NƂ̃f[^̃ItZbgľvZ */
		outDataOffsets[0] = 0;
		for (i = 1; i < nProc; i++) {
			outDataOffsets[i] = outDataOffsets[i-1] + numOutputs[i-1];
		}
        /* o͗pf[^i[\̔z̃m */
        outputAllData = (OutputData*)malloc1Dim(sizeof(OutputData), numAllOutput);
    }

    /* evZbT̃f[^̎W */
    MPI_Gatherv(outputData, numPartOutput, MPI_OUTPUT_STRUCT, outputAllData,
               numOutputs, outDataOffsets, MPI_OUTPUT_STRUCT, 0, MPI_COMM_WORLD);

    //MPI_Barrier(MPI_COMM_WORLD);	/* Gather */
    tm[4] = MPI_Wtime();

    if (rank == 0) {
        /* 茋ʃt@Co */
        DataReaderOutputAllResult(inputData->outputLevel, fpOut, snpData1, snpData2, outputAllData, inputData, numAllOutput);
    }


finalize:;
    if (rank == 0) {
        /* t@CN[Y */
        FileClose(fpIn1);
        FileClose(fpIn2);
        FileClose(fpOut);
        /* mۂJ */
        free1Dim(snpTmpData1);
        free1Dim(snpTmpData2);
        free1Dim(outputAllData);
    }

    /* mۂJ */
    freeInt2Dim(T, ROW);
    free1Dim(snpData1);
    free1Dim(snpData2);
    free1Dim(outputData);
    free1Dim(numOutputs);
    free1Dim(outDataOffsets);
    /* loge[uNA */
    FactorialDeleteFactorial();
    /* \tablẽJ */
    //TableFinalTable(&Tbl);
       
    return;
}
