#!/bin/sh

if [ $# != 9 ];
  then
    echo "[usage]`basename $0` [InputFile1] [InputFile2] [OutputFile1] [OutputLevel] [Score] [Repeat] [Analysis] [DataType] [ProcNum]"
    exit
fi

InputFile1=$1
InputFile2=$2
OutputFile1=$3
OutputLevel=$4
Score=$5
Repeat=$6
Analysis=$7
DataType=$8
ProcNum=$9
ScriptFile=`basename $OutputFile1`.batch

### InputFile1 is not exist, exit
if [ ! -e "$InputFile1" ];
  then
    echo "$InputFile1 is not exist"
    exit
fi

### InputFile2 is not exist, exit
if [ ! -e "$InputFile2" ];
  then
    echo "$InputFile2 is not exist"
    exit
fi

### Check OutputLevel
if [ $OutputLevel != 0 -a $OutputLevel != 1 ];
  then
    echo "Input error of OutputLevel"
    exit
fi

### Check Score
if [ $Score != 0 -a $Score != 1 ];
  then
    echo "Input error of Score"
    exit
fi

### Check Analysis
if [ $Analysis != 0 ];
  then
    echo "Input error of Analysis"
    exit
fi

### Check DataType
if [ $DataType != 0 -a $DataType != 1 -a $DataType != 2 ];
  then
    echo "Input error of DataType"
    exit
fi


### Make BatchScriptFile
echo "#!/bin/sh" > $ScriptFile
echo "" >> $ScriptFile
echo "#$ -pe orte $ProcNum" >> $ScriptFile
#echo "#$ -pe mpich $ProcNum" >> $ScriptFile
echo "#$ -l h_rt=01:00:00" >> $ScriptFile
echo "#$ -cwd" >> $ScriptFile
echo "#$ -j y" >> $ScriptFile
echo "" >> $ScriptFile
echo "cd \${QSUB_WORKDIR}" >> $ScriptFile
echo "mpirun -np \$DFS_NSLOTS -orte ./permutationParallel.exe $InputFile1 $InputFile2 $OutputFile1 $OutputLevel $Score $Repeat $Analysis $DataType" >> $ScriptFile

### Execute Batch Job
qsub $ScriptFile

### Delete BatchScriptFile
rm $ScriptFile
