#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef MPI_USE
#include <mpi.h>
#endif

#define _MAIN_DEF

#include "HaplotypePhasing.h"


#ifdef MPI_USE
/** MPȈ
 *  MPIp̈āA폜B
 *  @param argc [IN/OUT] ̐
 *  @param argv [IN/OUT] 
 */
void setupMPI(int *argc, char ***argv)
{
    MPI_Init(argc, argv);
    MPI_Comm_size(MPI_COMM_WORLD, &MyMpiSize);
    MPI_Comm_rank(MPI_COMM_WORLD, &MyMpiRank);
}
#endif /* MPI_USE */

/* C֐ */
int main(int argc, char* argv[])
{
    int i = 0;
    InputPhasing inputPhasing={"", "", "", 0};

#ifdef MPI_USE
    /* MPIɂ鏉 */
    setupMPI(&argc, &argv);

    /* Ԍvpϐ̏ */
    for (i = 0; i < NUM_TM; i++){
        tm[i] = 0.0;
    }

    /* Ԍv */
    tm[TM_START] = MPI_Wtime();
#endif /* MPI_USE */

    if(argc != 6){
        printf("[usage]main.exe [InputFile1] [LDblockFile] [OutputFile] [PhasingType] [SNPNumLimit]\n");
        return 255;
    }
    strcpy(inputPhasing.inputFile, argv[1]);
    strcpy(inputPhasing.ldBlockFile, argv[2]);
    strcpy(inputPhasing.outputFile, argv[3]);
    inputPhasing.phasingType = atoi(argv[4]);
    inputPhasing.snpNumLimit = atoi(argv[5]);


    /* nv^CvtF[WOs */
    haplotypePhasing(&inputPhasing);

#ifdef MPI_USE
    /* Ԍv */
    tm[TM_END] = MPI_Wtime();

    /* MPII */
    MPI_Finalize();

    printf("%4d\t%lf\t%lf\t%lf\t%lf\t%lf\t%lf\t%lf \n",
           MyMpiRank,
           tm[TM_SPLIT]    - tm[TM_START],
           tm[TM_BCAST]    - tm[TM_SPLIT],
           tm[TM_PHASE]    - tm[TM_BCAST],
           tm[TM_Barrier]  - tm[TM_PHASE],
           tm[TM_MERGE]    - tm[TM_Barrier],
           tm[TM_END]      - tm[TM_MERGE],
           tm[TM_END]      - tm[TM_START]);
/*
    printf("%4d  1 time Init        %lf (sec)\n", MyMpiRank, tm[TM_READ]     - tm[TM_START]);
    printf("%4d  2 time Read        %lf (sec)\n", MyMpiRank, tm[TM_SPLIT]    - tm[TM_READ]);
    printf("%4d  3 time Split       %lf (sec)\n", MyMpiRank, tm[TM_BCAST]    - tm[TM_SPLIT]);
    printf("%4d  4 time Bcast       %lf (sec)\n", MyMpiRank, tm[TM_PHASE]    - tm[TM_BCAST]);
    printf("%4d  5 time Phase       %lf (sec)\n", MyMpiRank, tm[TM_Barrier]  - tm[TM_PHASE]);
    printf("%4d  6 time Barrier2    %lf (sec)\n", MyMpiRank, tm[TM_MERGE]    - tm[TM_Barrier]);
    printf("%4d  7 time Merge       %lf (sec)\n", MyMpiRank, tm[TM_END]      - tm[TM_MERGE]);
    printf("%4d  8 time Total       %lf (sec)\n", MyMpiRank, tm[TM_END]      - tm[TM_START]);
*/
#endif /* MPI_USE */

    return 0;
}


/* nv^CvtF[WOs */
void haplotypePhasing(InputPhasing *inputPhasing)
{
    int retval = 0;
    int flag = 0;
    long i = 0;
	long j = 0;
    long k = 0;
    long index = 0;
    long fileLine = 0;          /* ̓t@C̃C */
    long ldBlockFileLine = 0;   /* LDubNt@C̃C */
    long jStart = 0;            /* LDubN̍ŏSNPʊi[ϐ */
    long jEnd = 0;              /* LDubN̍ŌSNPʊi[ϐ */
    long blockNum = 0;          /* LDubN */
    long tmpBlockNum = 0;          /* LDubN */
    long startPos = 0;
    long endPos = 0;
    long count = 0;

    long *ldBlock = NULL;       /* eLDubNi[p */
    long *linkSNPNum = NULL;    /* eLDubNSNPi[p */
    long *linkSNPStart = NULL;  /* eLDubN̍ŏSNPʊi[p */

    FILE *fpIn = NULL;      /* ̓t@C|C^ */
    FILE *fpOut = NULL;     /* o̓t@C|C^ */
    FILE *fpLD = NULL;    /* LDubNt@C|C^ */


    SnpData *snpData = NULL;

#ifdef MPI_USE
    /* Ԍv */
    tm[TM_READ] = MPI_Wtime();

    /* rank0̂ݎs */
    if (MyMpiRank == 0) {
#endif /* MPI_USE */

        /* t@CI[v */
        retval = InputFileOpen(&fpIn, inputPhasing->inputFile);
        if (retval != 0){
            goto finalize;
        }
        retval = InputFileOpen(&fpLD, inputPhasing->ldBlockFile);
        if (retval != 0){
            goto finalize;
        }


/****************************************************************/
/* f[^                                                   */
/****************************************************************/
 
        /* LDubNt@C̃C擾 */
        ldBlockFileLine = DataReaderCountFileLine(fpLD);
        /* LDubNi[pz̃m */
        ldBlock = (long*)malloc1Dim(sizeof(long), ldBlockFileLine);
        if (NULL == ldBlock){ goto finalize; }
        /* t@C|C^擪ɖ߂ */
        fseek(fpLD, 0L, SEEK_SET);
        /* LDubNzɎ߂ */
        DataReaderSetLDBlock(fpLD, ldBlock);

        /* ̓t@C̃C擾 */
        fileLine = DataReaderCountFileLine(fpIn);
        /* t@C|C^擪ɖ߂ */
        fseek(fpIn, 0L, SEEK_SET);
        /* f[^i[p\̂̃m */
        snpData = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine);
        if (NULL == snpData){ goto finalize; }
        /* f[^t@Cǂݍݍ\̂Ɏ߂ */
        DataReaderSetAllHapmapData(fpIn, snpData, fileLine, inputPhasing->phasingType);

/****************************************************************/
/* LDubN쐬                                                   */
/****************************************************************/

        /* LDubN */
        blockNum = ldBlockFileLine - 1;
        /* LDubNɊYSNPf[^ */
        for (i = 0; i < blockNum; i++){ /* Ä̏dꍇl */
            startPos = ldBlock[i];
            endPos = ldBlock[i+1];
            count = 0;
            /* ̓f[^̓|WVŃ\[gĂƉ */
            for (j = 0; j < fileLine; j++){
                if (startPos <= snpData[j].pos){
                    if (snpData[j].pos < endPos){
                        /* ̈SNPJEg */
                        count++;
                    }
                    /* ȍ~ÄɊYf[^͏oȂ̂Ŏ̃ubN𒲂ׂ */
                    else {
                        break;
                    }
                }
            }
            /* ubNSNPl𒴂ĂꍇAɕ */
            tmpBlockNum += (count - 1) / inputPhasing->snpNumLimit;
        }


        blockNum += tmpBlockNum;
        /* eLDubNSNPi[pz̃m */
        linkSNPNum = (long*)malloc1Dim(sizeof(long), blockNum);
        if (NULL == linkSNPNum){ goto finalize; }
        /* eLDubN̍ŏSNPʊi[pz̃m */
        linkSNPStart = (long*)malloc1Dim(sizeof(long), blockNum);
        if (NULL == linkSNPStart){ goto finalize; }


        /* eLDubNɊYSNPf[^ SNP */
        for (i = 0, k = 0; i < blockNum; i++){ /* Ä̏dꍇl */
            startPos = ldBlock[k];
            endPos = ldBlock[k+1];
            flag = 0;
            /* ̓f[^̓|WVŃ\[gĂƉ */
            for (j = 0; j < fileLine; j++){
                if (startPos <= snpData[j].pos){
                    if (snpData[j].pos < endPos){
                        /* LDubNSNPl𒴂ꍇ */
                        if (linkSNPNum[i] == inputPhasing->snpNumLimit){
                            i++;
                            flag = 0;
                        }
                        /* ̈SNPJEg */
                        linkSNPNum[i]++;
                        /* ̈̍ŏSNPʂێ */
                        if (0 == flag ){
                            linkSNPStart[i] = j;
                            flag = 1;
                        }
                    }
                    /* ȍ~ÄɊYf[^͏oȂ̂Ŏ̃ubN𒲂ׂ */
                    else {
                        break;
                    }
                }
            }
            k++;
        }

#ifdef MPI_USE
    /* rank0̂ݎs܂ */
    }
#endif /* MPI_USE */

/****************************************************************/
/* Hapmapf[^̕ϊ                                   */
/****************************************************************/

#ifdef MPI_USE
    /* Ԍv */
    tm[TM_SPLIT] = MPI_Wtime();

    /* rank0̂ݎs */
    if (MyMpiRank == 0) {
#endif /* MPI_USE */

        /* Hapmapf[^tF[WO͌`ɕϊ */
        transHapmapForPhasing(inputPhasing, snpData, blockNum, linkSNPNum, linkSNPStart);

#ifdef MPI_USE
    /* rank0̂ݎs܂ */
    }

    /* Ԍv */
    tm[TM_BCAST] = MPI_Wtime();

    /* ubN̑M */
    MPI_Bcast(&blockNum, 1, MPI_LONG, 0, MPI_COMM_WORLD);

    if (MyMpiSize > blockNum) {
        /* rank0̂ݎs */
        if (MyMpiRank == 0) {
            fprintf(stderr, "vZbT(%d)f[^ubN(%ld)ݒ肳Ă܂.\n", MyMpiSize, blockNum);
        }
        MPI_Abort(MPI_COMM_WORLD, 1);
        goto finalize;
    }

    /* Ԍv */
    tm[TM_PHASE] = MPI_Wtime();
#endif /* MPI_USE */

/****************************************************************/
/* tF[WO                                             */
/****************************************************************/

    /* tF[WOs */
    executePhasing(inputPhasing, blockNum);

/****************************************************************/
/* tF[WOʂPhasingHapmapf[^֕ϊ      */
/****************************************************************/

#ifdef MPI_USE
    /* Ԍv */
    tm[TM_Barrier] = MPI_Wtime();

    /* Srank̃tF[WOI܂őҋ@ */
    MPI_Barrier(MPI_COMM_WORLD);

    /* Ԍv */
    tm[TM_MERGE] = MPI_Wtime();

    /* rank0̂ݎs */
    if (MyMpiRank == 0) {
#endif /* MPI_USE */

        /* tF[WOo͌ʂHapmap`ɕϊ */
        transPhasedDataFotHapmap(inputPhasing, snpData, blockNum, linkSNPNum, linkSNPStart);

#ifdef MPI_USE
    /* rank0̂ݎs܂ */
    }
#endif /* MPI_USE */

/****************************************************************/
/* I                                                     */
/****************************************************************/

finalize:;

#ifdef MPI_USE
    /* rank0̂ݎs */
    if (MyMpiRank == 0) {
#endif /* MPI_USE */

        /* t@CN[Y */
        FileClose(fpIn);
        FileClose(fpOut);
        FileClose(fpLD);
        /* mۂJ */
        DataReaderSnpDataMemoryFree(snpData, fileLine);
        free1Dim(ldBlock);
        free1Dim(linkSNPNum);
        free1Dim(linkSNPStart);

#ifdef MPI_USE
    /* rank0̂ݎs܂ */
    }
#endif /* MPI_USE */

    return;
}

/* Hapmapf[^tF[WO͌`ɕϊ */
int transHapmapForPhasing(InputPhasing *inputPhasing, SnpData *snpData, long blockNum, long *linkSNPNum, long *linkSNPStart)
{
    int retval = 0;
    char tmpFileName[MAX_LEN];
    long i = 0;
    long j = 0;
    long k = 0;
    long jStart = 0;            /* LDubN̍ŏSNPʊi[ϐ */
    long jEnd = 0;              /* LDubN̍ŌSNPʊi[ϐ */

    FILE *fpOut = NULL;     /* o̓t@C|C^ */

    /* LDubNPʂŃ[v */
    jStart = 0;
    for (i = 0; i < blockNum; i++){
        /* ԃf[^o͗p̃t@CI[v */
        sprintf(tmpFileName, "%s_input%ld", inputPhasing->outputFile, i);
        retval = OutputFileOpen(&fpOut, tmpFileName);
        if (retval != 0){
            goto finalize;
        }

        jStart = linkSNPStart[i];
        jEnd = jStart + linkSNPNum[i];

        /* tF[WOւ̓̓t@C쐬 */
        if (inputPhasing->phasingType == 1){
            /* PHASEł̃tF[WȌꍇ */
            fprintf(fpOut, "%d\n", snpData[1].sampleNum);
            fprintf(fpOut, "%ld\n", linkSNPNum[i]);
            for (j = jStart; j < jEnd; j++){
                fprintf(fpOut, "S");
            }
            fprintf(fpOut, "\n");
        }
        for (k = 0; k < snpData[1].sampleNum; k++){
            if (inputPhasing->phasingType == 0){
            /* snphapł̃tF[WȌꍇ */
                fprintf(fpOut, "%ld ", k+1);
            }
            for (j = jStart; j < jEnd; j++){
                fprintf(fpOut, "%c %c ", (snpData+j)->SNPdata[2*k], (snpData+j)->SNPdata[2*k+1]);
            }
            fprintf(fpOut, "\n");
        }

        /* ԃf[^o͗p̃t@CN[Y */
        FileClose(fpOut);
        fpOut = NULL;
    }

/****************************************************************/
/* I                                                     */
/****************************************************************/

finalize:;
    /* t@CN[Y */
    FileClose(fpOut);

    return retval;
}

/* tF[WOs */
int executePhasing(InputPhasing *inputPhasing, long blockNum)
{
    int retval = 0;
    char tmpFileName[MAX_LEN];
    char inputFileName[MAX_LEN];
    char outputFileName[MAX_LEN];
    char cmd[MAX_LEN];
    long i = 0;
    long blockPartNum = 0;
    long blockPartStart = 0;

#ifdef MPI_USE
    /* vZbTƂ̃ubNvZ */
    blockPartNum = blockNum / MyMpiSize;
    if (MyMpiRank < blockNum % MyMpiSize) {
        blockPartNum++;
    }
    /* evZbTɂf[^̃ItZbgľvZ */
    if (MyMpiRank < blockNum % MyMpiSize) {
        blockPartStart = blockPartNum * MyMpiRank;
    }
    else{
        blockPartStart = (blockPartNum + 1) * (blockNum % MyMpiSize)
                       + blockPartNum * (MyMpiRank - blockNum % MyMpiSize);
    }
#else
    blockPartStart = 0;
    blockPartNum = blockNum;
#endif /* MPI_USE */

    /* LDubNPʂŃ[v */
    for (i = blockPartStart; i < blockPartStart + blockPartNum; i++){
        /* tF[WO̓̓t@CZbg */
        sprintf(inputFileName, "%s_input%ld", inputPhasing->outputFile, i);
        /* tF[WȌo̓t@CZbg */
        sprintf(outputFileName, "%s_output%ld", inputPhasing->outputFile, i);
        /* tF[WÕe|o̓t@CZbg */
        sprintf(tmpFileName, "%s_output_tmp%ld", inputPhasing->outputFile, i);

        /* tF[WOs */
        if (inputPhasing->phasingType == 0) {
            /* snphaps */
            //spawnlp(P_WAIT, "snphap", "snphap", inputFileName, tmpFileName, outputFileName, NULL);
            sprintf(cmd, "snphap %s %s %s > /dev/null", inputFileName, tmpFileName, outputFileName);
            system(cmd);
            /* svȒԃf[^̍폜 */
            remove(inputFileName);
            remove(tmpFileName);
        }
        else {
            /* PHASEs */
            sprintf(cmd, "PHASE -n -f1 %s %s >& /dev/null", inputFileName, outputFileName);
            system(cmd);
            /* svȒԃf[^̍폜 */
            remove(inputFileName);
            sprintf(tmpFileName, "%s_freqs", outputFileName);
            remove(tmpFileName);
            sprintf(tmpFileName, "%s_hbg", outputFileName);
            remove(tmpFileName);
            sprintf(tmpFileName, "%s_monitor", outputFileName);
            remove(tmpFileName);
            sprintf(tmpFileName, "%s_pairs", outputFileName);
            remove(tmpFileName);
            sprintf(tmpFileName, "%s_probs", outputFileName);
            remove(tmpFileName);
            sprintf(tmpFileName, "%s_recom", outputFileName);
            remove(tmpFileName);
        }
    }

    return retval;
}

/* tF[WOo͌ʂHapmap`ɕϊ */
int transPhasedDataFotHapmap(InputPhasing *inputPhasing, SnpData *snpData, long blockNum, long *linkSNPNum, long *linkSNPStart)
{
    int retval = 0;
    char tmpFileName[MAX_LEN];
    long i = 0;
    long j = 0;
    long k = 0;
    long jStart = 0;            /* LDubN̍ŏSNPʊi[ϐ */

    char** haplotype = NULL;    /* nv^Cvi[pz */

    FILE *fpIn = NULL;      /* ̓t@C|C^ */
    FILE *fpOut = NULL;     /* o̓t@C|C^ */

    /* o̓t@CI[v */
    retval = OutputFileOpen(&fpOut, inputPhasing->outputFile);
    if (retval != 0){
        goto finalize;
    }
    /* o̓t@C̃wb_ */
    fprintf(fpOut, "rsID\tphys_position\t");
    for (k = 0; k < snpData[1].sampleNum; k++){
        // l̎IDH͂Ƃ̓̓t@C擾悤ɂ
        fprintf(fpOut, "NA%ld_A NA%ld_B\t", k, k);
    }
    fprintf(fpOut, "\n");

    /* LDubNPʂŃ[v */
    jStart = 0;
    for (i = 0; i < blockNum; i++){
        /* ԃf[^̃t@CI[v */
        sprintf(tmpFileName, "%s_output%ld", inputPhasing->outputFile, i);
        retval = InputFileOpen(&fpIn, tmpFileName);
        if (retval != 0){
            goto finalize;
        }

        jStart = linkSNPStart[i];

        /* nv^Cvi[pz̃m */
        haplotype = (char**)mallocChar2Dim(snpData[1].sampleNum*2, linkSNPNum[i]);
        if (NULL == haplotype) { goto finalize; }

        /* ԃf[^̃nv^Cvǂݍ */
        if (inputPhasing->phasingType == 0) {
            /* snphapo͌ʓǂݍ */
            DataReaderSetSnphapData(fpIn, haplotype, linkSNPNum[i], snpData[1].sampleNum);
        }
        else {
            /* PHASEo͌ʓǂݍ */
            DataReaderSetPHASEData(fpIn, haplotype);
        }

        /* tF[WOʃt@Co */
        for (j = 0; j < linkSNPNum[i]; j++){
            fprintf(fpOut, "%s\t%ld\t", snpData[jStart].rsNumber, snpData[jStart].pos);
            jStart++;
            for (k = 0; k < snpData[1].sampleNum; k++){
                fprintf(fpOut, "%c %c\t", haplotype[2*k][j], haplotype[2*k+1][j]);
            }
            fprintf(fpOut, "\n");
        }

        /* ԃf[^̃t@CN[Y */
        FileClose(fpIn);
        fpIn = NULL;
        /* mۂJ */
        freeChar2Dim(haplotype, snpData[1].sampleNum*2);
        haplotype = NULL;
        /* svȒԃf[^̍폜 */
        remove(tmpFileName);
    }

/****************************************************************/
/* I                                                     */
/****************************************************************/

finalize:;
    /* t@CN[Y */
    FileClose(fpIn);
    FileClose(fpOut);
    /* mۂJ */
    freeChar2Dim(haplotype, snpData[1].sampleNum*2);

    return retval;
}
