#include <stdio.h>
#include <malloc.h>
#include <math.h>
// #include "stdafx.h"

#include "snp_Table.h"
#include "snp_Factorial.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"
#include "snp_Random.h"

int TableMain()
{
	int a1 = 0, a2 = 0;  /* case */
	int b1 = 0, b2 = 0;  /* control */
	SnpTable Tbl;
	int **T = NULL;
	int l = 0, u = 0;
	double Sobs = 0.0;
	int v = 0, w = 0;
	int i = 0;
	int **result;
	int *pos = NULL;
    int retval = 0;

	/* ݒ */
	a1 = 66, a2 = 34;  /* case */
	b1 = 90, b2 = 10;  /* control */
	Sobs = 11;

	//T = TableGetTable(Tbl);

    if (FactorialSetFactorial(a1 + a2 + b1 + b2) != 0){
        return 1;
    }

	retval = TableMakeTable4Int(&Tbl, a1, a2, b1, b2);
	l = TableCalcL(Tbl);
	u = TableCalcU(Tbl);
	v = TableCalcV(Tbl, Sobs);
	w = TableCalcW(Tbl, Sobs);

    result = (int**)calloc(2, sizeof(int*));
    if (NULL == result){
        return 1;
    }
	for (i = 0; i < 2; i++) {
		result[i] = (int*)calloc(2, sizeof(int));
        if (NULL == result[i]){
            return 1;
        }
	}

	for (i = l; i <= u; i++) {
		TableNewTable(Tbl, i, result);
		printf("%d\t%.14f", i, TableCalcScore(result));
		if ( (i < v) || (i > w) ) {
			printf("\t%f", TableCalcNu(result, Sobs));
		}
		printf("\n");
		//				showMatrix(result);
	}			

    /* loge[uNA */
    FactorialDeleteFactorial();
    /* \tablẽJ */
    TableFinalTable(&Tbl);

#ifdef DBG
    //test
    printf("%d\n", getMallocCount());
#endif

	return 0;
}


/************************************************************************/
/*	e[u														*/
/*	tbl		O		e[u											*/
/*	Ԃl	O		e[u											*/
/************************************************************************/
int TableInitTable(SnpTable *tbl)
{
	tbl->horizontalSum = NULL;
	tbl->verticalSum = NULL;
//	tbl->fact;
	tbl->table = NULL;

	return 0;
}


/************************************************************************/
/*	e[u쐬ij												*/
/*	tbl			I	e[u											*/
/*	numHori		I	̃f[^									*/
/*	numVert		I	̃f[^									*/
/*	Ԃl		NORMAL_STATUS:		I							*/
/*				ERROR_MEMORY_ALLOC:	̊mۂɎs				*/
/************************************************************************/
int TableCreateTable(SnpTable *tbl, int numHori, int numVert)
{
	int *pos = NULL;
	int retVal = 0;

	TableInitTable(tbl);	/* Tablȅ */

    /* e[ũm */
    tbl->table = (int**)mallocInt2Dim(numHori, numVert);
	if (NULL == tbl->table) {
		retVal = ERROR_MEMORY_ALLOC;
		goto finalize;
	}

	/* yѐ̘a̔z */
	tbl->horizontalSum = (int*)malloc1Dim(sizeof(int), numHori);
	if (NULL == tbl->horizontalSum) {
		retVal = ERROR_MEMORY_ALLOC;
		goto finalize;
	}
	tbl->verticalSum = (int*)malloc1Dim(sizeof(int), numVert);
	if (NULL == tbl->verticalSum) {
		retVal = ERROR_MEMORY_ALLOC;
		goto finalize;
	}

finalize:;
	switch (retVal) {
	case NORMAL_STATUS:
		return retVal;	/* ɂ͂ŏI */
	case ERROR_MEMORY_ALLOC:
		printf("ERROR [TableCreateTable]: Cannot create Table.\n");
		break;
	}

	TableFinalTable(tbl);	/*@G[̃̈@*/

	return retVal;
}


/************************************************************************/
/*	e[uI													*/
/*	tbl		I	e[u												*/
/************************************************************************/
int TableFinalTable(SnpTable *tbl)
{
    if (tbl->table != NULL){
        freeInt2Dim(tbl->table, ROW);
    }
    if (tbl->horizontalSum != NULL){
        free1Dim(tbl->horizontalSum);
    }
    if (tbl->verticalSum != NULL){
        free1Dim(tbl->verticalSum);
    }

	tbl->horizontalSum = NULL;
	tbl->verticalSum = NULL;
//	tbl->fact;
	tbl->table = NULL;

	return 0;
}


/************************************************************************/
/*	S̐li^j̃e[u쐬								*/
/*	tbl		I	e[u												*/
/*	a1		I	a1iGenotype1, Casej									*/
/*	a2		I	a2iGenotype2, Casej									*/
/*	b1		I	b1iGenotype1, Controlj								*/
/*	b2		I	b2iGenotype2, Controlj								*/
/*	Ԃl	0:	폈												*/
/************************************************************************/
int TableMakeTable4Int(SnpTable *tbl, int a1, int a2, int b1, int b2)
{
	int n;

    /* e[ȕ */
    TableInitTable(tbl);
    TableCreateTable(tbl, ROW, COLUMN);


	tbl->table[0][0] = a1;		tbl->table[0][1] = a2;	/* case */
	tbl->table[1][0] = b1;		tbl->table[1][1] = b2;	/* control */

	tbl->horizontalSum[0] = a1 + a2;
	tbl->horizontalSum[1] = b1 + b2;

	tbl->verticalSum[0] = a1 + b1;
	tbl->verticalSum[1] = a2 + b2;

	n = a1 + a2 + b1 + b2;
//	tbl->fact = new Factorial(n);

	return 0;
}



/************************************************************************/
/*	2*2̔zi^j̃e[u쐬								*/
/*	tbl		O	e[u												*/
/*	T		I	e[u̒l											*/
/************************************************************************/
int TableMakeTableIntArray(SnpTable *tbl, int **T)
{
	int a = 0, b = 0, n = 0;
	int a1 = 0, a2 = 0, b1 = 0, b2 = 0;
	int n1 = 0, n2 = 0;

    /* e[ȕ */
    TableInitTable(tbl);
    TableCreateTable(tbl, ROW, COLUMN);

	a1 = T[0][0];		a2 = T[0][1];		a = a1 + a2;/* case */
	b1 = T[1][0];		b2 = T[1][1];		b = b1 + b2;/* control */
	n1 = a1 + b1;		n2 = a2 + b2;		n = n1 + n2;

	tbl->table[0][0] = a1;		tbl->table[0][1] = a2;/* case */
	tbl->table[1][0] = b1;		tbl->table[1][1] = b2;/* control */

    tbl->horizontalSum[0] = a1 + a2;
	tbl->horizontalSum[1] = b1 + b2;

	tbl->verticalSum[0] = a1 + b1;
	tbl->verticalSum[1] = a2 + b2;

    return 0;
}


int **TableGetTable(SnpTable T)
{
	return T.table;
}


/************************************************************************/
/*	V															*/
/*	tbl		I	e[u												*/
/*	a1		I															*/
/*	result	O														*/
/*																		*/
/************************************************************************/
int TableNewCandidate(SnpTable tbl, int a1, int **result)
{
	/*@f[^TCỸ`FbN@*/
	if (a1 < 0) {
		printf("negative value\n"); /* out of bounds */
		return 1;
	}
	if (a1 > tbl.horizontalSum[0]) {
		printf("too large\n");	/* out of bounds */
		return 1;
	}
	if (a1 > tbl.verticalSum[0]) {
		printf("too large\n"); /* out of bounds */
		return 1;
	}

	result[0][0] = a1;
	result[0][1] = tbl.horizontalSum[0] - a1;
	result[1][0] = tbl.verticalSum[0] - a1;
	result[1][1] = tbl.horizontalSum[1] - result[1][0];

	return 0;
}



int TableNewTable(SnpTable tbl, int a1, int **result)
{
	int retVal;

	retVal = TableNewCandidate(tbl, a1, result);

	return retVal;
}



/************************************************************************/
/*	LľvZ															*/
/*	tbl		I	e[u												*/
/*	Ԃl		Ll														*/
/************************************************************************/
int TableCalcL(SnpTable tbl)	/* lower limit */
{	int result = 0;

	result = tbl.horizontalSum[0] - tbl.verticalSum[1];
	if (result < 0) {
		result = 0; 
	}

	return result;
}


/************************************************************************/
/*	UľvZ															*/
/*	tbl		I	e[u												*/
/*	Ԃl		Ul														*/
/************************************************************************/
int TableCalcU(SnpTable tbl)	/* upper limit */
{
	int result = 0;

	result = tbl.horizontalSum[0];
	if (result > tbl.verticalSum[0]) {
		result = tbl.verticalSum[0];
	}

	return result;
}


/************************************************************************/
/*	PearsoñXRǍvZ												*/
/*	T		I		e[ui2x2j										*/
/*	Ԃl			XRA												*/
/************************************************************************/
double TableCalcPearsonScore(int **T)		/* 12) Pearsonscore */
{
	int a1 = 0, a2 = 0, a = 0;
	int b1 = 0, b2 = 0, b = 0;
	int n1 = 0, n2 = 0, n = 0;
	double val = 0;
    double denominator = 0;

	a1 = T[0][0];		a2 = T[0][1];		a = a1 + a2;/* case */
	b1 = T[1][0];		b2 = T[1][1];		b = b1 + b2;/* control */
	n1 = a1 + b1;		n2 = a2 + b2;		n = n1 + n2;

    /* 0̂߁Aꂪ0Ȃ-1Ԃ */
    denominator = (double)a * b * n1 * n2;
    if (denominator == 0){
        return -1;
    }

	val = (double)n * (a1 * b2 - a2 * b1) * (a1 * b2 - a2 * b1);
	val /= denominator;

    return val;
}

/************************************************************************/
/*	v̌vZ																*/
/*	tbl		I	e[u												*/
/*	Sobs	I	e[u												*/
/*	Ԃl		v̒l													*/
/************************************************************************/
int TableCalcV(SnpTable tbl, double Sobs) /* lower boundary of X where S>Sobs */
{
	int a = 0, b = 0, n1 = 0;
	double n = 0.0;
	int result = 0;

	a = tbl.horizontalSum[0];
	b = tbl.horizontalSum[1];
	n1 = tbl.verticalSum[0];
	n = (double)(a + b);

	result = (int)(n1 * a / n - TableRootD(tbl, Sobs) / n);
	if (result < 0) {
		result = 0; 
	}

	return result;
}


/************************************************************************/
/*	tbl		I	e[u												*/
/*	Sobs	I	e[u												*/
/*	Ԃl		Wl														*/
/************************************************************************/
int TableCalcW(SnpTable tbl, double Sobs) /* upper boundary of X where S>Sobs */
{
	int a = 0, b = 0;
	int n1 = 0;
	double n = 0.0;
	int result = 0;

	a = tbl.horizontalSum[0];
	b = tbl.horizontalSum[1];
	n1 = tbl.verticalSum[0];
	n = a + b;

	result = 1 + (int)(n1 * a / n + TableRootD(tbl, Sobs) / n);
	if (result < 0) {
		result = 0; 
	}

	return result;
}


/************************************************************************/
/*	ʒl̃[ǧvZ												*/
/*	tbl		I	e[u												*/
/*	Sobs	I															*/
/*	Ԃl	ʒl̃[g												*/
/************************************************************************/
double TableRootD(SnpTable tbl, double Sobs)
{
	return sqrt(TableDiscriminant(tbl, Sobs));
}


/************************************************************************/
/*	ʒľvZ														*/
/*	tbl		I	e[u												*/
/*	Sobs	I															*/
/*	Ԃl	ʒl														*/
/************************************************************************/
double TableDiscriminant(SnpTable tbl, double Sobs) /* ʎ */
{
	int a = 0, b = 0;
	int n1 = 0, n2 = 0, n = 0;

	a = tbl.horizontalSum[0];
	b = tbl.horizontalSum[1];

	n1 = tbl.verticalSum[0];
	n2 = tbl.verticalSum[1];
	n = a + b;

	return Sobs * a * b * n1 * n2 /(double)n;
}



/************************************************************************/
/*	ʒľvZ														*/
/*	tbl			I	e[u											*/
/************************************************************************/
int TableTwoParts(SnpTable tbl, double Sobs)
{
	if (TableDiscriminant(tbl, Sobs) <= 0) { /* imaginary */
		return FLAG_FALSE;
	}
	if ( (TableCalcV(tbl, Sobs) > TableCalcL(tbl))
			&& (TableCalcW(tbl, Sobs) < TableCalcU(tbl)) ) {
		return FLAG_TRUE;
	}
	return FLAG_FALSE;
}


/************************************************************************/
/*	FstľvZ															*/
/*	T		I	e[u												*/
/*	Ԃl	Fstl														*/
/************************************************************************/
double TableCalcFst(int **T)		/* 12) Pearsonscore */
{
	double a1 = 0.0, a2 = 0.0, a = 0.0;
	double b1 = 0.0, b2 = 0.0, b = 0.0;
	double n1 = 0.0, n2 = 0.0, n = 0.0;
	double p1 = 0.0, p2 = 0.0, p = 0.0;
	double Hs = 0.0, Ht = 0.0;
	double Fst = 0.0;


	a1 = T[0][0];		a2 = T[0][1];		a = a1 + a2;/* case */
	b1 = T[1][0];		b2 = T[1][1];		b = b1 + b2;/* control */
	n1 = a1 + b1;		n2 = a2 + b2;		n = n1 + n2;

	p = a / n;
	p1 = a1 / n1;  /* gene frequency at population 1 */
	p2 = a2 / n2;  /* gene frequency at population 2 */

	Hs = 0.5 * (p1 * (1.0 - p1) + p2 * (1.0 - p2)); /* average heterozygosity */
	Ht = p * (1.0 - p);  /* total heterozygosity */
	Fst = 1.0 - (Hs / Ht); /* Fst */

	return Fst;
}



/************************************************************************/
/*	f[^s̕\													*/
/*	data	I	\s											*/
/*	len1	I															*/
/*	len2	I															*/
/*	Ԃl	Ȃ														*/
/************************************************************************/
void TableShowMatrix(int **data, int len1, int len2)
{
	int i = 0;

	for (i = 0; i < len1; i++){
		TableShowVector(data[i], len2);
	}
	printf("\n");
}



/************************************************************************/
/*	f[^̕\														*/
/*	data	I	\z											*/
/*	len		I															*/
/*	Ԃl	Ȃ														*/
/************************************************************************/
void TableShowVector(int *data, int len)
{
	int h;

	for (h = 0; h < len; h++) {
		printf("%d\t", data[h]);
	}
	printf("\n");
}


/************************************************************************/
/*	mu̒ľvZ														*/
/*	T	I	e[u													*/
/*																		*/
/*																		*/
/*																		*/
/************************************************************************/
double TableCalcMu(int **T)
{
	int a1 = 0, a2 = 0, a = 0;
	int b1 = 0, b2 = 0, b = 0;
	int n1 = 0, n2 = 0, n = 0;
	double logComb1 = 0.0, logComb2 = 0.0;	/* gݍ킹Log */

	a1 = T[0][0];		a2 = T[0][1];		a = a1 + a2;	/* case */
	b1 = T[1][0];		b2 = T[1][1];		b = b1 + b2;	/* control */
	n1 = a1 + b1;		n2 = a2 + b2;		n = n1 + n2;

	logComb1 = FactorialGetLogCombination(n1, a1);

	logComb2 = FactorialGetLogCombination(n2, a2);

	return exp(logComb1 + logComb2);
}




/************************************************************************/
/*															*/
/************************************************************************/
double TableCalcNu(int **T, double Sobs)
{
	double S;

	S = TableCalcScore(T);
	if (S > Sobs) {
		return TableCalcMu(T);
	}

	return 0.0;
}


/************************************************************************/
/*															*/
/************************************************************************/
int TableInCj(double Sobs, int **T, int len1, int len2)
{
	int i = 0, j = 0;
	double S;

	for (i = 0; i < len1; i++) {
		for (j = 0; j < len2; j++) {
			if (T[i][j] < 0) {
				 return FLAG_FALSE; /* out of bounds */
			}
		}
	}
	S = TableCalcScore(T);

	if (S >= Sobs) {
		return FLAG_TRUE;
	}
	return FLAG_FALSE;
}


/************************************************************************/
/*															*/
/************************************************************************/
int TableJudgeCj(double Sobs, int **T, int len1, int len2)
{
	/* if X is out of range return 1 */
	/* if Score(T(X))>=Sobs return 2 */
	/* if X is within range and Score(T(X))<Sobs return 0 */
	int i = 0, j = 0;
    double S = 0;

	for (i = 0; i < len1; i++) {
		for (j = 0; j < len2; j++){
			if (T[i][j] < 0) {
				return OUT_OF_RANGE; /* out of bounds */
			}
		}
	}

	S = TableCalcScore(T);
	if (S >= Sobs) {
		return WITH_IN_RANGE;
	}

	return IN_BETWEEN;
}


/************************************************************************/
/*															*/
/*	T1: 	I													*/
/*	numI:	I												*/
/*	numJ:	I												*/
/*	T2:		I												*/
/*															*/
/*															*/
/************************************************************************/
double TableCalcR(int **T1, int len1, int len2, int **T2)
{
	/* IɈxvZΏ\ƂASYɕύX */
	double logNum = 0.0; /* q */
	double logDen = 0.0; /*  */
	int i = 0, j = 0;
	double logResult = 0.0;
	double retVal = 0.0;

	for (i = 0; i < len1; i++) {
		for(j = 0; j < len2; j++) {
			logNum += FactorialGetLogFactorial(T1[i][j]);
			logDen += FactorialGetLogFactorial(T2[i][j]);
		}
	}
	logResult = logNum - logDen;
	retVal = exp(logResult);

	return retVal;
}

/* 􌻕\̃XRAvZ */
double TableCalcScore(int **T)
{
    double score = 0;
                
    /* XRAvZ */
    switch(iWay){
        case 0: /* PeasonScorevZ */
                score = TableCalcPearsonScore(T);
                break;
        case 1: /* FstvZ */
                score = TableCalcFst(T);
                break;
        default:/* `ĂȂl̏ꍇ */
                score = -1;
                break;
    }

    return score; 
}

/* mulogľvZ */
double TableCalcLogMu(int **T)
{
	int a1 = 0, a2 = 0, a = 0;
	int b1 = 0, b2 = 0, b = 0;
	int n1 = 0, n2 = 0, n = 0;
	double logComb1 = 0.0, logComb2 = 0.0;	/* gݍ킹Log */

	a1 = T[0][0];		a2 = T[0][1];		a = a1 + a2;	/* case */
	b1 = T[1][0];		b2 = T[1][1];		b = b1 + b2;	/* control */
	n1 = a1 + b1;		n2 = a2 + b2;		n = n1 + n2;

	logComb1 = FactorialGetLogCombination(n1, a1);

	logComb2 = FactorialGetLogCombination(n2, a2);

	return logComb1 + logComb2;
}

/* one region */
void TableMarkov1(SnpTable T, double Score, int **table)
{
    int a1 = 0,
        a2 = 0;
    int b1 = 0,
        b2 = 0;
    int newA1 = 0;
    int u = 0;
    int l = 0;
    int i = 0;
    int j = 0;
    int retval = 0;

    double y = 0,
           y2 = 0;

    int **X = NULL;
    int **newX = NULL;

    X = TableGetTable(T);
    a1 = X[0][0];
    a2 = X[0][1];
    b1 = X[1][0];
    b2 = X[1][1];
    
    i = TablePlusMinusOne();
    newA1 = a1 + i;

    u = TableCalcU(T);
    l = TableCalcL(T);

    /* new candidate */
    if ( (newA1 < l) || (newA1 > u) ){
        return; //unchanged
    }
    /* newX̃m */
    newX = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == newX) { goto finalize; }

    retval = TableNewCandidate(T, newA1, newX);

    if (FLAG_TRUE == TableInCj(Score, newX, ROW, COLUMN)){ /* condition 5 */
        if (1 == i){
            y = (b1 * a2) / ( (double) (a1 + 1) * (b2 + 1) );
        }
        if (-1 == i){
            y = (a1 * b2) / ( (double) (b1 + 1) * (a2 + 1) );
        }
        /* mcmc transition */
        if (y >= 1){ /* procedure 6 */
            retval = TableNewTable(T, newA1, table);
        }
        else{
            y2 = myRand();
            if (y >= y2){ /* procedere 7 */
                retval = TableNewTable(T, newA1, table);
            }
        }
    }

finalize:;
    /* mۂJ */
    freeInt2Dim(newX, ROW);
}


/* two regions */
void TableMarkov2(SnpTable T, double Score, int **table)
{
    int a1 = 0,
        a2 = 0;
    int b1 = 0,
        b2 = 0;
    int u = 0;
    int l = 0;
    int i = 0;
    int j = 0;
    int flag = 0;
    int oldA1 = 0,
        newA1 = 0;
    int retval = 0;

    double y = 0,
           y2 = 0;
    double z = 0,
           z2 = 0;

    int **X = NULL;
    int **newX = NULL;
    int **oldA1X = NULL;
    int **newA1X = NULL;

    X = TableGetTable(T);
    a1 = X[0][0];
    a2 = X[0][1];
    b1 = X[1][0];
    b2 = X[1][1];

    i = TablePlusMinusOne();
    newA1 = a1 + i;

    u = TableCalcU(T);
    l = TableCalcL(T);

    if ( (newA1 < l) || (newA1 > u) ){
        return; //unchanged
    }

    /* new candidate */
    /* newX̃m */
    newX = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == newX) { goto finalize; }

    retval = TableNewCandidate(T, a1, newX);
    flag = TableJudgeCj(Score, newX, ROW, COLUMN);

    if (WITH_IN_RANGE == flag){ /* condition 5 */
        if (1 == i){
            y = (b1 * a2) / ( (double) (a1 + 1) * (b2 + 1) );
        }
        if (-1 == i){
            y = (a1 * b2) / ( (double) (b1 + 1) * (a2 + 1) );
        }
        /* mcmc transition */
        if (y >= 1){ /* procedure 6 */
            retval = TableNewTable(T, newA1, table);
        }
        else{
            y2 = myRand();
            if (y >= y2){ /* procedere 7 */
                retval = TableNewTable(T, newA1, table);
            }
        }
    }
    if (IN_BETWEEN == flag){ /* leap to the other island */
        oldA1 = T.table[0][0];
        newA1 = oldA1;

        /* oldA1X̃m */
        oldA1X = (int**)mallocInt2Dim(ROW, COLUMN);
        if (NULL == oldA1X) { goto finalize; }
        /* newA1X̃m */
        newA1X = (int**)mallocInt2Dim(ROW, COLUMN);
        if (NULL == newA1X) { goto finalize; }


        if (1 == i){ /* leap from w to v */
            newA1 = TableCalcW(T, Score);
            retval = TableNewCandidate(T, oldA1, oldA1X);
            retval = TableNewCandidate(T, newA1, newA1X);
            z = TableCalcR(oldA1X, ROW, COLUMN, newA1X);
        }
        if (-1 == i){ /* leap from v to w */
            newA1 = TableCalcV(T, Score);
            retval = TableNewCandidate(T, oldA1, oldA1X);
            retval = TableNewCandidate(T, newA1, newA1X);
            z = TableCalcR(oldA1X, ROW, COLUMN, newA1X);
        }
        
        if (z > 1){
            retval = TableNewTable(T, newA1, table);
        }
        else{
            z2 = myRand();
            if (z >= z2){ /* leap */
                retval = TableNewTable(T, newA1, table);
            }
        }
    }

finalize:;
    /* mۂJ */
    freeInt2Dim(newX, ROW);
    freeInt2Dim(oldA1X, ROW);
    freeInt2Dim(newA1X, ROW);
}

int TablePlusMinusOne()
{
    /* return -1 or 1 with probability 0.5 */
    int result = 0;

    result = (int)(myRand() * 2) * 2 - 1;

    return result;
}
