#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "snp_PrimitiveParallel.h"
#include "mpi.h"

#define NUM_TM   100
double tm[NUM_TM];  /* Ԍvp */

#define TM_START       0
#define TM_B_BCAST     1
#define TM_A_BCAST     2
#define TM_B_CALC      3
#define TM_A_CALC      4
#define TM_B_GATHER    5
#define TM_A_GATHER    6
#define TM_END         7

#define TM_B_READ      8
#define TM_A_READ      9
#define TM_B_WRITE    10
#define TM_A_WRITE    11
#define TM_B_F_BCAST  12
#define TM_A_F_BCAST  13
#define TM_B_F_GATHER 14
#define TM_A_F_GATHER 15

/* vg^Cv錾 */
int Define_MPI_InputStruct(MPI_Datatype *mpi_inputStruct);


int main(int argc, char* argv[])
{
    InputPrimitive inputPrimitive={"", "", "", 0, "", 0, 0, 0};

    int nProc = 0;   /* mۂvZbŤixj */
    int rank = 0;    /* Nԍ */
    int i = 0;

    /* Ԍvpϐ̏ */
    for (i = 0; i < NUM_TM; i++){
        tm[i] = 0.0;
    }

    MPI_Init(&argc, &argv);
    MPI_Comm_size(MPI_COMM_WORLD, &nProc);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    /* Ԍv */
    tm[TM_START] = MPI_Wtime();

    if(argc != 9){
        printf("[usage]main.exe [InputFile1] [InputFile2] [outputFile] [AreaFileType] [BlockAreaFile] [Score] [Repeat] [dataType] \n");
        return 255;
    }
    strcpy(inputPrimitive.inputFile1, argv[1]);
    strcpy(inputPrimitive.inputFile2, argv[2]);
    strcpy(inputPrimitive.outputFile1, argv[3]);
    inputPrimitive.areaFileType = atoi(argv[4]);
    strcpy(inputPrimitive.blockAreaFile, argv[5]);
    inputPrimitive.score = atoi(argv[6]);
    inputPrimitive.repeat = atol(argv[7]);
    inputPrimitive.dataType = atoi(argv[8]);

    if (rank == 0) {
        printf("inputFile1: %s\n", inputPrimitive.inputFile1);
        printf("inputFile2: %s\n", inputPrimitive.inputFile2);
        printf("outputFile1: %s\n", inputPrimitive.outputFile1);
        printf("blockAreaFile: %s\n", inputPrimitive.blockAreaFile);
        printf("score: %d\n", inputPrimitive.score);
        printf("repeat: %ld\n", inputPrimitive.repeat);
        printf("dataType: %d\n", inputPrimitive.dataType);
        printf("nProc: %d\n", nProc);
    }

    /* XRAvZ@̎w */
    iWay = inputPrimitive.score;

    /* ֐ */
    initMyRand();

    /* PrimitivePermutations */
    MainProgramPrimitive(&inputPrimitive, nProc, rank);

    /* Ԍv */
    tm[TM_END] = MPI_Wtime();

    MPI_Finalize();    /* MPII */

    printf("%4d  1 time Init-READ      %lf (sec)\n", rank, tm[TM_B_READ]     - tm[TM_START]);
    printf("%4d  2 time READ           %lf (sec)\n", rank, tm[TM_A_READ]     - tm[TM_B_READ]);
    printf("%4d  3 time READ-FBcast    %lf (sec)\n", rank, tm[TM_B_F_BCAST]  - tm[TM_A_READ]);
    printf("%4d  4 time FBcast         %lf (sec)\n", rank, tm[TM_A_F_BCAST]  - tm[TM_B_F_BCAST]);
    printf("%4d  5 time FBcast-Bcast   %lf (sec)\n", rank, tm[TM_B_BCAST]    - tm[TM_A_F_BCAST]);
    printf("%4d  6 time Bcast          %lf (sec)\n", rank, tm[TM_A_BCAST]    - tm[TM_B_BCAST]);
    printf("%4d  7 time Bcast-Calc     %lf (sec)\n", rank, tm[TM_B_CALC]     - tm[TM_A_BCAST]);
    printf("%4d  8 time Calculation    %lf (sec)\n", rank, tm[TM_A_CALC]     - tm[TM_B_CALC]);
    printf("%4d  9 time Calc-FGather   %lf (sec)\n", rank, tm[TM_B_F_GATHER] - tm[TM_A_CALC]);
    printf("%4d 10 time FGather        %lf (sec)\n", rank, tm[TM_A_F_GATHER] - tm[TM_B_F_GATHER]);
    printf("%4d 11 time FGather-Gather %lf (sec)\n", rank, tm[TM_B_GATHER]   - tm[TM_A_F_GATHER]);
    printf("%4d 12 time Gather         %lf (sec)\n", rank, tm[TM_A_GATHER]   - tm[TM_B_GATHER]);
    printf("%4d 13 time Gather-Write   %lf (sec)\n", rank, tm[TM_B_WRITE]    - tm[TM_A_GATHER]);
    printf("%4d 14 time Write          %lf (sec)\n", rank, tm[TM_A_WRITE]    - tm[TM_B_WRITE]);
    printf("%4d 15 time Write-End      %lf (sec)\n", rank, tm[TM_END]        - tm[TM_A_WRITE]);

    printf("%4d 20 time Init           %lf (sec)\n", rank, tm[TM_B_F_BCAST]  - tm[TM_START]);
    printf("%4d 21 time FBcast         %lf (sec)\n", rank, tm[TM_B_BCAST]    - tm[TM_B_F_BCAST]);
    printf("%4d 22 time Bcast          %lf (sec)\n", rank, tm[TM_B_CALC]     - tm[TM_B_BCAST]);
    printf("%4d 23 time Calculation    %lf (sec)\n", rank, tm[TM_A_CALC]     - tm[TM_B_CALC]);
    printf("%4d 24 time Gather         %lf (sec)\n", rank, tm[TM_A_GATHER]   - tm[TM_A_CALC]);
    printf("%4d 25 time End            %lf (sec)\n", rank, tm[TM_END]        - tm[TM_A_GATHER]);

    printf("%4d 30 time Calculation    %lf (sec)\n", rank, tm[TM_A_CALC]     - tm[TM_B_CALC]);
    printf("%4d 31 time F_Bcast-Gather %lf (sec)\n", rank, tm[TM_A_GATHER]   - tm[TM_B_F_BCAST]);
    printf("%4d 32 time A_Read-B_Write %lf (sec)\n", rank, tm[TM_A_WRITE]    - tm[TM_B_READ]);
    printf("%4d 33 time Total          %lf (sec)\n", rank, tm[TM_END]        - tm[TM_START]);

    return 0;

}


/* PrimitivePermutations */
void MainProgramPrimitive(InputPrimitive *inputPrimitive, int nProc, int rank)
{
    int retval = 0;
    int flag = 0;
    long i = 0;
	long j = 0;
    long k = 0;
    long fileLine1 = 0; /* ̓t@C̃C */
    long fileLine2 = 0; /* ̓t@C̃C */
    long areaFileLine = 0; /* haplotypeubN̈wt@C̃C */
    long a = 0;         /* number of haplotype copies (=sequences) in case */
    long b = 0;         /* number of haplotype copies (=sequences) in control */
    long n = 0;
    long dataNum;       /* caseAcontrolf[^̑SNP */
    long jStart = 0;    /* haplotypeubN̍ŏSNP */
    long jEnd = 0;      /* haplotypeubN̍ŌSNP */
    long blockNum = 0;  /* haplotypeubN */
    long repeat = 0;
    long startPos = 0;
    long endPos = 0;
    long blockPartNum = 0;
    long blockPartStart = 0;
    int numAllOutput = 0;
    int numOutput = 0;
    int outDataOffset = 0;
    int numPartOutput = 0;
    double S = 0;

    int **T = NULL;                 /* 􌻕\ */
    int *populationType = NULL;
    long *blockArea = NULL;         /* ehaplotypeubN̈i[ */
    long *linkSNPNum = NULL;        /* ehaplotypeubNSNP */
    long *linkSNPStart = NULL;      /* ehaplotypeubN̍ŏSNP */
    long *maxScoreIndex = NULL;     /* ehaplotypeubÑXRAől̍ */
    long *maxScoreIndexAll = NULL;  /* eHaplotypeubÑXRAől̍ GathervMp */
    long *count = NULL;             /* ehaplotypeubÑXRAől𒴂XRȀo */
    long *countAll = NULL;          /* ehaplotypeubÑXRAől𒴂XRȀo GathervMp */
    int *numOutputs = NULL;
    int *outDataOffsets = NULL;
    double *Sobs = NULL;            /* ehaplotypeubÑXRAől */
    double *SobsAll = NULL;         /* eHaplotypeubÑXRAől GathervMp */

    FILE *fpCase = NULL;            /* ́icasejt@C|C^ */
    FILE *fpCntl = NULL;            /* ́icontroljt@C|C^ */
    FILE *fpOut = NULL;             /* o̓t@C|C^ */
    FILE *fpArea = NULL;            /* haplotypeubN̈wt@C|C^ */

    char *caseData = NULL;          /* Tvf[^icaseji[p */
    char *controlData = NULL;       /* Tvf[^icontrolji[p */

    SnpData *snpTmpData1 = NULL;
    SnpData *snpTmpData2 = NULL;
    SnpData *snpData1 = NULL;
    SnpData *snpData2 = NULL;

    /* MPIp\̐ݒ */
    MPI_Datatype MPI_INPUT_STRUCT;

    repeat = inputPrimitive->repeat;

/****************************************************************/
/* rank0œ̓f[^ǂݍ                                    */
/****************************************************************/

    /* Ԍv */
    tm[TM_B_READ] = MPI_Wtime();

    if (rank == 0){
        /* t@CI[v */
        retval = InputFileOpen(&fpCase, inputPrimitive->inputFile1);
        if (retval != 0){
            goto finalize;
        }
        retval = InputFileOpen(&fpCntl, inputPrimitive->inputFile2);
        if (retval != 0){
            goto finalize;
        }
        retval = OutputFileOpen(&fpOut, inputPrimitive->outputFile1);
        if (retval != 0){
            goto finalize;
        }
        retval = InputFileOpen(&fpArea, inputPrimitive->blockAreaFile);
        if (retval != 0){
            goto finalize;
        }
 
        /* ̓t@C̃C擾 */
        fileLine1 = DataReaderCountFileLine(fpCase);
        fileLine2 = DataReaderCountFileLine(fpCntl);

        /* t@C|C^擪ɖ߂ */
        fseek(fpCase, 0L, SEEK_SET);
        fseek(fpCntl, 0L, SEEK_SET);

        /* f[^ꎞi[p\̂̃m */
        snpTmpData1 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine1);
        if (NULL == snpTmpData1){ goto finalize; }
        snpTmpData2 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine2);
        if (NULL == snpTmpData2){ goto finalize; }

        /* f[^t@Cǂݍݍ\̂Ɏ߂ */
        DataReaderSetAllData(fpCase, snpTmpData1, fileLine1, inputPrimitive->dataType);
        DataReaderSetAllData(fpCntl, snpTmpData2, fileLine2, inputPrimitive->dataType);

        /* ̓f[^̐`FbNĕ񉻗p̓̓f[^쐬 */
        /* MPI_Bcast̉񐔂炷߂ɃTvf[^͕ʔzicaseData, controlDatajŕێ */
        dataNum = DataReaderMakeParallelData(snpTmpData1, snpTmpData2, fileLine1, fileLine2, &snpData1, &snpData2, &caseData, &controlData);

        /* gpȂz̃J */
        /* \SnpDataõJ */
        DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
        DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
        snpTmpData1 = NULL;
        snpTmpData2 = NULL;

        /* haplotypeubN̈wt@C̃C擾 */
        areaFileLine = DataReaderCountFileLine(fpArea);
        /* haplotypeubN̈i[pz̃m */
        blockArea = (long*)malloc1Dim(sizeof(long), areaFileLine);
        if (NULL == blockArea){ goto finalize; }
        /* t@C|C^擪ɖ߂ */
        fseek(fpArea, 0L, SEEK_SET);
        /* haplotypeubN̈zɎ߂ */
        DataReaderSetHaplotypeBlockArea(fpArea, blockArea);
        /* haplotypeubN */
        if (inputPrimitive->areaFileType == 0){
            blockNum = areaFileLine - 1;
        }
        else {
            /* haplotypeubŇvZ */
            if (blockArea[0] > dataNum){
                blockNum = 1;
                blockArea[1] = dataNum; /* linkSNPNum̒lf[^ɂȂ */
            }
            else{
                blockNum = (dataNum - (blockArea[0] - blockArea[1]) ) / blockArea[1];
            }
        }
    }

    /* Ԍv */
    tm[TM_A_READ] = MPI_Wtime();

/****************************************************************/
/* rank0œ̓f[^ǂݍ                                    */
/****************************************************************/

    /* Ԍv */
    tm[TM_B_F_BCAST] = MPI_Wtime();

    /* Sf[^ƃubN̑M */
    MPI_Bcast(&dataNum, 1, MPI_LONG, 0, MPI_COMM_WORLD);
    MPI_Bcast(&blockNum, 1, MPI_LONG, 0, MPI_COMM_WORLD);
    MPI_Bcast(&areaFileLine, 1, MPI_LONG, 0, MPI_COMM_WORLD);

    /* Ԍv */
    tm[TM_A_F_BCAST] = MPI_Wtime();

    if (nProc > blockNum) {
        /* rank0̂ݎs */
        if (rank == 0) {
            fprintf(stderr, "vZbT(%d)f[^ubN(%ld)ݒ肳Ă܂.\n", nProc, blockNum);
        }
        MPI_Abort(MPI_COMM_WORLD, 1);
        goto finalize;
    }
    if (nProc > dataNum) {
        /* rank0̂ݎs */
        if (rank == 0) {
            fprintf(stderr, "vZbT(%d)f[^(%ld)ݒ肳Ă܂.\n", nProc, dataNum);
        }
        MPI_Abort(MPI_COMM_WORLD, 1);
        goto finalize;
    }

    /* N0ȊO̓̓f[^̃m */
    if (rank != 0) {
        /* snpData1icasej̃m */
        snpData1 = (SnpData *)malloc1Dim(sizeof(SnpData), dataNum);
        if (snpData1 == NULL) {
            fprintf(stderr, "rank:%d mۂł܂ł.\n", rank);
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
        /* snpData1icontrolj̃m */
        snpData2 = (SnpData *)malloc1Dim(sizeof(SnpData), dataNum);
        if (snpData2 == NULL) {
            fprintf(stderr, "rank:%d mۂł܂ł.\n", rank);
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
        /* haplotypeubN̈̃m */
        blockArea = (long*)malloc1Dim(sizeof(long), areaFileLine);
        if (blockArea == NULL) {
            fprintf(stderr, "rank:%d mۂł܂ł.\n", rank);
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
    }

    /* MPIp^̒` */
    Define_MPI_InputStruct(&MPI_INPUT_STRUCT);

    /* Ԍv */
    tm[TM_B_BCAST] = MPI_Wtime();

    /* ̓f[^(\)̃u[hLXg */
    MPI_Bcast(snpData1, dataNum, MPI_INPUT_STRUCT, 0, MPI_COMM_WORLD);
    MPI_Bcast(snpData2, dataNum, MPI_INPUT_STRUCT, 0, MPI_COMM_WORLD);
    MPI_Bcast(blockArea, areaFileLine, MPI_LONG, 0, MPI_COMM_WORLD);

    /* ̓f[^̃Tv擾 */
    a = snpData1[0].dataNum;
    b = snpData2[0].dataNum;
    n = a + b;

    /* N0ȊO̓̓f[^̃m */
    if (rank != 0) {
        /* Tvf[^icaseji[p̃m */
        caseData = (char *)malloc1Dim(sizeof(char), dataNum * a);
        if (caseData == NULL) {
            fprintf(stderr, "rank:%d mۂł܂ł.\n", rank);
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
        /* Tvf[^icontrolji[p̃m */
        controlData = (char *)malloc1Dim(sizeof(char), dataNum * b);
        if (controlData == NULL) {
            fprintf(stderr, "rank:%d mۂł܂ł.\n", rank);
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
    }

    /* ̓f[^(f[^)̃u[hLXg */
    MPI_Bcast(caseData, dataNum * a, MPI_CHAR, 0, MPI_COMM_WORLD);
    MPI_Bcast(controlData, dataNum * b, MPI_CHAR, 0, MPI_COMM_WORLD);

    /* Ԍv */
    tm[TM_A_BCAST] = MPI_Wtime();

    /* \SnpDataɃTvf[^Rs[ */
    DataReaderDataCopyToSnpData(snpData1, caseData, dataNum, a);
    DataReaderDataCopyToSnpData(snpData2, controlData, dataNum, b);

/****************************************************************/
/* m                                                   */
/****************************************************************/

    /* vZbTƂ̃f[^vZ */
    blockPartNum = blockNum / nProc;
    if (rank < blockNum % nProc) {
        blockPartNum++;
    }
    /* evZbTɂf[^̃ItZbgľvZ */
    if (rank < blockNum % nProc) {
        blockPartStart = blockPartNum * rank;
    }
    else{
        blockPartStart = (blockPartNum + 1) * (blockNum % nProc)
                       + blockPartNum * (rank - blockNum % nProc);
    }

    /* ehaplotypeubN̈SNPi[pz̃m */
    linkSNPNum = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPNum){ goto finalize; }
    /* ehaplotypeubN̈̍ŏSNPʊi[pz̃m */
    linkSNPStart = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPStart){ goto finalize; }

    /* ehaplotypeubN̈ɊYSNPf[^ */
    if (inputPrimitive->areaFileType == 0){
        for (i = 0; i < blockNum; i++){ /* Ä̏dꍇl */
            startPos = blockArea[i];
            endPos = blockArea[i+1];
            flag = 0;
            /* ̓f[^̓|WVŃ\[gĂƉ */
            for (j = 0; j < dataNum; j++){
                if (startPos <= snpData1[j].pos){
                    if (snpData1[j].pos < endPos){
                        /* ̈SNPJEg */
                        linkSNPNum[i]++;
                        /* ̈̍ŏSNPʂێ */
                        if (0 == flag ){
                            linkSNPStart[i] = j;
                            flag = 1;
                        }
                    }
                    /* ȍ~ÄɊYf[^͏oȂ̂Ŏ̃ubN𒲂ׂ */
                    else {
                        break;
                    }
                }
            }
        }
    }
    else {
        for (i = 0; i < blockNum; i++){
            linkSNPNum[i] = blockArea[0];
            linkSNPStart[i] = i * blockArea[1];
        }
    }

    /* 􌻕\T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }
    /* populationTypẽm */
    populationType = (int*)malloc1Dim(sizeof(int), a + b);
    if (NULL == populationType) { goto finalize; }
    /* HaplotypeubÑXRAől̍ʂ̃m */
    maxScoreIndex = (long*)malloc1Dim(sizeof(long), blockPartNum);
    if (NULL == maxScoreIndex) { goto finalize; }
    /* HaplotypeubÑXRAől̃m */
    Sobs = (double*)malloc1Dim(sizeof(double), blockPartNum);
    if (NULL == Sobs) { goto finalize; }
    /* HaplotypeubÑXRAől𒴂XRȀo񐔂̃m */
    count = (long*)malloc1Dim(sizeof(long), blockPartNum);
    if (NULL == count) { goto finalize; }


/****************************************************************/
/* 菈                                                     */
/****************************************************************/

    /* Ԍv */
    tm[TM_B_CALC] = MPI_Wtime();

    /* haplotypeubNPʂŃ[v */
    jStart = 0;
    for (i = 0, k = blockPartStart; i < blockPartNum; i++, k++){
        jStart = linkSNPStart[k];
        jEnd = jStart + linkSNPNum[k];
        /* ehaplotypeubNŃ[v */
        for (j = jStart; j < jEnd; j++){
            /* ϑl􌻕\쐬 */
            DataReaderPopulationType(&snpData1[j], &snpData2[j], populationType);
            DataReaderMakeTableDi(&snpData1[j], &snpData2[j], populationType, T);
            /* XRAvZ@XRAvZ0ɂȂĂ܂ꍇ-1Ԃ */
            S = TableCalcScore(T);
            /* őXRA肷 */
            if (S > Sobs[i]){
                Sobs[i] = S;
                maxScoreIndex[i] = j;
            }
        }

        /* PrimitivePermutations */
        if (Sobs[i] > 0.0) {
            count[i] = PrimitiveExecute(snpData1, snpData2, Sobs[i], a, b, jStart, jEnd, repeat);
        }
    }

    /* Ԍv */
    tm[TM_A_CALC] = MPI_Wtime();

    if (rank == 0) {
        numOutputs = (int *)malloc1Dim(sizeof(int), nProc);
        if (numOutputs == NULL) {
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
        outDataOffsets = (int *)malloc1Dim(sizeof(int), nProc);
        if (outDataOffsets == NULL) {
            MPI_Abort(MPI_COMM_WORLD, 1);
            goto finalize;
        }
    }

    /* Ԍv */
    tm[TM_B_F_GATHER] = MPI_Wtime();

    numOutput = blockPartNum;
    outDataOffset = blockPartStart;

    /* eNvZo͒ľ */
    MPI_Gather(&numOutput, 1, MPI_INT, numOutputs, 1, MPI_INT, 0, MPI_COMM_WORLD);
    MPI_Gather(&outDataOffset, 1, MPI_INT, outDataOffsets, 1, MPI_INT, 0, MPI_COMM_WORLD);

    /* Ԍv */
    tm[TM_A_F_GATHER] = MPI_Wtime();

    if (rank == 0) {
        /* o͗pf[^i[\̔z̃m */
        SobsAll = (double *)malloc1Dim(sizeof(double), blockNum);
        maxScoreIndexAll = (long *)malloc1Dim(sizeof(long), blockNum);
        countAll = (long *)malloc1Dim(sizeof(long), blockNum);
    }

    /* Ԍv */
    tm[TM_B_GATHER] = MPI_Wtime();

    numPartOutput = 0;
    for (i = 0, k = blockPartStart; i < blockPartNum; i++, k++) {
        numPartOutput += linkSNPNum[k];
    }

    /* evZbT̃f[^̎W */
    MPI_Gatherv(Sobs, numOutput, MPI_DOUBLE, SobsAll,
               numOutputs, outDataOffsets, MPI_DOUBLE, 0, MPI_COMM_WORLD);
    MPI_Gatherv(maxScoreIndex, numOutput, MPI_LONG, maxScoreIndexAll,
               numOutputs, outDataOffsets, MPI_LONG, 0, MPI_COMM_WORLD);
    MPI_Gatherv(count, numOutput, MPI_LONG, countAll,
               numOutputs, outDataOffsets, MPI_LONG, 0, MPI_COMM_WORLD);

    /* Ԍv */
    tm[TM_A_GATHER] = MPI_Wtime();


/****************************************************************/
/* 茋ʏo                                                 */
/****************************************************************/

    /* Ԍv */
    tm[TM_B_WRITE] = MPI_Wtime();
    
    if (rank == 0) {
        fprintf(fpOut, "CaseData    = %s\n", inputPrimitive->inputFile1);
        fprintf(fpOut, "ControlData = %s\n", inputPrimitive->inputFile2);
        fprintf(fpOut, "Repeat      = %ld\n", inputPrimitive->repeat);
        fprintf(fpOut, "BlockArea\tSNPNum\trsNumber\tPosition\tScore\tP\n"); 
        if (inputPrimitive->areaFileType == 0){
            for (i = 0; i < blockNum; i++){
                if (SobsAll[i] != 0){
                    fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.3e\t%.3e\n", 
                            blockArea[i],
                            blockArea[i+1],
                            linkSNPNum[i],
                            snpData1[ maxScoreIndexAll[i] ].rsNumber,
                            snpData1[ maxScoreIndexAll[i] ].pos,
                            SobsAll[i],
                            (double)countAll[i] / repeat);
                }
                else {
                    fprintf(fpOut, "%ld-%ld\t%ld\tNoData\n", 
                            blockArea[i],
                            blockArea[i+1],
                            linkSNPNum[i]);
                }
            }
        }
        else {
            for (i = 0; i < blockNum; i++){
                if (SobsAll[i] != 0){
                    fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.3e\t%.3e\n", 
                            snpData1[ linkSNPStart[i] ].pos,
                            snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                            linkSNPNum[i],
                            snpData1[ maxScoreIndexAll[i] ].rsNumber,
                            snpData1[ maxScoreIndexAll[i] ].pos,
                            SobsAll[i],
                            (double)countAll[i] / repeat);
                }
                else {
                    fprintf(fpOut, "%ld-%ld\t%ld\tNoData\n", 
                            snpData1[ linkSNPStart[i] ].pos,
                            snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                            linkSNPNum[i]);
                }
            }
        }
    }

    /* Ԍv */
    tm[TM_A_WRITE] = MPI_Wtime();

/****************************************************************/
/* I                                                     */
/****************************************************************/

finalize:;
    /* t@CN[Y */
    FileClose(fpCase);
    FileClose(fpCntl);
    FileClose(fpOut);
    FileClose(fpArea);
    /* mۂJ */
    freeInt2Dim(T, ROW);
    free1Dim(populationType);
    free1Dim(blockArea);
    free1Dim(linkSNPNum);
    free1Dim(linkSNPStart);
    free1Dim(maxScoreIndex);
    free1Dim(maxScoreIndexAll);
    free1Dim(count);
    free1Dim(countAll);
    free1Dim(numOutputs);
    free1Dim(outDataOffsets);
    free1Dim(Sobs);
    free1Dim(SobsAll);
    DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
    DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
    free1Dim(caseData);
    free1Dim(controlData);
    free1Dim(snpData1);
    free1Dim(snpData2);

    return;
}

/* PrimitivePermutations */
long PrimitiveExecute(SnpData *snpData1, SnpData *snpData2, double Sobs, long a, long b, long jStart, long jEnd, long repeat)
{
    int retval = 0;
    long i = 0;
    long j = 0;
    long n = 0;
    long count = 0;

    double S = 0;
    double Sperm = 0;

    int **Tperm = NULL;             /* 􌻕\ */
    int *omega = NULL;
    int *di = NULL;

    n = a + b;

    /* 􌻕\Tperm̃m */
    Tperm = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == Tperm){ goto finalize; }
    /* omegãm */
    omega = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == omega) { goto finalize; }
    /* dĩm */
    di = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == di) { goto finalize; }

    /* permutation */
    for (i = 0; i < repeat; i++){
        Sperm = 0;
        /* ԂVbt */
        retval = PermutationCalcOmega(n, omega);
        if (retval != 0){
            printf("can not create omega\n");
            return -1;
        }
        /* divZ */
        retval =  PermutationCalcDi(n, a, omega, di);
        if (retval != 0){
            printf("can not create di\n");
            return -1;
        }
        /* haplotypeubN̊eSNPvZ */
        for (j = jStart; j < jEnd; j++){
            /* ϑl􌻕\쐬 */
            DataReaderMakeTableDi(&snpData1[j], &snpData2[j], di, Tperm);
            /* XRAvZ@XRAvZ0ɂȂĂ܂ꍇ-1Ԃ */
            S = TableCalcScore(Tperm);
            /* őXRA肷 */
            if (S > Sperm){
                Sperm = S;
            }
        }
        if (Sperm >= Sobs){
            count++;
        }
    }

finalize:;
    /* mۂJ */
    free1Dim(omega);
    free1Dim(di);
    freeInt2Dim(Tperm, ROW);

    return count;
}

/**********************************************************************/
/* ̓f[^MPIɑΉ^̒`                                  */
/* mpi_InputStruct  O   MPIΉ̌^                                   */
/* ԂlF 0: I                                               */
/**********************************************************************/
int Define_MPI_InputStruct(MPI_Datatype *mpi_inputStruct)
{
    int i = 0;

/* MPI֌W */
#define MAX_BLOCK_NUM 10    /* MPIp\̂쐬Ƃ̌^̃ubN */

    int blockcount[MAX_BLOCK_NUM];
    MPI_Aint address[MAX_BLOCK_NUM];
    MPI_Datatype type[MAX_BLOCK_NUM];

    SnpData sti;  // ƂȂ^i\́j

    /* MPIp̍\̂p[^̏ */
    for (i = 0; i < MAX_BLOCK_NUM; i++) {
        blockcount[i] = 0;
        address[i] = (MPI_Aint)NULL;
        type[i] = MPI_INT;
    }

    /* ̓f[^pMPIp̍\̒` */
    blockcount[0] = RS_NUM_LEN;
    blockcount[1] = SNP_NUM;
    blockcount[2] = CHROM_LEN;
    blockcount[3] = 1;
    blockcount[4] = 3 + SNP_COUNT;
    MPI_Address(sti.rsNumber, &address[0]);
    MPI_Address(sti.SNPalleles, &address[1]);
    MPI_Address(sti.chrom, &address[2]);
    MPI_Address(&sti.pos, &address[3]);
    MPI_Address(&sti.allelesNum, &address[4]);
    for (i = 4; i >= 0; i--) {
        address[i] -= address[0];
    }
    /* ^w */
    type[0] = MPI_CHAR;
    type[1] = MPI_CHAR;
    type[2] = MPI_CHAR;
    type[3] = MPI_LONG;
    type[4] = MPI_INT;
    MPI_Type_struct(5, blockcount, address, type, mpi_inputStruct);
    MPI_Type_commit(mpi_inputStruct);

#undef MAX_BLOCK_NUM

	return 0;
}
