package io;
import parameters.parameters;
import java.io.*;
import java.util.Vector;

public class SequenceLoad {

	public static String[][] sequences(parameters param) throws Exception{
		int size = param.fileName.length; // number of files
		char type = 'f'; // fasta format

	    // data input
		String[][] raw = null;
		Vector<String[][]> resultV = new Vector<String[][]>();
		for(int i=0;i<size;i++){
			raw=null; // not set;
			type = type(param,i);
			try{
				String[] tmpdata;
				tmpdata = fileload.loadLine0(param.fileName[i]);
				switch(type){
					case 'm': raw = megaFormat.   translate(tmpdata) ; break;
					case 'n': raw = nexFormat.    translate(tmpdata) ; break;
					case 'p': raw = phylipFormat. translate(tmpdata) ; break;
					case 'c': raw = clustalFormat.translate(tmpdata) ; break;
					case 'o': param.OTUName = tmpdata;  break; // OTU name;
					default:  raw = fastaFormat.  translate(tmpdata) ;
				}
			}catch(Exception e){
				throw new FileNotFoundException(e.getMessage()+" Unable to read "+param.fileName[i]);
			}
			if(raw!=null){
				resultV.add( raw ); // put sequence 
			}
		}			
		// if not set set OTU names by using the first data set
		if(param.OTUName==null) param.OTUName = resultV.elementAt(0)[0];
		int loci = resultV.size();
		param.loci=loci; // number of loci
		if(loci==0) throw new FileNotFoundException("No data");
		String[][] result = orderBySpeciesName(param.OTUName,resultV);
		return result;
	}
	
	public static String[][] bootStrap(String[][] org, parameters params){
		if(params.bootStrap.equals("gene")){
			return GeneBootStrap(org);
		}
		return SiteBootStrap(org);
	}

    public static String[][] SiteBootStrap(String[][] org){  // randomized data
    	String[][] result=new String[org.length][];
    	for(int i=0;i<org.length;i++){
    		result[i] = bootStrap(org[i]);
    	}
    	return result;
    }
	
    public static String[][] GeneBootStrap(String[][] org){  // randomized data
        int size   = org.length;
        int[] strap = new int[size];
        for(int i=0;i<size;i++){
            strap[i] = (int) Math.round(Math.random()*(size-1));
        };
        String[][] result = new String[size][];// result;
        for(int i=0;i<size;i++){
           result[i]= org[strap[i]];//randomized gene
        }
        return result;
    }

    public static String[] bootStrap(String[] org){  // randomized data
        int seqlen = org[0].length();
        int size   = org.length;
        int[] strap = new int[seqlen];
        for(int i=0;i<seqlen;i++){
            strap[i] = (int) Math.round(Math.random()*(seqlen-1));
        };
        String[] result = new String[size];// result;
        for(int j=0;j<size;j++){
            StringBuffer booted = new StringBuffer();
            for(int i=0;i<seqlen;i++){
                booted.append( org[j].charAt(strap[i]) );//randomized chars
            }
            result[j] = booted.toString();
        }
        return result;
    }

    public static String[][] orderBySpeciesName(String[] spList, Vector<String[][]> raw){
    	int size = raw.size();
    	String[][] result = new String[size][];
    	for(int i=0;i<size;i++){
    		result[i] = orderBySpeciesName(spList,raw.elementAt(i));
    	}
    	return result;
    }

    public static String[] orderBySpeciesName(String[] spList, String[][] data){
    	// ̖ÕXgspList̏Ԃœǂݍłf[^낦B
    	// ̖ÕXgɏoĂȂz͖
    	int size = spList.length;
    	String[] result = new String[size];
    	for(int i=0;i<size;i++){
    		String name = spList[i];// species name
			boolean found=false;
			//Vectorf[^o
    		for(int j=0;j<data[0].length;j++){
    			if( data[0][j].indexOf(name)>=0 ){ //TĂ閼O
    				result[i]=data[1][j];
    				found = true;
    			}
    			if(found) break;
    		}
        	// f[^̕ɓĂȂꍇBƂ肠zȂ
    		if( found!=true ){// not found;
    			result[i]="";
    		}
   			result[i]=fill(result[i],result[0].length()); // ĂȂꍇ
    	}
    	return result;
    }
    
    static String fill(String org, int len){
    	StringBuffer result = new StringBuffer(org);
    	while(result.length()<len){
    		result.append("-");
    	}
    	return result.toString();
    }
    
    public static void output(String[][] data,parameters param){
    	String[][] tmp = new String[2][];
    	//O
    	tmp[0]=param.OTUName;
    	//ziSconcatenate)
    	int numberOfOTUs  = data[0].length;
    	int numberOfGenes = data.length;
    	tmp[1] = new String[numberOfOTUs];
    	for(int i=0;i<numberOfOTUs;i++){ // i for OTU
    		StringBuffer sb = new StringBuffer();
        	for(int j=0;j<numberOfGenes;j++){ // j for Genes
        		sb.append(data[j][i]);
        	}
        	tmp[1][i]=sb.toString();
    	}
    	fastaFormat.output(tmp);
    }
    
    public static char type(parameters param, int i){
    	char type = 'f';
		if(param.fileType[i].equals("fasta"))  type = 'f'; 
		if(param.fileType[i].equals("f"))      type = 'f'; 
		if(param.fileType[i].equals("mega"))   type = 'm'; 
		if(param.fileType[i].equals("m"))      type = 'm'; 
		if(param.fileType[i].equals("MEGA"))   type = 'm'; 
		if(param.fileType[i].equals("M"))      type = 'm'; 
		if(param.fileType[i].equals("nexus"))  type = 'n';
		if(param.fileType[i].equals("nex"))    type = 'n'; 
		if(param.fileType[i].equals("n"))      type = 'n';
		if(param.fileType[i].equals("NEXUS"))  type = 'n';
		if(param.fileType[i].equals("NEX"))    type = 'n';
		if(param.fileType[i].equals("N"))      type = 'n';
		if(param.fileType[i].equals("phylip")) type = 'p';
		if(param.fileType[i].equals("p"))      type = 'p';
		if(param.fileType[i].equals("PHYLIP")) type = 'p';
		if(param.fileType[i].equals("P"))      type = 'p';
		if(param.fileType[i].equals("aln"))    type = 'c';
		if(param.fileType[i].equals("clustal"))type = 'c';
		if(param.fileType[i].equals("CLUSTAL"))type = 'c';
		if(param.fileType[i].equals("c"))      type = 'c';
		if(param.fileType[i].equals("C"))      type = 'c';
		if(param.fileType[i].equals("name"))   type = 'o';
		if(param.fileType[i].equals("n"))      type = 'o';
		if(param.fileType[i].equals("N"))      type = 'o';
		if(param.fileType[i].equals("OTU"))    type = 'o';
		if(param.fileType[i].equals("o"))      type = 'o';
		if(param.fileType[i].equals("O"))      type = 'o';
		return type;
	}
}

