/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import test.FindMaximalSegment;

public class RepeatFilter {
    static double[][] matrix = new double[][]{{1.0, -1.0, -1.0, -1.0, -1.0}, {-1.0, 1.0, -1.0, -1.0, -1.0}, {-1.0, -1.0, 1.0, -1.0, -1.0}, {-1.0, -1.0, -1.0, 1.0, -1.0}, {-1.0, -1.0, -1.0, -1.0, -1.0}};

    public static void main(String[] argv) throws FileNotFoundException, IOException {
        FileReader in0 = new FileReader(argv[0]);
        int threshold = new Integer(argv[1]);
        BufferedReader d0 = new BufferedReader(in0);
        String title1 = "";
        String data = "";
        String title2 = "";
        String quality = "";
        int position = 0;
        try {
            int count = 0;
            while (true) {
                String str;
                if ((str = d0.readLine()) == null) {
                    throw new EOFException();
                }
                if (str.length() == 0) continue;
                if (str.charAt(0) == '@') {
                    count = 0;
                }
                if (++count == 1) {
                    title1 = str;
                }
                if (count == 2) {
                    data = str;
                }
                if (count == 3) {
                    title2 = str;
                }
                if (count != 4) continue;
                quality = str;
                count = 0;
                if (RepeatFilter.containsRepeat(title1, data.toString(), position, threshold)) continue;
                System.out.println(title1);
                System.out.println(data);
                System.out.println(title2);
                System.out.println(quality);
            }
        }
        catch (EOFException e) {
            ((Reader)in0).close();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        d0.close();
        ((Reader)in0).close();
    }

    public static boolean containsRepeat(String title, String data, int start, int threshold) {
        int[] enumSequence = RepeatFilter.DNA2integer(data);
        boolean result = false;
        int unitLen = 1;
        while (unitLen <= 100) {
            double[] score = RepeatFilter.score(matrix, enumSequence, unitLen);
            double[][] areas = FindMaximalSegment.areas(score, threshold);
            int num = areas.length;
            int j = 0;
            while (j < num) {
                if (areas[j][2] > FindMaximalSegment.threshold) {
                    result = true;
                    int i = (int)areas[j][0];
                    while ((double)i <= areas[j][1]) {
                        enumSequence[i] = 4;
                        ++i;
                    }
                }
                ++j;
            }
            ++unitLen;
        }
        return result;
    }

    public static int[] DNA2integer(String data) {
        int len = data.length();
        int[] result = new int[len];
        int i = 0;
        while (i < len) {
            char c = data.charAt(i);
            switch (c) {
                case 'T': {
                    result[i] = 0;
                    break;
                }
                case 't': {
                    result[i] = 0;
                    break;
                }
                case 'U': {
                    result[i] = 0;
                    break;
                }
                case 'u': {
                    result[i] = 0;
                    break;
                }
                case 'C': {
                    result[i] = 1;
                    break;
                }
                case 'c': {
                    result[i] = 1;
                    break;
                }
                case 'A': {
                    result[i] = 2;
                    break;
                }
                case 'a': {
                    result[i] = 2;
                    break;
                }
                case 'G': {
                    result[i] = 3;
                    break;
                }
                case 'g': {
                    result[i] = 3;
                    break;
                }
                default: {
                    result[i] = 4;
                }
            }
            ++i;
        }
        return result;
    }

    public static double[] score(double[][] matrix, int[] data, int lag) {
        int len = data.length;
        double[] result = new double[len];
        int i = 0;
        while (i < len - lag) {
            result[i] = matrix[data[i]][data[i + lag]];
            ++i;
        }
        return result;
    }

    public static double[] score(String data, int lag) {
        int len = data.length();
        double[] result = new double[len];
        int i = 0;
        while (i < len - lag) {
            result[i] = data.charAt(i) == data.charAt(i + lag) ? 1.0 : -1.0;
            ++i;
        }
        return result;
    }
}

