/*
 * Decompiled with CFR 0.152.
 */
package FFT;

public class FFT {
    int n;
    public double[] re;
    public double[] im;
    double[] cos_tbl;
    double[] sin_tbl;
    double[] b_re;
    double[] b_im;

    public FFT(double[][] originalData) {
        int max = originalData[0].length;
        if (max < originalData[1].length) {
            max = originalData[1].length;
        }
        this.n = (int)(Math.log(max) / Math.log(2.0));
        int N = (int)Math.pow(2.0, this.n);
        if (N < max) {
            ++this.n;
            N *= 2;
        }
        this.re = new double[N];
        this.im = new double[N];
        int i = 0;
        while (i < N) {
            this.re[i] = 0.0;
            this.im[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < originalData[0].length) {
            this.re[i] = originalData[0][i];
            ++i;
        }
        i = 0;
        while (i < originalData[1].length) {
            this.im[i] = originalData[1][i];
            ++i;
        }
        this.warmupTable();
        this.transform();
        this.bitshift();
    }

    public static void main(String[] args) {
        int i = 0;
        while (i <= 100) {
            System.out.print(i);
            System.out.print("\t");
            System.out.print(Math.log(i) / Math.log(2.0));
            System.out.print("\t");
            int n = (int)(Math.log(i) / Math.log(2.0));
            int N = (int)Math.pow(2.0, n);
            if (N < i) {
                ++n;
                N *= 2;
            }
            System.out.print(n);
            System.out.print("\t");
            System.out.print(N);
            System.out.println();
            ++i;
        }
    }

    public FFT(double[][] originalData, int N) {
        this.re = new double[N];
        this.im = new double[N];
        int i = 0;
        while (i < N) {
            this.re[i] = 0.0;
            this.im[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < originalData[0].length) {
            this.re[i] = originalData[0][i];
            ++i;
        }
        i = 0;
        while (i < originalData[1].length) {
            this.im[i] = originalData[1][i];
            ++i;
        }
        this.warmupTable();
        this.transform();
        this.bitshift();
    }

    public void warmupTable() {
        int N = this.size();
        this.sin_tbl = new double[N];
        this.cos_tbl = new double[N];
        double xx = Math.PI * -2 / (double)N;
        int i = 0;
        while (i < N) {
            double arg = (double)i * xx;
            this.cos_tbl[i] = Math.cos(arg);
            this.sin_tbl[i] = Math.sin(arg);
            ++i;
        }
    }

    public void transform() {
        int N = this.size();
        int num = 1;
        int len = N;
        int i = 0;
        while (i < this.n) {
            len /= 2;
            int tim = 0;
            int j = 0;
            while (j < num) {
                int w = 0;
                int k = 0;
                while (k < len) {
                    int j1 = tim + k;
                    int j2 = j1 + len;
                    double xr = this.re[j1];
                    double xi = this.im[j1];
                    double yr = this.re[j2];
                    double yi = this.im[j2];
                    this.re[j1] = xr + yr;
                    this.im[j1] = xi + yi;
                    this.re[j2] = (xr -= yr) * this.cos_tbl[w] - (xi -= yi) * this.sin_tbl[w];
                    this.im[j2] = xr * this.sin_tbl[w] + xi * this.cos_tbl[w];
                    w += num;
                    ++k;
                }
                tim += 2 * len;
                ++j;
            }
            num *= 2;
            ++i;
        }
    }

    void bitshift() {
        int N = this.size();
        this.b_re = new double[N];
        this.b_im = new double[N];
        int i = 0;
        while (i < N) {
            int k = 0;
            int ii = i;
            int bit = 0;
            while (true) {
                bit = ii & 1 | bit;
                if (++k == this.n) break;
                bit <<= 1;
                ii >>= 1;
            }
            this.b_re[i] = this.re[bit];
            this.b_im[i] = this.im[bit];
            ++i;
        }
        i = 0;
        while (i < N) {
            this.re[i] = this.b_re[i];
            this.im[i] = this.b_im[i];
            ++i;
        }
        double nrml = 1.0 / Math.sqrt(N);
        int i2 = 0;
        while (i2 < N) {
            this.re[i2] = this.re[i2] * nrml;
            this.im[i2] = this.im[i2] * nrml;
            ++i2;
        }
    }

    public double[] fft_amp() {
        int N = this.size();
        double[] data = new double[N];
        int i = 0;
        while (i < N) {
            data[i] = Math.sqrt(this.re[i] * this.re[i] + this.im[i] * this.im[i]);
            ++i;
        }
        return data;
    }

    public double[] real() {
        return this.re;
    }

    public double[] imaginary() {
        return this.im;
    }

    public int size() {
        return this.re.length;
    }

    public static int size(int data0Len, int data1Len) {
        int n;
        int N;
        int max = data0Len;
        if (max < data1Len) {
            max = data1Len;
        }
        if ((N = (int)Math.pow(2.0, n = (int)(Math.log(max) / Math.log(2.0) + 1.0 - 0.1))) < max) {
            ++n;
        }
        N = (int)Math.pow(2.0, n);
        return N;
    }

    public double[][] both() {
        double[][] result = new double[][]{this.re, this.im};
        return result;
    }
}

