/*
 * Decompiled with CFR 0.152.
 */
package FFT;

import FFT.FFT;
import FFT.FFTinv;
import FFT.complex;

public class corr {
    public static double[] corr1(double[] data1, double[] data2) {
        double[][] data1copy = new double[2][];
        double[][] data2copy = new double[2][];
        int len = data1.length;
        if (len == data2.length) {
            data1copy[0] = data1;
            data1copy[1] = new double[len];
            data2copy[0] = data2;
            data2copy[1] = new double[len];
        } else {
            if (len < data2.length) {
                len = data2.length;
            }
            data1copy[0] = new double[len];
            data1copy[1] = new double[len];
            data2copy[0] = new double[len];
            data2copy[1] = new double[len];
            int i = 0;
            while (i < data1.length) {
                data1copy[0][i] = data1[i];
                ++i;
            }
            i = 0;
            while (i < data2.length) {
                data2copy[0][i] = data2[i];
                ++i;
            }
        }
        double[][] data1tmp = new FFT(data1copy).both();
        double[][] data2tmp = new FFT(data2copy).both();
        double[][] HG = new double[2][data1tmp[0].length];
        int i = 0;
        while (i < HG[0].length) {
            double[] tmp2 = complex.conju_product(data1tmp[0][i], data1tmp[1][i], data2tmp[0][i], data2tmp[1][i]);
            HG[0][i] = tmp2[0];
            HG[1][i] = tmp2[1];
            ++i;
        }
        double[] result = new FFTinv(HG).real();
        return result;
    }

    public static double[] corr1bak(double[] data1, double[] data2) {
        int len = data1.length;
        if (len < data2.length) {
            len = data2.length;
        }
        double[][] data1copy = new double[2][len];
        double[][] data2copy = new double[2][len];
        int i = 0;
        while (i < len) {
            data1copy[1][i] = 0.0;
            data1copy[0][i] = 0.0;
            data2copy[1][i] = 0.0;
            data2copy[0][i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < data1.length) {
            data1copy[0][i] = data1[i];
            ++i;
        }
        i = 0;
        while (i < data2.length) {
            data2copy[0][i] = data2[i];
            ++i;
        }
        double[][] data1tmp = new FFT(data1copy).both();
        double[][] data2tmp = new FFT(data2copy).both();
        double[][] HG = new double[2][data1tmp[0].length];
        int i2 = 0;
        while (i2 < HG[0].length) {
            double[] tmp2 = complex.conju_product(data1tmp[0][i2], data1tmp[1][i2], data2tmp[0][i2], data2tmp[1][i2]);
            HG[0][i2] = tmp2[0];
            HG[1][i2] = tmp2[1];
            ++i2;
        }
        double[] result = new FFTinv(HG).real();
        return result;
    }

    public static double[] corrSqrt2(double[][] dataarr1, double[][] dataarr2) {
        int size = dataarr1[0].length;
        double orgLen = dataarr1.length;
        double[][] tmp1 = corr.normalize(corr.transpose(dataarr1));
        double[][] tmp2 = corr.normalize(corr.transpose(dataarr2));
        double[][] tmp = new double[size][];
        int j = 0;
        while (j < size) {
            tmp[j] = corr.corr1(tmp1[j], tmp2[j]);
            ++j;
        }
        int len = tmp[0].length;
        double ratio = (double)len / orgLen;
        double[] result = new double[len];
        double sqrtHalf = Math.sqrt(0.5);
        int i = 0;
        while (i < len) {
            result[i] = 0.0;
            int j2 = 0;
            while (j2 < size) {
                int n = i;
                result[n] = result[n] + tmp[j2][i] * ratio * sqrtHalf;
                ++j2;
            }
            ++i;
        }
        return result;
    }

    public static double[] corr0(double[][] dataarr1, double[][] dataarr2) {
        int size = dataarr1[0].length;
        double orgLen = dataarr1.length;
        double[][] tmp1 = corr.normalize(corr.transpose(dataarr1));
        double[][] tmp2 = corr.normalize(corr.transpose(dataarr2));
        double[][] tmp = new double[size][];
        int j = 0;
        while (j < size) {
            tmp[j] = corr.corr1(tmp1[j], tmp2[j]);
            ++j;
        }
        int len = tmp[0].length;
        double ratio = (double)len / orgLen;
        double[] result = new double[len];
        int i = 0;
        while (i < len) {
            result[i] = 0.0;
            int j2 = 0;
            while (j2 < size) {
                int n = i;
                result[n] = result[n] + tmp[j2][i] * ratio;
                ++j2;
            }
            ++i;
        }
        return result;
    }

    public static double[] corrOld(double[][] dataarr1, double[][] dataarr2) {
        int size = dataarr1[0].length;
        double[][] tmp1 = corr.normalize(corr.transpose(dataarr1));
        double[][] tmp2 = corr.normalize(corr.transpose(dataarr2));
        double[][] tmp = new double[size][];
        int j = 0;
        while (j < size) {
            tmp[j] = corr.corr1(tmp1[j], tmp2[j]);
            ++j;
        }
        int len = tmp[0].length;
        double[] result = new double[len];
        int i = 0;
        while (i < len) {
            result[i] = 0.0;
            int j2 = 0;
            while (j2 < size) {
                int n = i;
                result[n] = result[n] + tmp[j2][i];
                ++j2;
            }
            ++i;
        }
        return result;
    }

    public static double[][] transpose(double[][] org) {
        int len = org.length;
        int size = org[0].length;
        double[][] result = new double[size][len];
        int j = 0;
        while (j < size) {
            int i = 0;
            while (i < len) {
                result[j][i] = org[i][j];
                ++i;
            }
            ++j;
        }
        return result;
    }

    static double[][] normalize(double[][] org) {
        int size = org.length;
        int len = org[0].length;
        double[][] result = new double[size][len];
        int j = 0;
        while (j < size) {
            double total = 0.0;
            int i = 0;
            while (i < len) {
                total += org[j][i];
                ++i;
            }
            total /= (double)len;
            i = 0;
            while (i < len) {
                result[j][i] = org[j][i] - total;
                ++i;
            }
            ++j;
        }
        return result;
    }

    public static int lag(double[][] data1, double[][] data2) {
        double[] result = corr.corr0(data1, data2);
        int peak = corr.findmax(result);
        if ((double)peak <= 0.5 * (double)result.length) {
            return peak;
        }
        return peak - result.length;
    }

    static int findmax(double[] data) {
        int imax = 0;
        double max = 0.0;
        int i = 0;
        while (i < data.length) {
            if (max < data[i]) {
                imax = i;
                max = data[i];
            }
            ++i;
        }
        return imax;
    }

    public static double[] prolong(double ratio, double[] org) {
        int newlength = (int)((double)org.length * ratio);
        double[] result = new double[newlength];
        int i = 0;
        while (i < result.length) {
            double x = (double)i / ratio;
            int num = (int)Math.floor(x);
            result[i] = num < org.length - 1 ? (1.0 - x) * org[num] + x * org[num + 1] : (1.0 - (x -= (double)num)) * org[num];
            ++i;
        }
        return result;
    }

    public static double[][] prolong(double ratio, double[][] org) {
        double[][] tmp = corr.transpose(org);
        double[][] result = new double[tmp.length][];
        int i = 0;
        while (i < result.length) {
            result[i] = corr.prolong(ratio, tmp[i]);
            ++i;
        }
        return corr.transpose(result);
    }
}

