/*
 * Decompiled with CFR 0.152.
 */
package align;

import java.util.Arrays;
import sequence.nucleotide;
import sequence.sequenceBase;

public class Homology {
    public static double[] homology0(String chr, String query) {
        int top = 20;
        double[] simPeak = sequenceBase.corr(chr, query);
        int[] tag = Homology.topList(top, simPeak);
        double[] plus = new double[simPeak.length];
        Arrays.fill(plus, 0.0);
        int i = 0;
        while (i < tag.length) {
            Homology.rawHomology2(tag[i], chr, query, plus);
            ++i;
        }
        String rev = nucleotide.reverseDNA(query);
        simPeak = sequenceBase.corr(chr, rev);
        tag = Homology.topList(top, simPeak);
        double[] minus = new double[simPeak.length];
        Arrays.fill(minus, 0.0);
        int i2 = 0;
        while (i2 < tag.length) {
            Homology.rawHomology2(tag[i2], chr, rev, minus);
            ++i2;
        }
        int minlen = chr.length();
        double[] sub = new double[minlen];
        int i3 = 0;
        while (i3 < minlen) {
            sub[i3] = plus[i3] - minus[i3];
            ++i3;
        }
        double[] result = sub;
        return result;
    }

    static void rawHomology2(int lag, String chr, String query, double[] homologyData) {
        int chrlen = chr.length();
        int querylen = query.length();
        int datalen = homologyData.length;
        int i = 0;
        while (i < querylen) {
            char c1 = '-';
            if (i + lag >= 0 && i + lag < chrlen) {
                c1 = chr.charAt(i + lag);
            }
            char c2 = query.charAt(i);
            double work = 0.0;
            if (c1 != '-' && c2 != '-' && c1 == c2) {
                work += 1.0;
            }
            if (i + lag < datalen && homologyData[i + lag] < work) {
                homologyData[i + lag] = 1.0;
            }
            ++i;
        }
    }

    static double[] rawHomology(String chr, String alignedQuery) {
        double[] result = new double[chr.length()];
        int i = 0;
        while (i < chr.length()) {
            char c1 = chr.charAt(i);
            char c2 = alignedQuery.charAt(i);
            result[i] = c1 != '-' && c2 != '-' && c1 == c2 ? 1.0 : 0.0;
            ++i;
        }
        return result;
    }

    public static int[] topList(int size0, double[] data) {
        double[] copy = new double[data.length];
        int i = 0;
        while (i < data.length) {
            copy[i] = data[i];
            ++i;
        }
        Arrays.sort(copy);
        int[] result = new int[size0];
        int j = 0;
        while (j < size0) {
            double max = copy[copy.length - 1 - j];
            int i2 = 0;
            i2 = 0;
            while (i2 < data.length) {
                if (max == data[i2]) break;
                ++i2;
            }
            result[j] = i2;
            ++j;
        }
        return result;
    }
}

