/*
 * Decompiled with CFR 0.152.
 */
package test;

import test.disrand;

public class RandomSequence {
    public static double humanGCcontent = 0.5;
    public static double inRate = 0.107;
    public static double delRate = 0.043;
    public static double errRate = 0.009;

    public static void main(String[] argv) {
        int i = 0;
        while (i < 100) {
            String org = RandomSequence.humanRandomSequence(100);
            String read = RandomSequence.pacBioSequence(org, inRate, delRate, errRate, humanGCcontent);
            System.out.println(org);
            System.out.println(read);
            ++i;
        }
    }

    public static String humanRandomSequence(int len) {
        return RandomSequence.randomSequence(len, humanGCcontent);
    }

    public static String randomSequence(int len, double GCcontent) {
        StringBuffer result = new StringBuffer();
        double[] content = new double[]{(1.0 - GCcontent) / 2.0, GCcontent / 2.0, (1.0 - GCcontent) / 2.0, GCcontent / 2.0};
        char[] nuc = new char[]{'T', 'C', 'A', 'G'};
        int i = 0;
        while (i < len) {
            result.append(nuc[disrand.value(content)]);
            ++i;
        }
        return result.toString();
    }

    public static String mutantSequence(String org, double mutationRate, double GCcontent) {
        int len = org.length();
        StringBuffer result = new StringBuffer();
        double[] content = new double[]{(1.0 - GCcontent) / 2.0, GCcontent / 2.0, (1.0 - GCcontent) / 2.0, GCcontent / 2.0};
        char[] nuc = new char[]{'T', 'C', 'A', 'G'};
        int i = 0;
        while (i < len) {
            double x = Math.random();
            if (x < mutationRate) {
                result.append(nuc[disrand.value(content)]);
            } else {
                result.append(org.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    public static String indelSequence(String org, double indelRate, double GCcontent) {
        int len = org.length();
        StringBuffer result = new StringBuffer();
        double[] content = new double[]{(1.0 - GCcontent) / 2.0, GCcontent / 2.0, (1.0 - GCcontent) / 2.0, GCcontent / 2.0};
        char[] nuc = new char[]{'T', 'C', 'A', 'G'};
        int i = 0;
        while (i < len) {
            double x = Math.random();
            if (x < indelRate / 2.0) {
                result.append(nuc[disrand.value(content)]);
                result.append(org.charAt(i));
            }
            if (indelRate / 2.0 <= x) {
                // empty if block
            }
            if (indelRate <= x) {
                result.append(org.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    public static String pacBioSequence(String org, double indelRate, double GCcontent) {
        int len = org.length();
        StringBuffer result = new StringBuffer();
        double[] content = new double[]{(1.0 - GCcontent) / 2.0, GCcontent / 2.0, (1.0 - GCcontent) / 2.0, GCcontent / 2.0};
        char[] nuc = new char[]{'T', 'C', 'A', 'G'};
        int i = 0;
        while (i < len) {
            double x = Math.random();
            if (x < indelRate) {
                result.append(nuc[disrand.value(content)]);
                result.append(org.charAt(i));
            }
            if (indelRate <= x) {
                result.append(org.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    public static String pacBioSequence(String org, double inRate, double delRate, double errorRate, double GCcontent) {
        int len = org.length();
        StringBuffer result = new StringBuffer();
        double[] content = new double[]{(1.0 - GCcontent) / 2.0, GCcontent / 2.0, (1.0 - GCcontent) / 2.0, GCcontent / 2.0};
        char[] nuc = new char[]{'T', 'C', 'A', 'G'};
        int i = 0;
        while (i < len) {
            double x = Math.random();
            if (x < inRate) {
                result.append(nuc[disrand.value(content)]);
                result.append(org.charAt(i));
            } else if (!(x < inRate + delRate)) {
                if (x < inRate + delRate + errorRate) {
                    result.append(nuc[disrand.value(content)]);
                } else if (x >= inRate + delRate + errorRate) {
                    result.append(org.charAt(i));
                }
            }
            ++i;
        }
        return result.toString();
    }
}

