/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.dyna;

import java.util.*;
import java.io.*;
import paraselene.tag.*;


/**
 * name 属性検証定義。<br>
 * 指定された name 属性値が HTML 中に登場しているか
 * {@link DynamicPage#inspectName(Page, NameDefine[], String...)}
 * で検証するために使用します。
 */
public class NameDefine implements Serializable {
	private static final long serialVersionUID = 2L;
	private String		name;
	private Class<?>	cls;
	private String		err = "It is uninspection.";

	void setError( String s ) {
		err = s;
	}

	/**
	 * コンストラクタ。tag を指定すると、クラス検証も併せて行います。
	 * @param name name属性値
	 * @param tag 割り当てクラス。クラス検証が不要な場合はnull。
	 */
	public NameDefine( String name, Class<?> tag ) {
		this.name = name.toLowerCase( Locale.ENGLISH );
		cls = tag;
	}

	/**
	 * コンストラクタ。クラス検証は行いません。
	 * @param name name属性値
	 */
	public NameDefine( String name ) {
		this( name, null );
	}

	/**
	 * name属性値の取得。
	 * @return name属性値。
	 */
	public String getName() {
		return name;
	}

	/**
	 * クラスの取得。
	 * @return クラス。
	 */
	public Class<?> getDefineClass() {
		return cls;
	}

	/**
	 * 検証結果を返します。
	 * @return エラー内容。
	 */
	public String getResult() {
		return err;
	}

	/**
	 * 文字列表現にして返します。
	 * @return 文字列
	 */
	public String toString() {
		StringBuilder	buf = new StringBuilder( name );
		buf = buf.append( "(" );
		buf = buf.append( cls == null?	"-":	cls.getName() );
		buf = buf.append( ")  " );
		buf = buf.append( err );
		return buf.toString();
	}
}

