#include <string.h>

#include <gtk/gtk.h>
#include "libgtkhelper.h"

#include "SyncQueue.h"
#include "Merger.h"

#define NCHARS 1000

char labelchars[NCHARS] = "";
char *currentpos;

GtkWidget* label;

pards_pid w1, w2;
int canceled_w1 = 0;
int canceled_w2 = 0;

static void callback(GtkWidget *widget, gpointer data)
{
  char* str = "Button Pressed\n";
  if(currentpos + strlen(str) > labelchars + NCHARS) return;
  else {
    strcpy(currentpos,str);
    currentpos+= strlen(str);
    gtk_label_set_text(GTK_LABEL(label),labelchars);
  }
}

static void cancel(GtkWidget *widget, gpointer data)
{
  if(!canceled_w1){
    pards_send_interrupt(w1);
    canceled_w1 = 1;
  }
  if(!canceled_w2){
    pards_send_interrupt(w2);
    canceled_w2 = 1;
  }
}

static gboolean delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  if(!canceled_w1){
    pards_send_interrupt(w1);
    canceled_w1 = 1;
  }
  if(!canceled_w2){
    pards_send_interrupt(w2);
    canceled_w2 = 1;
  }
  gtk_main_quit();
  return FALSE;
}


int main(int argc, char *argv[])
{
  GtkWidget *window;
  GtkWidget *button;
  GtkWidget *box;

  pards_init();

  gtk_init(&argc, &argv);

  SyncQueue<Callback*> *c = new SyncQueue<Callback*>(4);
  
  gtkhelper_init(c);

  Merger<Callback*> *m = new Merger<Callback*>(c,2);
  void worker(int,Merger<Callback*>*);

  ISPAWN(w1,worker(1,m));
  ISPAWN(w2,worker(2,m));
  
  // Window
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  gtk_window_set_title(GTK_WINDOW(window), "GTK sample");
  
  g_signal_connect(G_OBJECT(window), "delete_event", G_CALLBACK(delete_event),
		   NULL);

  gtk_container_set_border_width(GTK_CONTAINER(window), 10);

  // Box
  box = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), box);

  // Button
  button = gtk_button_new_with_label("Button");

  g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(callback), NULL);

  gtk_box_pack_start(GTK_BOX(box), button, FALSE, FALSE, 0);

  gtk_widget_show(button);

  // Cancel Button
  button = gtk_button_new_with_label("Cancel");

  g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(cancel), NULL);

  gtk_box_pack_start(GTK_BOX(box), button, FALSE, FALSE, 0);

  gtk_widget_show(button);

  // Label
  currentpos = labelchars;
  label = gtk_label_new(labelchars);

  gtk_box_pack_start(GTK_BOX(box),label,FALSE,FALSE,0);

  gtk_widget_show(label);

  gtk_widget_show(box);

  // show window
  gtk_widget_show(window);

  // main loop
  gtk_main();

  pards_finalize();

  return 0;
}

class MyCallback : public Callback
{
public:
  int val;
  int id;
  void run(){
    char str[1000];
    if(val == -1)
      sprintf(str,"Process %d is canceled\n",id);
    else
      sprintf(str,"Message from Process %d, val = %d\n",id,val);
    if(currentpos + strlen(str) > NCHARS + labelchars) return;
    else{
      strcpy(currentpos,str);
      currentpos += strlen(str);
      gtk_label_set_text(GTK_LABEL(label),labelchars);
    }
  }
};

int simulate_slow_read()
{
  static int r = 0;

  sleep(3+rand()%3);
  return r++;
}

void worker(int id, Merger<Callback*> *c)
{  
  srand(id);
  for(int i = 0; i < 5; i++){
    int r = simulate_slow_read();
    MyCallback* val = new MyCallback;
    val->id = id;
    if(pards_is_interrupted()){
      val->val = -1;
      c->put(val);
      c->release();
      return;
    } else {
      val->val = r;
      c->put(val);
    }
  }
  c->release();
}

