#include <gtk/gtk.h>
#include "libgtkhelper.h"

void* Callback::operator new(size_t size)
{
  void* ptr = pards_shmalloc(size);
  return ptr;
}

void Callback::operator delete(void* obj)
{
  pards_shmfree(obj);
  return;
}

static void syncListToPipe(int fd, SyncList<Callback*> *s)
{
  SyncList<Callback*>* current = s;
  ssize_t size;
  char buf[1] = {0};
  
  while(1){
    current->read();
    while(1){
      size = write(fd,buf,1);
      if(size == 1) break;
      else if(size == -1){
	pards_perror("syncListToPipe: failed to write to pipe", CRITICAL);
	close(fd);
	return;
      }
    }
    current = current->readcdr();
    if(current == 0) break;
  }

  while(1){ // for terminating
    size = write(fd,buf,1);
    if(size == 1) break;
    else if(size == -1){
      pards_perror("syncListToPipe: failed to write to pipe", CRITICAL);
      close(fd);
      return;
    }
  }
  
  close(fd); // This doesn't enable read()???
}

static int create_pipe_callback(SyncList<Callback*> *s)
{
  int fd[2];
  int pid;

  if(pipe(fd) == -1){
    pards_perror("pipe createion error",FATAL);
    return -1; // not reached
  }

  if((pid = fork()) == -1){
    pards_perror("error in create_pipe_callback",FATAL);
    return -1; // not reached
  } else if(pid == 0){ // child
    syncListToPipe(fd[1],s);
    _exit(0);
    return -1; // not reached
  } else { // parent
    return fd[0];
  }
}

static SyncList<Callback*> *currentCallback;
static int isfirst = 1;
static gint tag;

static void input_callback(gpointer data, gint source, GdkInputCondition condition)
{
  char buf[1];
  ssize_t size;

  while(1){
    size = read((int)source,buf,1);
    if(size < -1) {
      if(errno == EINTR) continue; // signal
      else{
	pards_perror("Error reading from pipe in input_callback.",CRITICAL);
	return;
      }
    } else if(size == 0) { // pipe is closed
      return;
    } else {
      if(currentCallback != 0){ // fail safe
	if(isfirst){
	  isfirst = 0;
	} else {
	  currentCallback = currentCallback->release();
	  if(currentCallback == 0){ // terminate
	    gdk_input_remove(tag);
	    return;
	  }
	}
	Callback *c = currentCallback->read();
	c->run();
	delete c;
      }
    }
    return;
  }
}

void gtkhelper_init(SyncList<Callback*>* cbk)
{
  currentCallback = cbk;
  isfirst = 1;
  int fd = create_pipe_callback(cbk);
  tag = gdk_input_add((gint)fd,GDK_INPUT_READ,input_callback,NULL);
}
