#include "Sync.h"

void sync_fib(int,Sync<int>);
int fib(int);

int main(int argc, char** argv)
{
  if(argc < 2) {printf("usage: fib NUM (use small number like 10)\n"); exit(0);}
  int v = atoi(argv[1]);

  pards_init();
  
  Sync<int> a, b;

  SPAWN(sync_fib(v-1,a));
  SPAWN(sync_fib(v-2,b));

  printf("fib %d = %d\n",v, a.read() + b.read());

  a.free();
  b.free();

  pards_finalize();
}


void sync_fib(int a, Sync<int> b)
{
  b.write(fib(a));
}

int fib(int a)
{
  if(a == 1) return 1;
  else if (a == 2) return 1;
  else return fib(a-1) + fib(a-2);
}
