#include "SyncList.h"

int main(int argc, char* argv[])
{
  void generator(SyncList<int>*);
  void consumer(SyncList<int>*, Sync<int> b);

  if(argc < 2) {
    printf("timedintrsample timeout(sec) (use 1-4 to see interrupt).\n");
    exit(0);
  }

  int timeout = atoi(argv[1]);

  pards_init();

  SyncList<int> *a;
  Sync<int> b;
  a = new SyncList<int>;

  pards_pid g,c;
  ISPAWN(g,generator(a));
  ISPAWN(c,consumer(a, b));
  
  sleep(timeout);
  if(!b.is_written()){
    pards_send_interrupt(c);
    pards_send_interrupt(g);
  }

  pards_finalize();
}


void generator(SyncList<int> *a)
{
  int i;
  SyncList<int> *current;
  current = a;

  for(i = 0; i < 3; i++){
    current->write(i);
    sleep(2);
    if(pards_is_interrupted()){
      printf("generator: interrupted\n");
      current->writecdr(0);
      return;
    }
    current = current->create();
    printf("writer:value = %d\n",i);
  }
  current->write(i);
  printf("writer:value = %d\n",i);
  current->writecdr(0);
}

void consumer(SyncList<int> *a, Sync<int> b)
{
  SyncList<int> *current;
  current = a;

  while(1){
    pards_status s;
    int v = current->intrread(&s);
    if(s != SUCCESS){
      printf("consumer: interrupted\n");
      return;
    }
    current = current->intrrelease(&s);
    if(s != SUCCESS){
      printf("consumer: interrupted\n");
      return;
    }
    printf("reader:value = %d\n",v);
    if(current == 0) break;
  }
  b.write(1);
}
