#include "SyncQueue.h"
#include "Merger.h"

class Item{
public:
  int val;
  int id;
};

int main()
{
  void generator(int,Merger<Item>*);
  void consumer(SyncList<Item>*);

  pards_init();

  SyncList<Item> *first = new SyncList<Item>; 
  Merger<Item> *merger = new Merger<Item>(first,2);
  
  pards_pid a, b;
  ISPAWN(a, generator(1,merger));
  ISPAWN(b, generator(2,merger));
  SPAWN(consumer(first));

  sleep(2);
  pards_send_interrupt(a);
  pards_send_interrupt(b);

  pards_finalize();
}


void generator(int id, Merger<Item> *m)
{
  pards_status st;
  srand(id);
  for(int i = 0; i < 3; i++){
    sleep(rand()%3);
    Item it;
    it.val = i;
    it.id = id;
    m->intrput(it, &st);
    if(st != SUCCESS || pards_is_interrupted()){
      printf("Interrupted! id:%d\n",id);
      break;
    }
  }
  m->release();
}

void consumer(SyncList<Item> *l)
{
  SyncList<Item> *current = l;
  while(1){
    sleep(1);
    Item it = current->read();
    printf("val = %d, id = %d\n",it.val, it.id);
    current = current->release();
    if(current == 0) break;
  }
}
