#include "SyncQueue.h"

int main(int argc, char* argv[])
{
  void generator(SyncQueue<int>*);
  void consumer(SyncQueue<int>*, Sync<int> b);

  if(argc < 2) {
    printf("timedintrsample timeout(sec) (use 1-4 to see interrupt).\n");
    exit(0);
  }

  int timeout = atoi(argv[1]);

  pards_init();

  SyncQueue<int> *a;
  Sync<int> b;
  a = new SyncQueue<int>(1);

  pards_pid g;
  ISPAWN(g,generator(a));
  SPAWN(consumer(a, b));
  
  sleep(timeout);
  if(!b.is_written()){
    pards_send_interrupt(g);
  }

  pards_finalize();
}


void generator(SyncQueue<int> *a)
{
  int i;
  SyncQueue<int> *current;
  current = a;

  for(i = 0; i < 3; i++){
    current->write(i);
    if(pards_is_interrupted()){
      printf("generator: interrupted\n");
      current->writecdr(0);
      return;
    }
    pards_status s;
    current = current->intrcreate(&s);
    if(s != SUCCESS) {
      printf("generator: interrupted\n");
      current->writecdr(0);
      return;
    }
    printf("writer:value = %d\n",i);
  }
  current->write(i);
  printf("writer:value = %d\n",i);
  current->writecdr(0);
}

void consumer(SyncQueue<int> *a, Sync<int> b)
{
  SyncQueue<int> *current;
  current = a;

  while(1){
    sleep(2);
    int v = current->read();
    current = current->release();
    printf("reader:value = %d\n",v);
    if(current == 0) break;
  }
  b.write(1);
}
