#include "Sync.h"

int main(int argc, char* argv[])
{
  void writer(Sync<int>);
  void reader(Sync<int>);

  if(argc < 2) {
    printf("intrreadsample timeout(sec) (use 1-4 to see interrupt)\n");
    exit(0);
  }

  int timeout = atoi(argv[1]);

  pards_init();

  Sync<int> a;

  pards_pid w,r;

  ISPAWN(w,writer(a));
  ISPAWN(r,reader(a));

  sleep(timeout);
  if(!a.is_written()){
    pards_send_interrupt(w);
    pards_send_interrupt(r);
  }
  pards_finalize();
}

void writer(Sync<int> a)
{
  sleep(5);
  if(pards_is_interrupted()) return;
  else
    a.write(1);
}

void reader(Sync<int> a)
{
  pards_status s;
  int val = a.intrread(&s);
  if(s == SUCCESS)
    printf("value = %d\n",val);
  else
    printf("interrupted\n");
}
