#include "SyncQueue.h"
#include "Merger.h"

class Item{
public:
  int val;
  int id;
};

int main()
{
  void generator(int,SyncQueue<Item>*);
  void consumer(SyncQueue<Item>*);
  void mergerproc(SyncQueue<Item>*, Merger<Item>*);

  pards_init();

  SyncQueue<Item> *list1 = new SyncQueue<Item>(2); 
  SyncQueue<Item> *list2 = new SyncQueue<Item>(2); 

  SyncQueue<Item> *first = new SyncQueue<Item>(2); 
  Merger<Item> *merger = new Merger<Item>(first,2);

  SPAWN(generator(1,list1));
  SPAWN(generator(2,list2));

  SPAWN(mergerproc(list1, merger));
  SPAWN(mergerproc(list2, merger));

  SPAWN(consumer(first));

  //  delete merger;

  pards_finalize();
}


void generator(int id, SyncQueue<Item> *l)
{
  SyncQueue<Item> *current;

  current = l;
  srand(id);
  for(int i = 0; i < 3; i++){
    sleep(rand()%3);
    Item it;
    it.val = i;
    it.id = id;
    if(i < 2) {
      current->write(it);
      current = current->create();
    } else {
      current->write(it);
      current->writecdr(0);
    }
  }
}

void mergerproc(SyncQueue<Item> *l, Merger<Item> *m)
{
  SyncQueue<Item> *current = l;
  while(1){
    m->put(current->read());
    if((current = current->release()) == 0){
      m->release();
      break;
    }
  }
}

void consumer(SyncQueue<Item> *l)
{
  SyncQueue<Item> *current = l;
  while(1){
    Item it = current->read();
    printf("val = %d, id = %d\n",it.val, it.id);
    current = current->release();
    if(current == 0) break;
  }
}
