#include "SyncQueue.h"

int main()
{
  void generator(SyncQueue<int>*);
  void consumer(SyncQueue<int>*);

  pards_init();

  SyncQueue<int> *a;
  a = new SyncQueue<int>(2);

  SPAWN(generator(a));
  SPAWN(consumer(a));

  pards_finalize();
}


void generator(SyncQueue<int> *a)
{
  int i;
  SyncQueue<int> *current;
  current = a;

  for(i = 0; i < 10; i++){
    current->write(i);
    printf("writer:value = %d\n",i);
    current = current->create();
  }
  current->write(i);
  printf("writer:value = %d\n",i);
  current->writecdr(0);
}

void consumer(SyncQueue<int> *a)
{
  SyncQueue<int> *current;
  current = a;

  while(1){
    sleep(1);
    printf("reader:value = %d\n",current->read());
    current = current->release();
    if(current == 0) break;
  }
}
    
