#include "SyncList.h"

int main(int argc, char* argv[])
{
  void generator(SyncList<int>*);
  void consumer(int,SyncList<int>*);

  if(argc < 2) {
    printf("timedlistsample timeout(sec) (use 1 to see timeout; more than 3 does not timeout.)\n");
    exit(0);
  }

  int timeout = atoi(argv[1]);

  pards_init();

  SyncList<int> *a;
  a = new SyncList<int>;

  SPAWN(generator(a));
  SPAWN(consumer(timeout, a));

  pards_finalize();
}


void generator(SyncList<int> *a)
{
  int i;
  SyncList<int> *current;
  current = a;

  for(i = 0; i < 3; i++){
    current->write(i);
    sleep(2);
    current = current->create();
    printf("writer:value = %d\n",i);
  }
  current->write(i);
  printf("writer:value = %d\n",i);
  current->writecdr(0);
}

void consumer(int timeout, SyncList<int> *a)
{
  SyncList<int> *current;
  current = a;

  struct timeval tv = {timeout, 0};

  while(1){
    pards_status is_timedout;
    int v = current->read();
    while(1){
      printf("is cdr written = %d, do timedrelease\n",current->is_cdr_written());
      current = current->timedrelease(&tv,&is_timedout);
      if(is_timedout == TIMEOUT){
	printf("time out. trying again\n");
	continue;
      } else {
	printf("reader:value = %d\n",v);
	break;
      }
    }
    if(current == 0) break;
  }
}
