#include "SyncQueue.h"
#include "Merger.h"

class Item{
public:
  int val;
  int id;
};

int main()
{
  void generator(int,Merger<Item>*);
  void consumer(SyncQueue<Item>*);

  pards_init();

  SyncQueue<Item> *first = new SyncQueue<Item>(1); 
  Merger<Item> *merger = new Merger<Item>(first,2);
  
  SPAWN(generator(1,merger));
  SPAWN(generator(2,merger));
  SPAWN(consumer(first));

  pards_finalize();
}


void generator(int id, Merger<Item> *m)
{
  pards_status st;
  srand(id);
  for(int i = 0; i < 3; i++){
    sleep(rand()%3);
    Item it;
    it.val = i;
    it.id = id;
    struct timeval tv = {1,0};
    m->timedput(it, &tv, &st);
    if(st == TIMEOUT){
      printf("Timeout. id:%d\n",id);
      break;
    }
  }
  m->release();
}

void consumer(SyncQueue<Item> *l)
{
  SyncQueue<Item> *current = l;
  while(1){
    sleep(3);
    Item it = current->read();
    printf("val = %d, id = %d\n",it.val, it.id);
    current = current->release();
    if(current == 0) break;
  }
}
