#include "Sync.h"

int main(int argc, char* argv[])
{
  void foo(Sync<int>);

  if(argc < 2) {
    printf("timedreadsample timeout(sec) (use 1 to see timeout; more than 3 does not timeout.)\n");
    exit(0);
  }

  int timeout = atoi(argv[1]);

  pards_init();

  struct timeval tv = {timeout,0};

  Sync<int> a;

  SPAWN(foo(a));

  pards_status is_timedout;
  printf("is_written = %d, do timedread.\n", a.is_written());
  int v = a.timedread(&tv,&is_timedout);
  printf("is_written = %d\n", a.is_written());
  if(is_timedout == TIMEOUT)
    printf("time out\n");
  else
    printf("value = %d\n",v);

  pards_finalize();
}

void foo(Sync<int> a)
{
  sleep(2);
  a.write(1);
}
