/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.ComboItemListener;
import org.weasis.core.api.gui.util.DropButtonIcon;
import org.weasis.core.api.gui.util.DropDownButton;
import org.weasis.core.api.gui.util.SliderChangeListener;
import org.weasis.core.api.gui.util.ToggleButtonListener;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.editor.image.ImageViewerEventManager;
import org.weasis.core.ui.editor.image.ImageViewerPlugin;
import org.weasis.core.ui.editor.image.MeasureToolBar;
import org.weasis.core.ui.editor.image.MouseActions;
import org.weasis.core.ui.util.WtoolBar;

public class ViewerToolBar<E extends ImageElement>
extends WtoolBar
implements ActionListener {
    public static final ActionW[] actionsButtons = new ActionW[]{ActionW.PAN, ActionW.WINLEVEL, ActionW.SCROLL_SERIES, ActionW.ZOOM, ActionW.ROTATION, ActionW.MEASURE, ActionW.CONTEXTMENU};
    public static final ActionW[] actionsScroll = new ActionW[]{ActionW.SCROLL_SERIES, ActionW.ZOOM, ActionW.ROTATION};
    public static final Icon MouseLeftIcon = new ImageIcon(MouseActions.class.getResource("/icon/32x32/mouse-left.png"));
    public static final Icon MouseRightIcon = new ImageIcon(MouseActions.class.getResource("/icon/32x32/mouse-right.png"));
    public static final Icon MouseMiddleIcon = new ImageIcon(MouseActions.class.getResource("/icon/32x32/mouse-middle.png"));
    public static final Icon MouseWheelIcon = new ImageIcon(MouseActions.class.getResource("/icon/32x32/mouse-wheel.png"));
    protected final ImageViewerEventManager<E> eventManager;
    private final DropDownButton mouseLeft;
    private DropDownButton mouseMiddle;
    private DropDownButton mouseRight;
    private DropDownButton mouseWheel;
    private final MeasureToolBar<E> measureToolBar;

    public ViewerToolBar(final ImageViewerEventManager<E> eventManager) {
        super("viewer2dBar", WtoolBar.TYPE.main);
        if (eventManager == null) {
            throw new IllegalArgumentException("EventManager cannot be null");
        }
        this.eventManager = eventManager;
        this.measureToolBar = new MeasureToolBar<E>(eventManager);
        MouseActions actions = eventManager.getMouseActions();
        int active = actions.getActiveButtons();
        this.mouseLeft = this.buildMouseButton(actions, "left");
        this.mouseLeft.setToolTipText(Messages.getString("ViewerToolBar.change") + Messages.getString("ViewerToolBar.m_action"));
        this.add((JButton)this.mouseLeft);
        if ((active & 0x800) == 2048) {
            this.mouseMiddle = this.buildMouseButton(actions, "middle");
            this.add((JButton)this.mouseMiddle);
        }
        if ((active & 0x1000) == 4096) {
            this.mouseRight = this.buildMouseButton(actions, "right");
            this.add((JButton)this.mouseRight);
        }
        if ((active & 2) == 2) {
            this.mouseWheel = new DropDownButton("wheel", this.buildMouseIcon("wheel", actions.getAction("wheel"))){

                protected JPopupMenu getPopupMenu() {
                    return ViewerToolBar.this.getPopupMenuScroll(this);
                }
            };
            this.mouseWheel.setToolTipText(Messages.getString("ViewerToolBar.change"));
            this.add((JButton)this.mouseWheel);
        }
        this.addSeparator(WtoolBar.SEPARATOR_2x24);
        DropDownButton layout = new DropDownButton("layout", (Icon)new DropButtonIcon((Icon)new ImageIcon(MouseActions.class.getResource("/icon/32x32/layout.png")))){

            protected JPopupMenu getPopupMenu() {
                return ViewerToolBar.this.getLayoutPopupMenuButton(this);
            }
        };
        layout.setToolTipText(Messages.getString("ViewerToolBar.layout"));
        this.add((JButton)layout);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        DropDownButton button = new DropDownButton(ActionW.SYNCH.cmd(), (Icon)new DropButtonIcon((Icon)new ImageIcon(MouseActions.class.getResource("/icon/32x32/synch.png")))){

            protected JPopupMenu getPopupMenu() {
                return ViewerToolBar.this.getSychPopupMenuButton(this);
            }
        };
        button.setToolTipText(Messages.getString("ViewerToolBar.synch"));
        this.add((JButton)button);
        this.addSeparator(WtoolBar.SEPARATOR_2x24);
        JButton jButtonActualZoom = new JButton(new ImageIcon(MouseActions.class.getResource("/icon/32x32/zoom-original.png")));
        jButtonActualZoom.setToolTipText(Messages.getString("ViewerToolBar.zoom_1"));
        jButtonActualZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionState zoom = eventManager.getAction(ActionW.ZOOM);
                if (zoom instanceof SliderChangeListener) {
                    ((SliderChangeListener)zoom).setValue(eventManager.viewScaleToSliderValue(1.0));
                }
            }
        });
        this.add(jButtonActualZoom);
        JButton jButtonBestFit = new JButton(new ImageIcon(MouseActions.class.getResource("/icon/32x32/zoom-bestfit.png")));
        jButtonBestFit.setToolTipText(Messages.getString("ViewerToolBar.zoom_b"));
        jButtonBestFit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                eventManager.firePropertyChange(ActionW.ZOOM.cmd(), null, 0.0);
            }
        });
        this.add(jButtonBestFit);
        JToggleButton jButtonLens = new JToggleButton(new ImageIcon(MouseActions.class.getResource("/icon/32x32/zoom-lens.png")));
        jButtonLens.setToolTipText("Show the magnifying lens");
        ActionState lens = eventManager.getAction(ActionW.LENS);
        if (lens instanceof ToggleButtonListener) {
            ((ToggleButtonListener)lens).registerComponent((AbstractButton)jButtonLens);
        }
        this.add(jButtonLens);
        this.displayMeasureToobar();
    }

    private DropDownButton buildMouseButton(MouseActions actions, String actionLabel) {
        String action = actions.getAction(actionLabel);
        DropDownButton button = new DropDownButton(actionLabel, this.buildMouseIcon(actionLabel, action)){

            protected JPopupMenu getPopupMenu() {
                return ViewerToolBar.this.getPopupMenuButton(this);
            }
        };
        button.setActionCommand(action);
        button.setToolTipText(Messages.getString("ViewerToolBar.change"));
        return button;
    }

    public DropDownButton getMouseLeft() {
        return this.mouseLeft;
    }

    private JPopupMenu getSychPopupMenuButton(DropDownButton dropDownButton) {
        ActionState synch = this.eventManager.getAction(ActionW.SYNCH);
        JPopupMenu popupMouseButtons = new JPopupMenu();
        if (synch instanceof ComboItemListener) {
            JMenu menu = ((ComboItemListener)synch).createUnregisteredRadioMenu("synch");
            popupMouseButtons.setInvoker((Component)dropDownButton);
            Component[] cps = menu.getMenuComponents();
            for (int i = 0; i < cps.length; ++i) {
                popupMouseButtons.add(cps[i]);
            }
        }
        return popupMouseButtons;
    }

    private JPopupMenu getLayoutPopupMenuButton(DropDownButton dropDownButton) {
        ActionState layout = this.eventManager.getAction(ActionW.LAYOUT);
        JPopupMenu popupMouseButtons = new JPopupMenu();
        if (layout instanceof ComboItemListener) {
            JMenu menu = ((ComboItemListener)layout).createUnregisteredRadioMenu("layout");
            popupMouseButtons.setInvoker((Component)dropDownButton);
            Component[] cps = menu.getMenuComponents();
            for (int i = 0; i < cps.length; ++i) {
                popupMouseButtons.add(cps[i]);
            }
        }
        return popupMouseButtons;
    }

    public MeasureToolBar getMeasureToolBar() {
        return this.measureToolBar;
    }

    private JPopupMenu getPopupMenuButton(DropDownButton dropButton) {
        String type = dropButton.getType();
        String action = this.eventManager.getMouseActions().getAction(type);
        JPopupMenu popupMouseButtons = new JPopupMenu(type);
        popupMouseButtons.setInvoker((Component)dropButton);
        ButtonGroup groupButtons = new ButtonGroup();
        for (int i = 0; i < actionsButtons.length; ++i) {
            JRadioButtonMenuItem radio = new JRadioButtonMenuItem(actionsButtons[i].getTitle(), actionsButtons[i].getIcon(), actionsButtons[i].cmd().equals(action));
            radio.setActionCommand(actionsButtons[i].cmd());
            radio.addActionListener(this);
            if ("left".equals(type)) {
                radio.setAccelerator(KeyStroke.getKeyStroke(actionsButtons[i].getKeyCode(), actionsButtons[i].getModifier()));
            }
            popupMouseButtons.add(radio);
            groupButtons.add(radio);
        }
        return popupMouseButtons;
    }

    private JPopupMenu getPopupMenuScroll(DropDownButton dropButton) {
        String type = dropButton.getType();
        String action = this.eventManager.getMouseActions().getAction(type);
        JPopupMenu popupMouseScroll = new JPopupMenu(type);
        popupMouseScroll.setInvoker((Component)dropButton);
        ButtonGroup groupButtons = new ButtonGroup();
        for (int i = 0; i < actionsScroll.length; ++i) {
            JRadioButtonMenuItem radio = new JRadioButtonMenuItem(actionsScroll[i].getTitle(), actionsScroll[i].getIcon(), actionsScroll[i].cmd().equals(action));
            radio.setActionCommand(actionsScroll[i].cmd());
            radio.addActionListener(this);
            popupMouseScroll.add(radio);
            groupButtons.add(radio);
        }
        return popupMouseScroll;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JRadioButtonMenuItem item;
        if (e.getSource() instanceof JRadioButtonMenuItem && (item = (JRadioButtonMenuItem)e.getSource()).getParent() instanceof JPopupMenu) {
            JPopupMenu pop = (JPopupMenu)item.getParent();
            MouseActions mouseActions = this.eventManager.getMouseActions();
            mouseActions.setAction(pop.getLabel(), item.getActionCommand());
            ImageViewerPlugin<E> view = this.eventManager.getSelectedView2dContainer();
            if (view != null) {
                view.setMouseActions(mouseActions);
            }
            if (pop.getInvoker() instanceof DropDownButton) {
                this.changeButtonState(pop.getLabel(), item.getActionCommand());
            }
        }
    }

    private void displayMeasureToobar() {
        if (this.isCommandActive(ActionW.MEASURE.cmd())) {
            this.measureToolBar.setVisible(true);
        } else {
            this.measureToolBar.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }

    public boolean isCommandActive(String cmd) {
        int active = this.eventManager.getMouseActions().getActiveButtons();
        return cmd != null && cmd.equals(this.mouseLeft.getActionCommand()) || (active & 0x800) == 2048 && this.mouseMiddle != null && cmd.equals(this.mouseMiddle.getActionCommand()) || (active & 0x1000) == 4096 && this.mouseRight != null && cmd.equals(this.mouseRight.getActionCommand());
    }

    public void changeButtonState(String type, String action) {
        DropDownButton button = this.getDropDownButton(type);
        if (button != null) {
            Icon icon = this.buildMouseIcon(type, action);
            button.setIcon(icon);
            button.setActionCommand(action);
            this.displayMeasureToobar();
        }
    }

    private Icon buildMouseIcon(String type, String action) {
        final Icon mouseIcon = this.getMouseIcon(type);
        ActionW actionW = this.getAction(actionsButtons, action);
        final Icon smallIcon = actionW == null ? null : actionW.getIcon();
        return new DropButtonIcon(new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                mouseIcon.paintIcon(c, g, x, y);
                if (smallIcon != null) {
                    smallIcon.paintIcon(c, g, x += mouseIcon.getIconWidth() - smallIcon.getIconWidth(), y += mouseIcon.getIconHeight() - smallIcon.getIconHeight());
                }
            }

            @Override
            public int getIconWidth() {
                return mouseIcon.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return mouseIcon.getIconHeight();
            }
        });
    }

    public DropDownButton getDropDownButton(String type) {
        if ("left".equals(type)) {
            return this.mouseLeft;
        }
        if ("right".equals(type)) {
            return this.mouseRight;
        }
        if ("middle".equals(type)) {
            return this.mouseMiddle;
        }
        if ("wheel".equals(type)) {
            return this.mouseWheel;
        }
        return null;
    }

    private ActionW getAction(ActionW[] actions, String command) {
        if (actions != null) {
            for (ActionW a : actions) {
                if (!a.cmd().equals(command)) continue;
                return a;
            }
        }
        return null;
    }

    private Icon getMouseIcon(String type) {
        if ("left".equals(type)) {
            return MouseLeftIcon;
        }
        if ("right".equals(type)) {
            return MouseRightIcon;
        }
        if ("middle".equals(type)) {
            return MouseMiddleIcon;
        }
        if ("wheel".equals(type)) {
            return MouseWheelIcon;
        }
        return MouseLeftIcon;
    }

    public static final ActionW getNextCommand(ActionW[] actions, String command) {
        if (actions != null && actions.length > 0) {
            int index = 0;
            for (int i = 0; i < actions.length; ++i) {
                if (!actions[i].cmd().equals(command)) continue;
                index = i == actions.length - 1 ? 0 : i + 1;
            }
            return actions[index];
        }
        return null;
    }
}

