/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

public class Measurement {
    private final String name;
    private final boolean quickComputing;
    private boolean computed;
    private boolean graphicLabel;

    public Measurement(String name, boolean quickComputing) {
        this(name, quickComputing, true, true);
    }

    public Measurement(String name, boolean quickComputing, boolean computed, boolean graphicLabel) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null!");
        }
        this.name = name;
        this.quickComputing = quickComputing;
        this.computed = computed;
        this.graphicLabel = graphicLabel;
    }

    public String getName() {
        return this.name;
    }

    public boolean isComputed() {
        return this.computed;
    }

    public void setComputed(boolean computed) {
        this.computed = computed;
        if (!computed && this.graphicLabel) {
            this.graphicLabel = false;
        }
    }

    public boolean isGraphicLabel() {
        return this.graphicLabel;
    }

    public void setGraphicLabel(boolean graphicLabel) {
        this.graphicLabel = graphicLabel;
        if (graphicLabel && !this.computed) {
            this.computed = true;
        }
    }

    public boolean isQuickComputing() {
        return this.quickComputing;
    }
}

