/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.util.Hashtable;
import java.util.Map;

public class TransferSyntax {
    public static final TransferSyntax ImplicitVRLittleEndian = new TransferSyntax("1.2.840.10008.1.2", false, false, false, false);
    public static final TransferSyntax ImplicitVRBigEndian = new TransferSyntax("1.2.840.113619.5.2", false, true, false, false);
    public static final TransferSyntax ExplicitVRLittleEndian = new TransferSyntax("1.2.840.10008.1.2.1", true, false, false, false);
    public static final TransferSyntax ExplicitVRBigEndian = new TransferSyntax("1.2.840.10008.1.2.2", true, true, false, false);
    public static final TransferSyntax DeflatedExplicitVRLittleEndian = new TransferSyntax("1.2.840.10008.1.2.1.99", true, false, true, false);
    public static final TransferSyntax NoPixelData = new TransferSyntax("1.2.840.10008.1.2.4.96", true, false, false, false);
    public static final TransferSyntax NoPixelDataDeflate = new TransferSyntax("1.2.840.10008.1.2.4.97", true, false, true, false);
    private static final Map<String, TransferSyntax> map = new Hashtable<String, TransferSyntax>();
    private final String uid;
    private final boolean bigEndian;
    private final boolean explicitVR;
    private final boolean deflated;
    private final boolean encapsulated;

    public static void add(TransferSyntax ts) {
        map.put(ts.uid, ts);
    }

    public static TransferSyntax remove(String tsuid) {
        return map.remove(tsuid);
    }

    public static TransferSyntax valueOf(String uid) {
        if (uid == null) {
            throw new NullPointerException("uid");
        }
        TransferSyntax ts = map.get(uid);
        return ts != null ? ts : new TransferSyntax(uid, true, false, false, true);
    }

    public TransferSyntax(String uid, boolean explicitVR, boolean bigEndian, boolean deflated, boolean encapsulated) {
        this.uid = uid;
        this.explicitVR = explicitVR;
        this.bigEndian = bigEndian;
        this.deflated = deflated;
        this.encapsulated = encapsulated;
    }

    public final String uid() {
        return this.uid;
    }

    public final boolean bigEndian() {
        return this.bigEndian;
    }

    public final boolean explicitVR() {
        return this.explicitVR;
    }

    public final boolean deflated() {
        return this.deflated;
    }

    public final boolean encapsulated() {
        return this.encapsulated;
    }

    public final boolean uncompressed() {
        return !this.deflated && !this.encapsulated;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof TransferSyntax)) {
            return false;
        }
        return this.uid().equals(((TransferSyntax)o2).uid());
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    static {
        TransferSyntax.add(ImplicitVRLittleEndian);
        TransferSyntax.add(ImplicitVRBigEndian);
        TransferSyntax.add(ExplicitVRLittleEndian);
        TransferSyntax.add(ExplicitVRBigEndian);
        TransferSyntax.add(DeflatedExplicitVRLittleEndian);
        TransferSyntax.add(NoPixelData);
        TransferSyntax.add(NoPixelDataDeflate);
    }
}

