/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

class RAFInputStreamAdapter
extends InputStream {
    private final RandomAccessFile raf;
    private long markedPos;
    private IOException markException;

    public RAFInputStreamAdapter(RandomAccessFile raf) {
        this.raf = raf;
    }

    public int read() throws IOException {
        return this.raf.read();
    }

    public synchronized void mark(int readlimit) {
        try {
            this.markedPos = this.raf.getFilePointer();
            this.markException = null;
        }
        catch (IOException e) {
            this.markException = e;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.raf.read(b, off, len);
    }

    public synchronized void reset() throws IOException {
        if (this.markException != null) {
            throw this.markException;
        }
        this.raf.seek(this.markedPos);
    }

    public long skip(long n) throws IOException {
        return this.raf.skipBytes((int)n);
    }
}

