/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.metadata;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.scr.impl.helper.Logger;
import org.apache.felix.scr.impl.metadata.PropertyMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.osgi.service.component.ComponentException;

public class ComponentMetadata {
    public static final String CONFIGURATION_POLICY_REQUIRE = "require";
    public static final String CONFIGURATION_POLICY_IGNORE = "ignore";
    public static final String CONFIGURATION_POLICY_OPTIONAL = "optional";
    private static final Set CONFIGURATION_POLICY_VALID;
    private static final String IMPLEMENTATION_CLASS_DUPLICATE = "icd";
    private static final ServiceMetadata SERVICE_DUPLICATE;
    private final int m_namespaceCode;
    private String m_name;
    private boolean m_enabled = true;
    private String m_factory = null;
    private Boolean m_immediate = null;
    private String m_implementationClassName = null;
    private String m_activate = null;
    private boolean m_activateDeclared = false;
    private String m_deactivate = null;
    private boolean m_deactivateDeclared = false;
    private String m_modified = null;
    private String m_configurationPolicy = null;
    private Dictionary m_properties = new Hashtable();
    private List m_propertyMetaData = new ArrayList();
    private ServiceMetadata m_service = null;
    private List m_references = new ArrayList();
    private boolean m_validated = false;

    public ComponentMetadata(int namespaceCode) {
        this.m_namespaceCode = namespaceCode;
    }

    public void setName(String name) {
        if (this.m_validated) {
            return;
        }
        this.m_name = name;
    }

    public void setEnabled(boolean enabled) {
        if (this.m_validated) {
            return;
        }
        this.m_enabled = enabled;
    }

    public void setFactoryIdentifier(String factoryIdentifier) {
        if (this.m_validated) {
            return;
        }
        this.m_factory = factoryIdentifier;
    }

    public void setImmediate(boolean immediate) {
        if (this.m_validated) {
            return;
        }
        this.m_immediate = immediate ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setImplementationClassName(String implementationClassName) {
        if (this.m_validated) {
            return;
        }
        this.m_implementationClassName = this.m_implementationClassName != null ? IMPLEMENTATION_CLASS_DUPLICATE : implementationClassName;
    }

    public void setConfigurationPolicy(String configurationPolicy) {
        if (this.m_validated) {
            return;
        }
        this.m_configurationPolicy = configurationPolicy;
    }

    public void setActivate(String activate) {
        if (this.m_validated) {
            return;
        }
        this.m_activate = activate;
        this.m_activateDeclared = true;
    }

    public void setDeactivate(String deactivate) {
        if (this.m_validated) {
            return;
        }
        this.m_deactivate = deactivate;
        this.m_deactivateDeclared = true;
    }

    public void setModified(String modified) {
        if (this.m_validated) {
            return;
        }
        this.m_modified = modified;
    }

    public void addProperty(PropertyMetadata newProperty) {
        if (this.m_validated) {
            return;
        }
        if (newProperty == null) {
            throw new IllegalArgumentException("Cannot add a null property");
        }
        this.m_propertyMetaData.add(newProperty);
    }

    public void setService(ServiceMetadata service) {
        if (this.m_validated) {
            return;
        }
        this.m_service = this.m_service != null ? SERVICE_DUPLICATE : service;
    }

    public void addDependency(ReferenceMetadata newReference) {
        if (this.m_validated) {
            return;
        }
        if (newReference == null) {
            throw new IllegalArgumentException("Cannot add a null ReferenceMetadata");
        }
        this.m_references.add(newReference);
    }

    public int getNamespaceCode() {
        return this.m_namespaceCode;
    }

    public boolean isDS11() {
        return this.getNamespaceCode() >= 1;
    }

    public boolean isDS11Felix() {
        return this.getNamespaceCode() >= 2;
    }

    public String getName() {
        if (this.m_name != null) {
            return this.m_name;
        }
        return this.getImplementationClassName();
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public String getFactoryIdentifier() {
        return this.m_factory;
    }

    public boolean isImmediate() {
        if (this.m_immediate != null) {
            return this.m_immediate;
        }
        return this.m_service == null && this.m_factory == null;
    }

    public String getImplementationClassName() {
        return this.m_implementationClassName;
    }

    public String getConfigurationPolicy() {
        return this.m_configurationPolicy;
    }

    public String getActivate() {
        return this.m_activate;
    }

    public boolean isActivateDeclared() {
        return this.m_activateDeclared;
    }

    public String getDeactivate() {
        return this.m_deactivate;
    }

    public boolean isDeactivateDeclared() {
        return this.m_deactivateDeclared;
    }

    public String getModified() {
        return this.m_modified;
    }

    public ServiceMetadata getServiceMetadata() {
        return this.m_service;
    }

    public Dictionary getProperties() {
        return this.m_properties;
    }

    List getPropertyMetaData() {
        return this.m_propertyMetaData;
    }

    public List getDependencies() {
        return this.m_references;
    }

    public boolean isFactory() {
        return this.m_factory != null;
    }

    public boolean isConfigurationRequired() {
        return CONFIGURATION_POLICY_REQUIRE.equals(this.m_configurationPolicy);
    }

    public boolean isConfigurationIgnored() {
        return CONFIGURATION_POLICY_IGNORE.equals(this.m_configurationPolicy);
    }

    public boolean isConfigurationOptional() {
        return CONFIGURATION_POLICY_OPTIONAL.equals(this.m_configurationPolicy);
    }

    public void validate(Logger logger) {
        if (this.m_validated) {
            return;
        }
        if (this.m_name == null) {
            if (this.m_namespaceCode < 1) {
                throw new ComponentException("The component name has not been set");
            }
            this.setName(this.getImplementationClassName());
        }
        if (this.m_implementationClassName == null) {
            throw this.validationFailure("Implementation class name missing");
        }
        if (this.m_implementationClassName == IMPLEMENTATION_CLASS_DUPLICATE) {
            throw this.validationFailure("Implementation element must occur exactly once");
        }
        if (this.m_configurationPolicy == null) {
            this.m_configurationPolicy = CONFIGURATION_POLICY_OPTIONAL;
        } else {
            if (this.m_namespaceCode < 1) {
                throw this.validationFailure("configuration-policy declaration requires DS 1.1 or later namespace ");
            }
            if (!CONFIGURATION_POLICY_VALID.contains(this.m_configurationPolicy)) {
                throw this.validationFailure("configuration-policy must be one of " + CONFIGURATION_POLICY_VALID);
            }
        }
        if (this.m_activate == null) {
            this.m_activate = "activate";
        } else if (this.m_namespaceCode < 1) {
            throw this.validationFailure("activate method declaration requires DS 1.1 or later namespace ");
        }
        if (this.m_deactivate == null) {
            this.m_deactivate = "deactivate";
        } else if (this.m_namespaceCode < 1) {
            throw this.validationFailure("deactivate method declaration requires DS 1.1 or later namespace ");
        }
        if (this.m_modified != null && this.m_namespaceCode < 1) {
            throw this.validationFailure("modified method declaration requires DS 1.1 or later namespace ");
        }
        Iterator propertyIterator = this.m_propertyMetaData.iterator();
        while (propertyIterator.hasNext()) {
            PropertyMetadata propMeta = (PropertyMetadata)propertyIterator.next();
            propMeta.validate(this);
            this.m_properties.put(propMeta.getName(), propMeta.getValue());
        }
        this.m_propertyMetaData.clear();
        if (this.m_service == SERVICE_DUPLICATE) {
            throw this.validationFailure("Service element must occur at most once");
        }
        if (this.m_service != null) {
            this.m_service.validate(this);
        }
        HashSet<String> refs = new HashSet<String>();
        Iterator referenceIterator = this.m_references.iterator();
        while (referenceIterator.hasNext()) {
            ReferenceMetadata refMeta = (ReferenceMetadata)referenceIterator.next();
            refMeta.validate(this, logger);
            if (refs.add(refMeta.getName())) continue;
            logger.log(2, "Detected duplicate reference name: ''{0}''", new Object[]{refMeta.getName()}, this, null);
        }
        if (this.m_immediate != null) {
            if (this.isImmediate()) {
                if (this.isFactory()) {
                    throw this.validationFailure("Factory cannot be immediate");
                }
            } else if (this.m_service == null && !this.isFactory()) {
                throw this.validationFailure("Delayed must provide a service or be a factory");
            }
        }
        if (this.m_service != null && this.m_service.isServiceFactory() && (this.isFactory() || this.isImmediate())) {
            throw this.validationFailure("ServiceFactory cannot be factory or immediate");
        }
        this.m_validated = true;
    }

    ComponentException validationFailure(String reason) {
        return new ComponentException("Component " + this.getName() + " validation failed: " + reason);
    }

    static {
        SERVICE_DUPLICATE = new ServiceMetadata();
        CONFIGURATION_POLICY_VALID = new TreeSet();
        CONFIGURATION_POLICY_VALID.add(CONFIGURATION_POLICY_IGNORE);
        CONFIGURATION_POLICY_VALID.add(CONFIGURATION_POLICY_OPTIONAL);
        CONFIGURATION_POLICY_VALID.add(CONFIGURATION_POLICY_REQUIRE);
    }
}

