/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.weasis.core.api.Messages;
import org.weasis.core.api.gui.util.FileFormatFilter;

public abstract class AbstractBufferHandler {
    protected String lastPath;
    private String path;
    private boolean isDirty;
    private final Component parent;
    private String addOpenMessage = "";
    private static Float version;
    private FileFilter fileFilter;

    public AbstractBufferHandler(Component component) {
        this.parent = component;
    }

    public void setDirty(boolean flag) {
        this.isDirty = flag;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void setPath(String s) {
        this.path = s;
        if (s != null) {
            this.lastPath = s;
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getLastValidPath() {
        return this.lastPath;
    }

    public boolean newDocument() {
        if (this.isDirty() && !this.canCloseDocument()) {
            return false;
        }
        this.setDirty(false);
        this.setPath(null);
        this.handleNewDocument();
        return true;
    }

    public boolean openDocument() {
        File file;
        if (this.isDirty() && !this.canCloseDocument()) {
            return false;
        }
        JFileChooser jfilechooser = this.getOpenFileChooser();
        if (jfilechooser.showOpenDialog(this.getParentComponent()) != 0 || (file = jfilechooser.getSelectedFile()) == null) {
            return false;
        }
        return this.openDocument(file.getPath(), false);
    }

    protected boolean openDocument(String s) {
        return this.openDocument(s, true);
    }

    protected boolean openDocument(String s, boolean flag) {
        if (flag && this.isDirty() && !this.canCloseDocument()) {
            return false;
        }
        this.setPath(s);
        if (!this.handleOpenDocument(s)) {
            File f = new File(s);
            JOptionPane.showMessageDialog(this.getParentComponent(), String.format(Messages.getString("AbstractBufferHandler.unable_open"), f.getName()) + this.addOpenMessage, Messages.getString("AbstractBufferHandler.open"), 0);
            this.setPath(null);
            this.addOpenMessage = "";
            return false;
        }
        this.isDirty = false;
        return true;
    }

    public boolean saveDocument() {
        if (this.path == null) {
            return this.saveAsDocument();
        }
        if (!this.handleSaveDocument(this.getPath())) {
            JOptionPane.showMessageDialog(this.getParentComponent(), Messages.getString("AbstractBufferHandler.unable_save"), Messages.getString("AbstractBufferHandler.save"), 0);
            File file = new File(this.getPath());
            file.delete();
            return false;
        }
        this.isDirty = false;
        return true;
    }

    public boolean saveAsDocument() {
        int i;
        JFileChooser jfilechooser = this.getSaveFileChooser();
        if (jfilechooser.showSaveDialog(this.getParentComponent()) != 0) {
            return false;
        }
        File file = jfilechooser.getSelectedFile();
        String extension = null;
        try {
            extension = "." + ((FileFormatFilter)jfilechooser.getFileFilter()).getDefaultExtension();
        }
        catch (Exception ex) {
            extension = "";
        }
        String filename = file.getPath().endsWith(extension) ? file.getPath() : file.getPath() + extension;
        file = new File(filename);
        if (file.exists() && (i = JOptionPane.showConfirmDialog(this.getParentComponent(), String.format(Messages.getString("AbstractBufferHandler.exist"), file.getName()), Messages.getString("AbstractBufferHandler.save_as"), 0)) != 0) {
            return false;
        }
        this.setPath(file.getPath());
        this.fileFilter = jfilechooser.getFileFilter();
        if (!this.handleSaveDocument(this.getPath())) {
            JOptionPane.showMessageDialog(this.getParentComponent(), Messages.getString("AbstractBufferHandler.unable_save"), Messages.getString("AbstractBufferHandler.save"), 0);
            file.delete();
            return false;
        }
        this.isDirty = false;
        return true;
    }

    protected boolean canCloseDocument() {
        if (this.isDirty) {
            int i = JOptionPane.showConfirmDialog(this.getParentComponent(), Messages.getString("AbstractBufferHandler.unsave_msg"), Messages.getString("AbstractBufferHandler.unsave_t"), 1);
            if (i == 0) {
                return this.saveDocument();
            }
            if (i == 2) {
                return false;
            }
        }
        return true;
    }

    protected JFileChooser configureForLastPath(JFileChooser jfilechooser) {
        String s = this.getLastValidPath();
        if (s != null) {
            try {
                File file = new File(new File(s).getParent());
                jfilechooser.setCurrentDirectory(file);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return jfilechooser;
    }

    protected JFileChooser getOpenFileChooser() {
        String targetVersion;
        String jVersion = System.getProperty("java.version");
        JFileChooser fileChooser = jVersion.startsWith(targetVersion = "1.5.") ? new JFileChooser(){

            @Override
            public void setFileFilter(FileFilter filter) {
                super.setFileFilter(filter);
                if (!(this.getUI() instanceof BasicFileChooserUI)) {
                    return;
                }
                final BasicFileChooserUI ui = (BasicFileChooserUI)this.getUI();
                final String name = ui.getFileName().trim();
                if (name == null || name.length() == 0) {
                    return;
                }
                EventQueue.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        String currentName = ui.getFileName();
                        if (currentName == null || currentName.length() == 0) {
                            ui.setFileName(name);
                        }
                    }
                });
            }
        } : new JFileChooser();
        fileChooser.setDialogType(0);
        return this.configureForLastPath(fileChooser);
    }

    protected JFileChooser getSaveFileChooser() {
        JFileChooser fileChooser = new JFileChooser(){

            @Override
            public void setFileFilter(FileFilter filter) {
                super.setFileFilter(filter);
                if (!(this.getUI() instanceof BasicFileChooserUI)) {
                    return;
                }
                final BasicFileChooserUI ui = (BasicFileChooserUI)this.getUI();
                final String name = ui.getFileName().trim();
                if (name == null || name.length() == 0) {
                    return;
                }
                EventQueue.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        String currentName = ui.getFileName();
                        if (currentName == null || currentName.length() == 0) {
                            ui.setFileName(name);
                        }
                    }
                });
            }
        };
        fileChooser.setDialogType(1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        return this.configureForLastPath(fileChooser);
    }

    protected Component getParentComponent() {
        return this.parent;
    }

    protected abstract void handleNewDocument();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleOpenDocument(String s) {
        FileInputStream fileinputstream = null;
        boolean flag = true;
        try {
            fileinputstream = new FileInputStream(s);
            flag = this.handleOpenDocument(fileinputstream);
        }
        catch (FileNotFoundException filenotfoundexception) {
            flag = false;
        }
        finally {
            if (fileinputstream != null) {
                try {
                    fileinputstream.close();
                }
                catch (IOException ioexception) {}
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleSaveDocument(String s) {
        FileOutputStream fileoutputstream = null;
        boolean flag = true;
        try {
            fileoutputstream = new FileOutputStream(s);
            flag = this.handleSaveDocument(fileoutputstream);
        }
        catch (FileNotFoundException filenotfoundexception) {
            flag = false;
        }
        finally {
            if (fileoutputstream != null) {
                try {
                    fileoutputstream.flush();
                    fileoutputstream.close();
                }
                catch (IOException ioexception) {}
            }
        }
        return flag;
    }

    protected abstract boolean handleOpenDocument(InputStream var1);

    protected abstract boolean handleSaveDocument(OutputStream var1);

    public void setAddOpenMessage(String addOpenMessage) {
        this.addOpenMessage = addOpenMessage;
    }

    public static void setVersion(Float fileVersion) {
        version = fileVersion;
    }

    public String getAddOpenMessage() {
        return this.addOpenMessage;
    }

    public static Float getVersion() {
        return version;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }
}

